/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import sun.security.util.SecurityProviderConstants;

public final class SunJCE
extends Provider {
    private static final long serialVersionUID = 6812507587804302833L;
    private static final String info = "SunJCE Provider (implements RSA, DES, Triple DES, AES, Blowfish, ARCFOUR, RC2, PBE, Diffie-Hellman, HMAC)";
    static final boolean debug = false;
    private static volatile SunJCE instance = null;

    static SecureRandom getRandom() {
        return SecureRandomHolder.RANDOM;
    }

    private void ps(String string, String string2, String string3) {
        this.putService(new Provider.Service(this, string, string2, string3, null, null));
    }

    private void ps(String string, String string2, String string3, List<String> list, HashMap<String, String> hashMap) {
        this.putService(new Provider.Service(this, string, string2, string3, list, hashMap));
    }

    private void psA(String string, String string2, String string3, HashMap<String, String> hashMap) {
        this.putService(new Provider.Service(this, string, string2, string3, SecurityProviderConstants.getAliases(string2), hashMap));
    }

    public SunJCE() {
        super("SunJCE", 1.8, info);
        if (System.getSecurityManager() == null) {
            this.putEntries();
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    SunJCE.this.putEntries();
                    return null;
                }
            });
        }
        if (instance == null) {
            instance = this;
        }
    }

    void putEntries() {
        HashMap<String, String> hashMap = new HashMap<String, String>(3);
        hashMap.put("SupportedModes", "ECB");
        hashMap.put("SupportedPaddings", "NOPADDING|PKCS1PADDING|OAEPPADDING|OAEPWITHMD5ANDMGF1PADDING|OAEPWITHSHA1ANDMGF1PADDING|OAEPWITHSHA-1ANDMGF1PADDING|OAEPWITHSHA-224ANDMGF1PADDING|OAEPWITHSHA-256ANDMGF1PADDING|OAEPWITHSHA-384ANDMGF1PADDING|OAEPWITHSHA-512ANDMGF1PADDING|OAEPWITHSHA-512/224ANDMGF1PADDING|OAEPWITHSHA-512/256ANDMGF1PADDING");
        hashMap.put("SupportedKeyClasses", "java.security.interfaces.RSAPublicKey|java.security.interfaces.RSAPrivateKey");
        this.ps("Cipher", "RSA", "com.sun.crypto.provider.RSACipher", null, hashMap);
        hashMap.clear();
        hashMap.put("SupportedModes", "ECB|CBC|PCBC|CTR|CTS|CFB|OFB|CFB8|CFB16|CFB24|CFB32|CFB40|CFB48|CFB56|CFB64|OFB8|OFB16|OFB24|OFB32|OFB40|OFB48|OFB56|OFB64");
        hashMap.put("SupportedPaddings", "NOPADDING|PKCS5PADDING|ISO10126PADDING");
        hashMap.put("SupportedKeyFormats", "RAW");
        this.ps("Cipher", "DES", "com.sun.crypto.provider.DESCipher", null, hashMap);
        this.psA("Cipher", "DESede", "com.sun.crypto.provider.DESedeCipher", hashMap);
        this.ps("Cipher", "Blowfish", "com.sun.crypto.provider.BlowfishCipher", null, hashMap);
        this.ps("Cipher", "RC2", "com.sun.crypto.provider.RC2Cipher", null, hashMap);
        hashMap.clear();
        hashMap.put("SupportedModes", "ECB|CBC|PCBC|CTR|CTS|CFB|OFB|CFB8|CFB16|CFB24|CFB32|CFB40|CFB48|CFB56|CFB64|OFB8|OFB16|OFB24|OFB32|OFB40|OFB48|OFB56|OFB64|GCM|CFB72|CFB80|CFB88|CFB96|CFB104|CFB112|CFB120|CFB128|OFB72|OFB80|OFB88|OFB96|OFB104|OFB112|OFB120|OFB128");
        hashMap.put("SupportedPaddings", "NOPADDING|PKCS5PADDING|ISO10126PADDING");
        hashMap.put("SupportedKeyFormats", "RAW");
        this.psA("Cipher", "AES", "com.sun.crypto.provider.AESCipher$General", hashMap);
        hashMap.clear();
        hashMap.put("SupportedKeyFormats", "RAW");
        this.psA("Cipher", "AES_128/ECB/NoPadding", "com.sun.crypto.provider.AESCipher$AES128_ECB_NoPadding", hashMap);
        this.psA("Cipher", "AES_128/CBC/NoPadding", "com.sun.crypto.provider.AESCipher$AES128_CBC_NoPadding", hashMap);
        this.psA("Cipher", "AES_128/OFB/NoPadding", "com.sun.crypto.provider.AESCipher$AES128_OFB_NoPadding", hashMap);
        this.psA("Cipher", "AES_128/CFB/NoPadding", "com.sun.crypto.provider.AESCipher$AES128_CFB_NoPadding", hashMap);
        this.psA("Cipher", "AES_128/GCM/NoPadding", "com.sun.crypto.provider.AESCipher$AES128_GCM_NoPadding", hashMap);
        this.psA("Cipher", "AES_192/ECB/NoPadding", "com.sun.crypto.provider.AESCipher$AES192_ECB_NoPadding", hashMap);
        this.psA("Cipher", "AES_192/CBC/NoPadding", "com.sun.crypto.provider.AESCipher$AES192_CBC_NoPadding", hashMap);
        this.psA("Cipher", "AES_192/OFB/NoPadding", "com.sun.crypto.provider.AESCipher$AES192_OFB_NoPadding", hashMap);
        this.psA("Cipher", "AES_192/CFB/NoPadding", "com.sun.crypto.provider.AESCipher$AES192_CFB_NoPadding", hashMap);
        this.psA("Cipher", "AES_192/GCM/NoPadding", "com.sun.crypto.provider.AESCipher$AES192_GCM_NoPadding", hashMap);
        this.psA("Cipher", "AES_256/ECB/NoPadding", "com.sun.crypto.provider.AESCipher$AES256_ECB_NoPadding", hashMap);
        this.psA("Cipher", "AES_256/CBC/NoPadding", "com.sun.crypto.provider.AESCipher$AES256_CBC_NoPadding", hashMap);
        this.psA("Cipher", "AES_256/OFB/NoPadding", "com.sun.crypto.provider.AESCipher$AES256_OFB_NoPadding", hashMap);
        this.psA("Cipher", "AES_256/CFB/NoPadding", "com.sun.crypto.provider.AESCipher$AES256_CFB_NoPadding", hashMap);
        this.psA("Cipher", "AES_256/GCM/NoPadding", "com.sun.crypto.provider.AESCipher$AES256_GCM_NoPadding", hashMap);
        hashMap.clear();
        hashMap.put("SupportedModes", "CBC");
        hashMap.put("SupportedPaddings", "NOPADDING");
        hashMap.put("SupportedKeyFormats", "RAW");
        this.ps("Cipher", "DESedeWrap", "com.sun.crypto.provider.DESedeWrapCipher", null, hashMap);
        hashMap.clear();
        hashMap.put("SupportedModes", "ECB");
        hashMap.put("SupportedPaddings", "NOPADDING");
        hashMap.put("SupportedKeyFormats", "RAW");
        this.psA("Cipher", "ARCFOUR", "com.sun.crypto.provider.ARCFOURCipher", hashMap);
        this.ps("Cipher", "AESWrap", "com.sun.crypto.provider.AESWrapCipher$General", null, hashMap);
        this.psA("Cipher", "AESWrap_128", "com.sun.crypto.provider.AESWrapCipher$AES128", hashMap);
        this.psA("Cipher", "AESWrap_192", "com.sun.crypto.provider.AESWrapCipher$AES192", hashMap);
        this.psA("Cipher", "AESWrap_256", "com.sun.crypto.provider.AESWrapCipher$AES256", hashMap);
        this.psA("Cipher", "PBEWithMD5AndDES", "com.sun.crypto.provider.PBEWithMD5AndDESCipher", null);
        this.ps("Cipher", "PBEWithMD5AndTripleDES", "com.sun.crypto.provider.PBEWithMD5AndTripleDESCipher", null, null);
        this.psA("Cipher", "PBEWithSHA1AndDESede", "com.sun.crypto.provider.PKCS12PBECipherCore$PBEWithSHA1AndDESede", null);
        this.psA("Cipher", "PBEWithSHA1AndRC2_40", "com.sun.crypto.provider.PKCS12PBECipherCore$PBEWithSHA1AndRC2_40", null);
        this.psA("Cipher", "PBEWithSHA1AndRC2_128", "com.sun.crypto.provider.PKCS12PBECipherCore$PBEWithSHA1AndRC2_128", null);
        this.psA("Cipher", "PBEWithSHA1AndRC4_40", "com.sun.crypto.provider.PKCS12PBECipherCore$PBEWithSHA1AndRC4_40", null);
        this.psA("Cipher", "PBEWithSHA1AndRC4_128", "com.sun.crypto.provider.PKCS12PBECipherCore$PBEWithSHA1AndRC4_128", null);
        this.ps("Cipher", "PBEWithHmacSHA1AndAES_128", "com.sun.crypto.provider.PBES2Core$HmacSHA1AndAES_128");
        this.ps("Cipher", "PBEWithHmacSHA224AndAES_128", "com.sun.crypto.provider.PBES2Core$HmacSHA224AndAES_128");
        this.ps("Cipher", "PBEWithHmacSHA256AndAES_128", "com.sun.crypto.provider.PBES2Core$HmacSHA256AndAES_128");
        this.ps("Cipher", "PBEWithHmacSHA384AndAES_128", "com.sun.crypto.provider.PBES2Core$HmacSHA384AndAES_128");
        this.ps("Cipher", "PBEWithHmacSHA512AndAES_128", "com.sun.crypto.provider.PBES2Core$HmacSHA512AndAES_128");
        this.ps("Cipher", "PBEWithHmacSHA1AndAES_256", "com.sun.crypto.provider.PBES2Core$HmacSHA1AndAES_256");
        this.ps("Cipher", "PBEWithHmacSHA224AndAES_256", "com.sun.crypto.provider.PBES2Core$HmacSHA224AndAES_256");
        this.ps("Cipher", "PBEWithHmacSHA256AndAES_256", "com.sun.crypto.provider.PBES2Core$HmacSHA256AndAES_256");
        this.ps("Cipher", "PBEWithHmacSHA384AndAES_256", "com.sun.crypto.provider.PBES2Core$HmacSHA384AndAES_256");
        this.ps("Cipher", "PBEWithHmacSHA512AndAES_256", "com.sun.crypto.provider.PBES2Core$HmacSHA512AndAES_256");
        this.ps("KeyGenerator", "DES", "com.sun.crypto.provider.DESKeyGenerator");
        this.psA("KeyGenerator", "DESede", "com.sun.crypto.provider.DESedeKeyGenerator", null);
        this.ps("KeyGenerator", "Blowfish", "com.sun.crypto.provider.BlowfishKeyGenerator");
        this.psA("KeyGenerator", "AES", "com.sun.crypto.provider.AESKeyGenerator", null);
        this.ps("KeyGenerator", "RC2", "com.sun.crypto.provider.KeyGeneratorCore$RC2KeyGenerator");
        this.psA("KeyGenerator", "ARCFOUR", "com.sun.crypto.provider.KeyGeneratorCore$ARCFOURKeyGenerator", null);
        this.ps("KeyGenerator", "HmacMD5", "com.sun.crypto.provider.HmacMD5KeyGenerator");
        this.psA("KeyGenerator", "HmacSHA1", "com.sun.crypto.provider.HmacSHA1KeyGenerator", null);
        this.psA("KeyGenerator", "HmacSHA224", "com.sun.crypto.provider.KeyGeneratorCore$HmacSHA2KG$SHA224", null);
        this.psA("KeyGenerator", "HmacSHA256", "com.sun.crypto.provider.KeyGeneratorCore$HmacSHA2KG$SHA256", null);
        this.psA("KeyGenerator", "HmacSHA384", "com.sun.crypto.provider.KeyGeneratorCore$HmacSHA2KG$SHA384", null);
        this.psA("KeyGenerator", "HmacSHA512", "com.sun.crypto.provider.KeyGeneratorCore$HmacSHA2KG$SHA512", null);
        this.psA("KeyPairGenerator", "DiffieHellman", "com.sun.crypto.provider.DHKeyPairGenerator", null);
        this.psA("AlgorithmParameterGenerator", "DiffieHellman", "com.sun.crypto.provider.DHParameterGenerator", null);
        hashMap.clear();
        hashMap.put("SupportedKeyClasses", "javax.crypto.interfaces.DHPublicKey|javax.crypto.interfaces.DHPrivateKey");
        this.psA("KeyAgreement", "DiffieHellman", "com.sun.crypto.provider.DHKeyAgreement", hashMap);
        this.psA("AlgorithmParameters", "DiffieHellman", "com.sun.crypto.provider.DHParameters", null);
        this.ps("AlgorithmParameters", "DES", "com.sun.crypto.provider.DESParameters", null, null);
        this.psA("AlgorithmParameters", "DESede", "com.sun.crypto.provider.DESedeParameters", null);
        this.psA("AlgorithmParameters", "PBEWithMD5AndDES", "com.sun.crypto.provider.PBEParameters", null);
        this.ps("AlgorithmParameters", "PBEWithMD5AndTripleDES", "com.sun.crypto.provider.PBEParameters", null, null);
        this.psA("AlgorithmParameters", "PBEWithSHA1AndDESede", "com.sun.crypto.provider.PBEParameters", null);
        this.psA("AlgorithmParameters", "PBEWithSHA1AndRC2_40", "com.sun.crypto.provider.PBEParameters", null);
        this.psA("AlgorithmParameters", "PBEWithSHA1AndRC2_128", "com.sun.crypto.provider.PBEParameters", null);
        this.psA("AlgorithmParameters", "PBEWithSHA1AndRC4_40", "com.sun.crypto.provider.PBEParameters", null);
        this.psA("AlgorithmParameters", "PBEWithSHA1AndRC4_128", "com.sun.crypto.provider.PBEParameters", null);
        this.psA("AlgorithmParameters", "PBES2", "com.sun.crypto.provider.PBES2Parameters$General", null);
        this.ps("AlgorithmParameters", "PBEWithHmacSHA1AndAES_128", "com.sun.crypto.provider.PBES2Parameters$HmacSHA1AndAES_128");
        this.ps("AlgorithmParameters", "PBEWithHmacSHA224AndAES_128", "com.sun.crypto.provider.PBES2Parameters$HmacSHA224AndAES_128");
        this.ps("AlgorithmParameters", "PBEWithHmacSHA256AndAES_128", "com.sun.crypto.provider.PBES2Parameters$HmacSHA256AndAES_128");
        this.ps("AlgorithmParameters", "PBEWithHmacSHA384AndAES_128", "com.sun.crypto.provider.PBES2Parameters$HmacSHA384AndAES_128");
        this.ps("AlgorithmParameters", "PBEWithHmacSHA512AndAES_128", "com.sun.crypto.provider.PBES2Parameters$HmacSHA512AndAES_128");
        this.ps("AlgorithmParameters", "PBEWithHmacSHA1AndAES_256", "com.sun.crypto.provider.PBES2Parameters$HmacSHA1AndAES_256");
        this.ps("AlgorithmParameters", "PBEWithHmacSHA224AndAES_256", "com.sun.crypto.provider.PBES2Parameters$HmacSHA224AndAES_256");
        this.ps("AlgorithmParameters", "PBEWithHmacSHA256AndAES_256", "com.sun.crypto.provider.PBES2Parameters$HmacSHA256AndAES_256");
        this.ps("AlgorithmParameters", "PBEWithHmacSHA384AndAES_256", "com.sun.crypto.provider.PBES2Parameters$HmacSHA384AndAES_256");
        this.ps("AlgorithmParameters", "PBEWithHmacSHA512AndAES_256", "com.sun.crypto.provider.PBES2Parameters$HmacSHA512AndAES_256");
        this.ps("AlgorithmParameters", "Blowfish", "com.sun.crypto.provider.BlowfishParameters");
        this.psA("AlgorithmParameters", "AES", "com.sun.crypto.provider.AESParameters", null);
        this.ps("AlgorithmParameters", "GCM", "com.sun.crypto.provider.GCMParameters");
        this.ps("AlgorithmParameters", "RC2", "com.sun.crypto.provider.RC2Parameters");
        this.ps("AlgorithmParameters", "OAEP", "com.sun.crypto.provider.OAEPParameters");
        this.psA("KeyFactory", "DiffieHellman", "com.sun.crypto.provider.DHKeyFactory", null);
        this.ps("SecretKeyFactory", "DES", "com.sun.crypto.provider.DESKeyFactory");
        this.psA("SecretKeyFactory", "DESede", "com.sun.crypto.provider.DESedeKeyFactory", null);
        this.psA("SecretKeyFactory", "PBEWithMD5AndDES", "com.sun.crypto.provider.PBEKeyFactory$PBEWithMD5AndDES", null);
        this.ps("SecretKeyFactory", "PBEWithMD5AndTripleDES", "com.sun.crypto.provider.PBEKeyFactory$PBEWithMD5AndTripleDES");
        this.psA("SecretKeyFactory", "PBEWithSHA1AndDESede", "com.sun.crypto.provider.PBEKeyFactory$PBEWithSHA1AndDESede", null);
        this.psA("SecretKeyFactory", "PBEWithSHA1AndRC2_40", "com.sun.crypto.provider.PBEKeyFactory$PBEWithSHA1AndRC2_40", null);
        this.psA("SecretKeyFactory", "PBEWithSHA1AndRC2_128", "com.sun.crypto.provider.PBEKeyFactory$PBEWithSHA1AndRC2_128", null);
        this.psA("SecretKeyFactory", "PBEWithSHA1AndRC4_40", "com.sun.crypto.provider.PBEKeyFactory$PBEWithSHA1AndRC4_40", null);
        this.psA("SecretKeyFactory", "PBEWithSHA1AndRC4_128", "com.sun.crypto.provider.PBEKeyFactory$PBEWithSHA1AndRC4_128", null);
        this.ps("SecretKeyFactory", "PBEWithHmacSHA1AndAES_128", "com.sun.crypto.provider.PBEKeyFactory$PBEWithHmacSHA1AndAES_128");
        this.ps("SecretKeyFactory", "PBEWithHmacSHA224AndAES_128", "com.sun.crypto.provider.PBEKeyFactory$PBEWithHmacSHA224AndAES_128");
        this.ps("SecretKeyFactory", "PBEWithHmacSHA256AndAES_128", "com.sun.crypto.provider.PBEKeyFactory$PBEWithHmacSHA256AndAES_128");
        this.ps("SecretKeyFactory", "PBEWithHmacSHA384AndAES_128", "com.sun.crypto.provider.PBEKeyFactory$PBEWithHmacSHA384AndAES_128");
        this.ps("SecretKeyFactory", "PBEWithHmacSHA512AndAES_128", "com.sun.crypto.provider.PBEKeyFactory$PBEWithHmacSHA512AndAES_128");
        this.ps("SecretKeyFactory", "PBEWithHmacSHA1AndAES_256", "com.sun.crypto.provider.PBEKeyFactory$PBEWithHmacSHA1AndAES_256");
        this.ps("SecretKeyFactory", "PBEWithHmacSHA224AndAES_256", "com.sun.crypto.provider.PBEKeyFactory$PBEWithHmacSHA224AndAES_256");
        this.ps("SecretKeyFactory", "PBEWithHmacSHA256AndAES_256", "com.sun.crypto.provider.PBEKeyFactory$PBEWithHmacSHA256AndAES_256");
        this.ps("SecretKeyFactory", "PBEWithHmacSHA384AndAES_256", "com.sun.crypto.provider.PBEKeyFactory$PBEWithHmacSHA384AndAES_256");
        this.ps("SecretKeyFactory", "PBEWithHmacSHA512AndAES_256", "com.sun.crypto.provider.PBEKeyFactory$PBEWithHmacSHA512AndAES_256");
        this.psA("SecretKeyFactory", "PBKDF2WithHmacSHA1", "com.sun.crypto.provider.PBKDF2Core$HmacSHA1", null);
        this.ps("SecretKeyFactory", "PBKDF2WithHmacSHA224", "com.sun.crypto.provider.PBKDF2Core$HmacSHA224");
        this.ps("SecretKeyFactory", "PBKDF2WithHmacSHA256", "com.sun.crypto.provider.PBKDF2Core$HmacSHA256");
        this.ps("SecretKeyFactory", "PBKDF2WithHmacSHA384", "com.sun.crypto.provider.PBKDF2Core$HmacSHA384");
        this.ps("SecretKeyFactory", "PBKDF2WithHmacSHA512", "com.sun.crypto.provider.PBKDF2Core$HmacSHA512");
        hashMap.clear();
        hashMap.put("SupportedKeyFormats", "RAW");
        this.ps("Mac", "HmacMD5", "com.sun.crypto.provider.HmacMD5", null, hashMap);
        this.psA("Mac", "HmacSHA1", "com.sun.crypto.provider.HmacSHA1", hashMap);
        this.psA("Mac", "HmacSHA224", "com.sun.crypto.provider.HmacCore$HmacSHA224", hashMap);
        this.psA("Mac", "HmacSHA256", "com.sun.crypto.provider.HmacCore$HmacSHA256", hashMap);
        this.psA("Mac", "HmacSHA384", "com.sun.crypto.provider.HmacCore$HmacSHA384", hashMap);
        this.psA("Mac", "HmacSHA512", "com.sun.crypto.provider.HmacCore$HmacSHA512", hashMap);
        this.ps("Mac", "HmacPBESHA1", "com.sun.crypto.provider.HmacPKCS12PBECore$HmacPKCS12PBE_SHA1", null, hashMap);
        this.ps("Mac", "HmacPBESHA224", "com.sun.crypto.provider.HmacPKCS12PBECore$HmacPKCS12PBE_SHA224", null, hashMap);
        this.ps("Mac", "HmacPBESHA256", "com.sun.crypto.provider.HmacPKCS12PBECore$HmacPKCS12PBE_SHA256", null, hashMap);
        this.ps("Mac", "HmacPBESHA384", "com.sun.crypto.provider.HmacPKCS12PBECore$HmacPKCS12PBE_SHA384", null, hashMap);
        this.ps("Mac", "HmacPBESHA512", "com.sun.crypto.provider.HmacPKCS12PBECore$HmacPKCS12PBE_SHA512", null, hashMap);
        this.ps("Mac", "HmacPBESHA512/224", "com.sun.crypto.provider.HmacPKCS12PBECore$HmacPKCS12PBE_SHA512_224", null, hashMap);
        this.ps("Mac", "HmacPBESHA512/256", "com.sun.crypto.provider.HmacPKCS12PBECore$HmacPKCS12PBE_SHA512_256", null, hashMap);
        this.ps("Mac", "PBEWithHmacSHA1", "com.sun.crypto.provider.PBMAC1Core$HmacSHA1", null, hashMap);
        this.ps("Mac", "PBEWithHmacSHA224", "com.sun.crypto.provider.PBMAC1Core$HmacSHA224", null, hashMap);
        this.ps("Mac", "PBEWithHmacSHA256", "com.sun.crypto.provider.PBMAC1Core$HmacSHA256", null, hashMap);
        this.ps("Mac", "PBEWithHmacSHA384", "com.sun.crypto.provider.PBMAC1Core$HmacSHA384", null, hashMap);
        this.ps("Mac", "PBEWithHmacSHA512", "com.sun.crypto.provider.PBMAC1Core$HmacSHA512", null, hashMap);
        this.ps("Mac", "SslMacMD5", "com.sun.crypto.provider.SslMacCore$SslMacMD5", null, hashMap);
        this.ps("Mac", "SslMacSHA1", "com.sun.crypto.provider.SslMacCore$SslMacSHA1", null, hashMap);
        this.ps("KeyStore", "JCEKS", "com.sun.crypto.provider.JceKeyStore");
        this.ps("KeyGenerator", "SunTlsPrf", "com.sun.crypto.provider.TlsPrfGenerator$V10");
        this.ps("KeyGenerator", "SunTls12Prf", "com.sun.crypto.provider.TlsPrfGenerator$V12");
        this.ps("KeyGenerator", "SunTlsMasterSecret", "com.sun.crypto.provider.TlsMasterSecretGenerator", Arrays.asList("SunTls12MasterSecret", "SunTlsExtendedMasterSecret"), null);
        this.ps("KeyGenerator", "SunTlsKeyMaterial", "com.sun.crypto.provider.TlsKeyMaterialGenerator", Arrays.asList("SunTls12KeyMaterial"), null);
        this.ps("KeyGenerator", "SunTlsRsaPremasterSecret", "com.sun.crypto.provider.TlsRsaPremasterSecretGenerator", Arrays.asList("SunTls12RsaPremasterSecret"), null);
    }

    static SunJCE getInstance() {
        if (instance == null) {
            return new SunJCE();
        }
        return instance;
    }

    private static class SecureRandomHolder {
        static final SecureRandom RANDOM = new SecureRandom();

        private SecureRandomHolder() {
        }
    }
}

