/*
 * Decompiled with CFR 0.152.
 */
package viettel.custom.swing;

import eu.europa.esig.dss.token.utils.StringUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.RoundRectangle2D;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.text.DefaultEditorKit;

public class RoundedCornerJTextField
extends JTextField
implements Serializable {
    private int arcWidth;
    private int arcHeight;
    private Color focusColor;
    private Color unfocusColor;
    private int thickness;
    private Shape shape;
    private boolean focus;

    public RoundedCornerJTextField() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                RoundedCornerJTextField.this.focus = true;
                RoundedCornerJTextField.this.setBorder(BorderFactory.createLineBorder(RoundedCornerJTextField.this.focusColor, RoundedCornerJTextField.this.thickness));
                if (evt.getButton() == 3 && !StringUtil.getText("cut").equals(((JMenuItem)RoundedCornerJTextField.this.getComponentPopupMenu().getComponent(0)).getText())) {
                    RoundedCornerJTextField.this.customPopupMenu();
                }
            }
        });
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                RoundedCornerJTextField.this.focus = true;
                RoundedCornerJTextField.this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(RoundedCornerJTextField.this.focusColor, RoundedCornerJTextField.this.thickness), new EmptyBorder(0, 8, 0, 0)));
            }

            @Override
            public void focusLost(FocusEvent evt) {
                RoundedCornerJTextField.this.focus = false;
                RoundedCornerJTextField.this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(RoundedCornerJTextField.this.unfocusColor, RoundedCornerJTextField.this.thickness), new EmptyBorder(0, 8, 0, 0)));
            }
        });
        this.customPopupMenu();
    }

    public RoundedCornerJTextField(int arcWidth, int arcHeight) {
        this.arcWidth = arcWidth;
        this.arcHeight = arcHeight;
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                RoundedCornerJTextField.this.focus = true;
                RoundedCornerJTextField.this.setBorder(BorderFactory.createLineBorder(RoundedCornerJTextField.this.focusColor, RoundedCornerJTextField.this.thickness));
            }
        });
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                RoundedCornerJTextField.this.focus = true;
                RoundedCornerJTextField.this.setBorder(BorderFactory.createLineBorder(RoundedCornerJTextField.this.focusColor, RoundedCornerJTextField.this.thickness));
            }

            @Override
            public void focusLost(FocusEvent evt) {
                RoundedCornerJTextField.this.focus = false;
                RoundedCornerJTextField.this.setBorder(BorderFactory.createLineBorder(RoundedCornerJTextField.this.unfocusColor, RoundedCornerJTextField.this.thickness));
            }
        });
    }

    public RoundedCornerJTextField(String text) {
        super(text);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                RoundedCornerJTextField.this.setBorder(BorderFactory.createLineBorder(RoundedCornerJTextField.this.focusColor, RoundedCornerJTextField.this.thickness));
                RoundedCornerJTextField.this.focus = true;
            }
        });
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                RoundedCornerJTextField.this.focus = true;
                RoundedCornerJTextField.this.setBorder(BorderFactory.createLineBorder(RoundedCornerJTextField.this.focusColor, RoundedCornerJTextField.this.thickness));
            }

            @Override
            public void focusLost(FocusEvent evt) {
                RoundedCornerJTextField.this.focus = false;
                RoundedCornerJTextField.this.setBorder(BorderFactory.createLineBorder(RoundedCornerJTextField.this.unfocusColor, RoundedCornerJTextField.this.thickness));
            }
        });
    }

    @Override
    protected void paintComponent(Graphics g2) {
        if (this.focus) {
            g2.setColor(this.focusColor);
        } else {
            g2.setColor(this.unfocusColor);
        }
        g2.drawRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, this.arcWidth, this.arcHeight);
        super.paintComponent(g2);
    }

    @Override
    protected void paintBorder(Graphics g2) {
        Graphics2D g2d = (Graphics2D)g2.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.focus) {
            g2d.setColor(this.focusColor);
        } else {
            g2d.setColor(this.unfocusColor);
        }
        g2d.drawRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, this.arcWidth, this.arcHeight);
    }

    @Override
    public boolean contains(int x, int y) {
        if (this.shape == null || !this.shape.getBounds().equals(this.getBounds())) {
            this.shape = new RoundRectangle2D.Double(0.0, 0.0, this.getWidth() - 1, this.getHeight() - 1, this.arcWidth, this.arcHeight);
        }
        return this.shape.contains(x, y);
    }

    private void customPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        DefaultEditorKit.CutAction cut = new DefaultEditorKit.CutAction();
        cut.putValue("Name", StringUtil.getText("cut"));
        cut.putValue("AcceleratorKey", KeyStroke.getKeyStroke(" control X"));
        menu.add(cut);
        DefaultEditorKit.CopyAction copy = new DefaultEditorKit.CopyAction();
        copy.putValue("Name", StringUtil.getText("copy"));
        copy.putValue("AcceleratorKey", KeyStroke.getKeyStroke(" control C"));
        menu.add(copy);
        DefaultEditorKit.PasteAction paste = new DefaultEditorKit.PasteAction();
        paste.putValue("Name", StringUtil.getText("paste"));
        paste.putValue("AcceleratorKey", KeyStroke.getKeyStroke(" control V"));
        menu.add(paste);
        this.setComponentPopupMenu(menu);
    }

    public int getArcWidth() {
        return this.arcWidth;
    }

    public void setArcWidth(int arcWidth) {
        this.arcWidth = arcWidth;
    }

    public int getArcHeight() {
        return this.arcHeight;
    }

    public void setArcHeight(int arcHeight) {
        this.arcHeight = arcHeight;
    }

    public Color getFocusColor() {
        return this.focusColor;
    }

    public void setFocusColor(Color focusColor) {
        this.focusColor = focusColor;
    }

    public Color getUnfocusColor() {
        return this.unfocusColor;
    }

    public void setUnfocusColor(Color unfocusColor) {
        this.unfocusColor = unfocusColor;
    }

    public int getThickness() {
        return this.thickness;
    }

    public void setThickness(int thickness) {
        this.thickness = thickness;
    }

    public boolean isFocus() {
        return this.focus;
    }

    public void setFocus(boolean focus) {
        this.focus = focus;
    }

    public static void main(String[] args) {
        System.out.println("Hello world");
    }
}

