/*
 * Decompiled with CFR 0.152.
 */
package viettel.custom.swing;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.RoundRectangle2D;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class RoundedCornerJPanel
extends JPanel
implements Serializable {
    private int arcWidth;
    private int arcHeight;
    private Color focusColor;
    private Color unfocusColor;
    private int thickness;
    private Shape shape;
    private boolean focus;

    public RoundedCornerJPanel() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                RoundedCornerJPanel.this.focus = true;
                RoundedCornerJPanel.this.setBorder(BorderFactory.createLineBorder(RoundedCornerJPanel.this.focusColor, RoundedCornerJPanel.this.thickness));
            }
        });
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                RoundedCornerJPanel.this.focus = true;
                RoundedCornerJPanel.this.setBorder(BorderFactory.createLineBorder(RoundedCornerJPanel.this.focusColor, RoundedCornerJPanel.this.thickness));
            }

            @Override
            public void focusLost(FocusEvent evt) {
                RoundedCornerJPanel.this.focus = false;
                RoundedCornerJPanel.this.setBorder(BorderFactory.createLineBorder(RoundedCornerJPanel.this.unfocusColor, RoundedCornerJPanel.this.thickness));
            }
        });
    }

    public RoundedCornerJPanel(int arcWidth, int arcHeight) {
        this.arcWidth = arcWidth;
        this.arcHeight = arcHeight;
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                RoundedCornerJPanel.this.focus = true;
                RoundedCornerJPanel.this.setBorder(BorderFactory.createLineBorder(RoundedCornerJPanel.this.focusColor, RoundedCornerJPanel.this.thickness));
            }
        });
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                RoundedCornerJPanel.this.focus = true;
                RoundedCornerJPanel.this.setBorder(BorderFactory.createLineBorder(RoundedCornerJPanel.this.focusColor, RoundedCornerJPanel.this.thickness));
            }

            @Override
            public void focusLost(FocusEvent evt) {
                RoundedCornerJPanel.this.focus = false;
                RoundedCornerJPanel.this.setBorder(BorderFactory.createLineBorder(RoundedCornerJPanel.this.unfocusColor, RoundedCornerJPanel.this.thickness));
            }
        });
    }

    @Override
    protected void paintComponent(Graphics g2) {
        if (this.focus) {
            g2.setColor(this.focusColor);
        } else {
            g2.setColor(this.unfocusColor);
        }
        g2.drawRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, this.arcWidth, this.arcHeight);
        super.paintComponent(g2);
    }

    @Override
    protected void paintBorder(Graphics g2) {
        Graphics2D g2d = (Graphics2D)g2.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.focus) {
            g2d.setColor(this.focusColor);
        } else {
            g2d.setColor(this.unfocusColor);
        }
        g2d.drawRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, this.arcWidth, this.arcHeight);
    }

    @Override
    public boolean contains(int x, int y) {
        if (this.shape == null || !this.shape.getBounds().equals(this.getBounds())) {
            this.shape = new RoundRectangle2D.Double(0.0, 0.0, this.getWidth() - 1, this.getHeight() - 1, this.arcWidth, this.arcHeight);
        }
        return this.shape.contains(x, y);
    }

    public int getArcWidth() {
        return this.arcWidth;
    }

    public void setArcWidth(int arcWidth) {
        this.arcWidth = arcWidth;
    }

    public int getArcHeight() {
        return this.arcHeight;
    }

    public void setArcHeight(int arcHeight) {
        this.arcHeight = arcHeight;
    }

    public Color getFocusColor() {
        return this.focusColor;
    }

    public void setFocusColor(Color focusColor) {
        this.focusColor = focusColor;
    }

    public Color getUnfocusColor() {
        return this.unfocusColor;
    }

    public void setUnfocusColor(Color unfocusColor) {
        this.unfocusColor = unfocusColor;
    }

    public int getThickness() {
        return this.thickness;
    }

    public void setThickness(int thickness) {
        this.thickness = thickness;
    }

    public boolean isFocus() {
        return this.focus;
    }

    public void setFocus(boolean focus) {
        this.focus = focus;
    }
}

