/*
 * Decompiled with CFR 0.152.
 */
package viettel.custom.swing;

import java.awt.Button;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.geom.RoundRectangle2D;
import java.io.Serializable;
import javax.swing.JButton;
import javax.swing.JFrame;

public class RoundedCornerJButton
extends JButton
implements Serializable {
    private Shape shape;
    private int arcWidth;
    private int arcHeight;
    private Color armedColor;
    private Color rollOverColor;
    private Color storedBackgroundColor;
    private boolean focus;

    public RoundedCornerJButton() {
        this.setContentAreaFilled(false);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e2) {
                RoundedCornerJButton.this.setBackground(RoundedCornerJButton.this.rollOverColor);
                RoundedCornerJButton.this.focus = true;
            }

            @Override
            public void focusLost(FocusEvent e2) {
                RoundedCornerJButton.this.setBackground(RoundedCornerJButton.this.storedBackgroundColor);
                RoundedCornerJButton.this.focus = false;
            }
        });
    }

    public RoundedCornerJButton(int arcWidth, int arcHeight) {
        this.arcWidth = arcWidth;
        this.arcHeight = arcHeight;
        this.setContentAreaFilled(false);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e2) {
                RoundedCornerJButton.this.setBackground(RoundedCornerJButton.this.rollOverColor);
                RoundedCornerJButton.this.focus = true;
            }

            @Override
            public void focusLost(FocusEvent e2) {
                RoundedCornerJButton.this.setBackground(RoundedCornerJButton.this.storedBackgroundColor);
                RoundedCornerJButton.this.focus = false;
            }
        });
    }

    @Override
    protected void paintComponent(Graphics g2) {
        if (this.getModel().isArmed()) {
            g2.setColor(this.armedColor);
        } else if (this.getModel().isRollover() || this.focus) {
            g2.setColor(this.rollOverColor);
        } else {
            g2.setColor(this.storedBackgroundColor);
        }
        g2.fillRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, this.arcWidth, this.arcHeight);
        super.paintComponent(g2);
    }

    @Override
    protected void paintBorder(Graphics g2) {
        Graphics2D g22 = (Graphics2D)g2.create();
        g22.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g22.setColor(this.getForeground());
        g22.drawRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, this.arcWidth, this.arcHeight);
    }

    @Override
    public boolean contains(int x, int y) {
        if (this.shape == null || !this.shape.getBounds().equals(this.getBounds())) {
            this.shape = new RoundRectangle2D.Double(0.0, 0.0, this.getWidth() - 1, this.getHeight() - 1, this.arcWidth, this.arcHeight);
        }
        return this.shape.contains(x, y);
    }

    public Shape getShape() {
        return this.shape;
    }

    public void setShape(Shape shape) {
        this.shape = shape;
    }

    public int getArcWidth() {
        return this.arcWidth;
    }

    public void setArcWidth(int arcWidth) {
        this.arcWidth = arcWidth;
    }

    public int getArcHeight() {
        return this.arcHeight;
    }

    public void setArcHeight(int arcHeight) {
        this.arcHeight = arcHeight;
    }

    public Color getArmedColor() {
        return this.armedColor;
    }

    public void setArmedColor(Color armedColor) {
        this.armedColor = armedColor;
    }

    public Color getRollOverColor() {
        return this.rollOverColor;
    }

    public void setRollOverColor(Color rollOverColor) {
        this.rollOverColor = rollOverColor;
    }

    public Color getStoredBackgroundColor() {
        return this.storedBackgroundColor;
    }

    public void setStoredBackgroundColor(Color storedBackgroundColor) {
        this.storedBackgroundColor = storedBackgroundColor;
    }

    public boolean isFocus() {
        return this.focus;
    }

    public void setFocus(boolean focus) {
        this.focus = focus;
    }

    public static void main(String[] args) {
        RoundedCornerJButton button = new RoundedCornerJButton(10, 10);
        button.setArcHeight(10);
        button.setRollOverColor(Color.RED);
        button.setArmedColor(Color.BLUE);
        button.setStoredBackgroundColor(Color.BLACK);
        JFrame frame = new JFrame();
        Button bt = new Button("Nguyen van dung");
        frame.getContentPane().add(bt);
        frame.getContentPane().add(button);
        frame.getContentPane().setLayout(new FlowLayout());
        frame.setSize(150, 150);
        frame.setVisible(true);
    }
}

