/*
 * Decompiled with CFR 0.152.
 */
package viettel.custom.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;

public class DecoratedCombobox
extends JComboBox {
    private static final Color borderColor = Color.decode("#596164");
    private static final Color defautBorderColor = new Color(153, 153, 153);
    private static final int borderThickness = 1;
    private static final Color arrowBackgroundColor = Color.decode("#596164");
    private static final Color selectedItemBackgroundColor = new Color(153, 153, 153);

    public static void main(String[] args) {
        DecoratedCombobox combobox = new DecoratedCombobox();
        combobox.setSize(500, 50);
        combobox.setModel(new DefaultComboBoxModel<String>(new String[]{"Nguyen van dung", "Nguyen huu tuan"}));
        combobox.setBackground(Color.WHITE);
        combobox.setForeground(Color.BLACK);
        JButton button = new JButton("Temp");
        JFrame frame = new JFrame();
        frame.getContentPane().add(combobox);
        frame.getContentPane().add(button);
        frame.getContentPane().setLayout(new FlowLayout());
        frame.setSize(450, 450);
        frame.setVisible(true);
    }

    public DecoratedCombobox() {
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e2) {
                DecoratedCombobox.this.setBorder(BorderFactory.createLineBorder(borderColor, 1, true));
            }

            @Override
            public void focusLost(FocusEvent e2) {
                DecoratedCombobox.this.setBorder(BorderFactory.createLineBorder(defautBorderColor, 1, true));
            }
        });
        this.setUI(new BasicComboBoxUI(){

            @Override
            protected JButton createArrowButton() {
                return new BasicArrowButton(5, arrowBackgroundColor, arrowBackgroundColor, Color.WHITE, arrowBackgroundColor);
            }

            @Override
            protected ComboPopup createPopup() {
                BasicComboPopup basicComboPopup = new BasicComboPopup(this.comboBox);
                basicComboPopup.setBorder(BorderFactory.createLineBorder(Color.decode("#596164"), 1, true));
                return basicComboPopup;
            }
        });
        this.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component c2 = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                ListModel model = list.getModel();
                Object obj = model.getElementAt(index);
                if (obj != null && obj.toString().length() > 31) {
                    list.setToolTipText(obj.toString());
                } else {
                    list.setToolTipText(null);
                }
                if (isSelected) {
                    c2.setBackground(selectedItemBackgroundColor);
                } else {
                    c2.setBackground(Color.WHITE);
                }
                return c2;
            }
        });
        this.setCursor(Cursor.getPredefinedCursor(12));
    }
}

