/*
 * Decompiled with CFR 0.152.
 */
package port.org.bouncycastle.util.encoders;

import java.io.IOException;
import java.io.OutputStream;
import port.org.bouncycastle.util.encoders.Encoder;

public class HexEncoder
implements Encoder {
    protected final byte[] encodingTable = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    protected final byte[] decodingTable = new byte[128];

    protected void initialiseDecodingTable() {
        int i2;
        for (i2 = 0; i2 < this.decodingTable.length; ++i2) {
            this.decodingTable[i2] = -1;
        }
        for (i2 = 0; i2 < this.encodingTable.length; ++i2) {
            this.decodingTable[this.encodingTable[i2]] = (byte)i2;
        }
        this.decodingTable[65] = this.decodingTable[97];
        this.decodingTable[66] = this.decodingTable[98];
        this.decodingTable[67] = this.decodingTable[99];
        this.decodingTable[68] = this.decodingTable[100];
        this.decodingTable[69] = this.decodingTable[101];
        this.decodingTable[70] = this.decodingTable[102];
    }

    public HexEncoder() {
        this.initialiseDecodingTable();
    }

    @Override
    public int encode(byte[] data, int off, int length, OutputStream out) throws IOException {
        for (int i2 = off; i2 < off + length; ++i2) {
            int v = data[i2] & 0xFF;
            out.write(this.encodingTable[v >>> 4]);
            out.write(this.encodingTable[v & 0xF]);
        }
        return length * 2;
    }
}

