/*
 * Decompiled with CFR 0.152.
 */
package port.org.bouncycastle.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public final class Strings {
    public static String fromUTF8ByteArray(byte[] bytes) {
        int i2 = 0;
        int length = 0;
        while (i2 < bytes.length) {
            ++length;
            if ((bytes[i2] & 0xF0) == 240) {
                ++length;
                i2 += 4;
                continue;
            }
            if ((bytes[i2] & 0xE0) == 224) {
                i2 += 3;
                continue;
            }
            if ((bytes[i2] & 0xC0) == 192) {
                i2 += 2;
                continue;
            }
            ++i2;
        }
        char[] cs = new char[length];
        i2 = 0;
        length = 0;
        while (i2 < bytes.length) {
            char ch;
            if ((bytes[i2] & 0xF0) == 240) {
                int codePoint = (bytes[i2] & 3) << 18 | (bytes[i2 + 1] & 0x3F) << 12 | (bytes[i2 + 2] & 0x3F) << 6 | bytes[i2 + 3] & 0x3F;
                int U = codePoint - 65536;
                char W1 = (char)(0xD800 | U >> 10);
                char W2 = (char)(0xDC00 | U & 0x3FF);
                cs[length++] = W1;
                ch = W2;
                i2 += 4;
            } else if ((bytes[i2] & 0xE0) == 224) {
                ch = (char)((bytes[i2] & 0xF) << 12 | (bytes[i2 + 1] & 0x3F) << 6 | bytes[i2 + 2] & 0x3F);
                i2 += 3;
            } else if ((bytes[i2] & 0xD0) == 208) {
                ch = (char)((bytes[i2] & 0x1F) << 6 | bytes[i2 + 1] & 0x3F);
                i2 += 2;
            } else if ((bytes[i2] & 0xC0) == 192) {
                ch = (char)((bytes[i2] & 0x1F) << 6 | bytes[i2 + 1] & 0x3F);
                i2 += 2;
            } else {
                ch = (char)(bytes[i2] & 0xFF);
                ++i2;
            }
            cs[length++] = ch;
        }
        return new String(cs);
    }

    public static byte[] toUTF8ByteArray(String string) {
        return Strings.toUTF8ByteArray(string.toCharArray());
    }

    public static byte[] toUTF8ByteArray(char[] string) {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        try {
            Strings.toUTF8ByteArray(string, bOut);
        }
        catch (IOException e2) {
            throw new IllegalStateException("cannot encode string to byte array!");
        }
        return bOut.toByteArray();
    }

    public static void toUTF8ByteArray(char[] string, OutputStream sOut) throws IOException {
        char[] c2 = string;
        for (int i2 = 0; i2 < c2.length; ++i2) {
            char ch = c2[i2];
            if (ch < '\u0080') {
                sOut.write(ch);
                continue;
            }
            if (ch < '\u0800') {
                sOut.write(0xC0 | ch >> 6);
                sOut.write(0x80 | ch & 0x3F);
                continue;
            }
            if (ch >= '\ud800' && ch <= '\udfff') {
                if (i2 + 1 >= c2.length) {
                    throw new IllegalStateException("invalid UTF-16 codepoint");
                }
                char W1 = ch;
                char W2 = ch = c2[++i2];
                if (W1 > '\udbff') {
                    throw new IllegalStateException("invalid UTF-16 codepoint");
                }
                int codePoint = ((W1 & 0x3FF) << 10 | W2 & 0x3FF) + 65536;
                sOut.write(0xF0 | codePoint >> 18);
                sOut.write(0x80 | codePoint >> 12 & 0x3F);
                sOut.write(0x80 | codePoint >> 6 & 0x3F);
                sOut.write(0x80 | codePoint & 0x3F);
                continue;
            }
            sOut.write(0xE0 | ch >> 12);
            sOut.write(0x80 | ch >> 6 & 0x3F);
            sOut.write(0x80 | ch & 0x3F);
        }
    }

    public static byte[] toByteArray(String string) {
        byte[] bytes = new byte[string.length()];
        for (int i2 = 0; i2 != bytes.length; ++i2) {
            char ch = string.charAt(i2);
            bytes[i2] = (byte)ch;
        }
        return bytes;
    }

    public static String fromByteArray(byte[] bytes) {
        return new String(Strings.asCharArray(bytes));
    }

    public static char[] asCharArray(byte[] bytes) {
        char[] chars = new char[bytes.length];
        for (int i2 = 0; i2 != chars.length; ++i2) {
            chars[i2] = (char)(bytes[i2] & 0xFF);
        }
        return chars;
    }
}

