/*
 * Decompiled with CFR 0.152.
 */
package port.org.bouncycastle.asn1;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import port.org.bouncycastle.asn1.ASN1OctetString;
import port.org.bouncycastle.asn1.ASN1OutputStream;
import port.org.bouncycastle.asn1.ASN1Primitive;
import port.org.bouncycastle.asn1.ASN1String;
import port.org.bouncycastle.asn1.ASN1TaggedObject;
import port.org.bouncycastle.asn1.StreamUtil;
import port.org.bouncycastle.util.Arrays;

public class DERUniversalString
extends ASN1Primitive
implements ASN1String {
    private static final char[] table = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private byte[] string;

    public static DERUniversalString getInstance(Object obj) {
        if (obj == null || obj instanceof DERUniversalString) {
            return (DERUniversalString)obj;
        }
        if (obj instanceof byte[]) {
            try {
                return (DERUniversalString)DERUniversalString.fromByteArray((byte[])obj);
            }
            catch (Exception e2) {
                throw new IllegalArgumentException("encoding error getInstance: " + e2.toString());
            }
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static DERUniversalString getInstance(ASN1TaggedObject obj, boolean explicit) {
        ASN1Primitive o2 = obj.getObject();
        if (explicit || o2 instanceof DERUniversalString) {
            return DERUniversalString.getInstance(o2);
        }
        return new DERUniversalString(((ASN1OctetString)o2).getOctets());
    }

    public DERUniversalString(byte[] string) {
        this.string = string;
    }

    @Override
    public String getString() {
        StringBuffer buf = new StringBuffer("#");
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        ASN1OutputStream aOut = new ASN1OutputStream(bOut);
        try {
            aOut.writeObject(this);
        }
        catch (IOException e2) {
            throw new RuntimeException("internal error encoding BitString");
        }
        byte[] string = bOut.toByteArray();
        for (int i2 = 0; i2 != string.length; ++i2) {
            buf.append(table[string[i2] >>> 4 & 0xF]);
            buf.append(table[string[i2] & 0xF]);
        }
        return buf.toString();
    }

    public String toString() {
        return this.getString();
    }

    public byte[] getOctets() {
        return this.string;
    }

    @Override
    boolean isConstructed() {
        return false;
    }

    @Override
    int encodedLength() {
        return 1 + StreamUtil.calculateBodyLength(this.string.length) + this.string.length;
    }

    @Override
    void encode(ASN1OutputStream out) throws IOException {
        out.writeEncoded(28, this.getOctets());
    }

    @Override
    boolean asn1Equals(ASN1Primitive o2) {
        if (!(o2 instanceof DERUniversalString)) {
            return false;
        }
        return Arrays.areEqual(this.string, ((DERUniversalString)o2).string);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.string);
    }
}

