/*
 * Decompiled with CFR 0.152.
 */
package port.org.bouncycastle.asn1;

import java.io.IOException;
import port.org.bouncycastle.asn1.ASN1OctetString;
import port.org.bouncycastle.asn1.ASN1OutputStream;
import port.org.bouncycastle.asn1.ASN1Primitive;
import port.org.bouncycastle.asn1.ASN1String;
import port.org.bouncycastle.asn1.ASN1TaggedObject;
import port.org.bouncycastle.asn1.StreamUtil;
import port.org.bouncycastle.util.Arrays;
import port.org.bouncycastle.util.Strings;

public class DERUTF8String
extends ASN1Primitive
implements ASN1String {
    private byte[] string;

    public static DERUTF8String getInstance(Object obj) {
        if (obj == null || obj instanceof DERUTF8String) {
            return (DERUTF8String)obj;
        }
        if (obj instanceof byte[]) {
            try {
                return (DERUTF8String)DERUTF8String.fromByteArray((byte[])obj);
            }
            catch (Exception e2) {
                throw new IllegalArgumentException("encoding error in getInstance: " + e2.toString());
            }
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static DERUTF8String getInstance(ASN1TaggedObject obj, boolean explicit) {
        ASN1Primitive o2 = obj.getObject();
        if (explicit || o2 instanceof DERUTF8String) {
            return DERUTF8String.getInstance(o2);
        }
        return new DERUTF8String(ASN1OctetString.getInstance(o2).getOctets());
    }

    DERUTF8String(byte[] string) {
        this.string = string;
    }

    public DERUTF8String(String string) {
        this.string = Strings.toUTF8ByteArray(string);
    }

    @Override
    public String getString() {
        return Strings.fromUTF8ByteArray(this.string);
    }

    public String toString() {
        return this.getString();
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.string);
    }

    @Override
    boolean asn1Equals(ASN1Primitive o2) {
        if (!(o2 instanceof DERUTF8String)) {
            return false;
        }
        DERUTF8String s = (DERUTF8String)o2;
        return Arrays.areEqual(this.string, s.string);
    }

    @Override
    boolean isConstructed() {
        return false;
    }

    @Override
    int encodedLength() throws IOException {
        return 1 + StreamUtil.calculateBodyLength(this.string.length) + this.string.length;
    }

    @Override
    void encode(ASN1OutputStream out) throws IOException {
        out.writeEncoded(12, this.string);
    }
}

