/*
 * Decompiled with CFR 0.152.
 */
package port.org.bouncycastle.asn1;

import java.io.IOException;
import port.org.bouncycastle.asn1.ASN1OctetString;
import port.org.bouncycastle.asn1.ASN1OutputStream;
import port.org.bouncycastle.asn1.ASN1Primitive;
import port.org.bouncycastle.asn1.ASN1String;
import port.org.bouncycastle.asn1.ASN1TaggedObject;
import port.org.bouncycastle.asn1.DERT61String;
import port.org.bouncycastle.asn1.StreamUtil;
import port.org.bouncycastle.util.Arrays;
import port.org.bouncycastle.util.Strings;

public class DERT61UTF8String
extends ASN1Primitive
implements ASN1String {
    private byte[] string;

    public static DERT61UTF8String getInstance(Object obj) {
        if (obj instanceof DERT61String) {
            return new DERT61UTF8String(((DERT61String)obj).getOctets());
        }
        if (obj == null || obj instanceof DERT61UTF8String) {
            return (DERT61UTF8String)obj;
        }
        if (obj instanceof byte[]) {
            try {
                return new DERT61UTF8String(((DERT61String)DERT61UTF8String.fromByteArray((byte[])obj)).getOctets());
            }
            catch (Exception e2) {
                throw new IllegalArgumentException("encoding error in getInstance: " + e2.toString());
            }
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static DERT61UTF8String getInstance(ASN1TaggedObject obj, boolean explicit) {
        ASN1Primitive o2 = obj.getObject();
        if (explicit || o2 instanceof DERT61String || o2 instanceof DERT61UTF8String) {
            return DERT61UTF8String.getInstance(o2);
        }
        return new DERT61UTF8String(ASN1OctetString.getInstance(o2).getOctets());
    }

    public DERT61UTF8String(byte[] string) {
        this.string = string;
    }

    public DERT61UTF8String(String string) {
        this(Strings.toUTF8ByteArray(string));
    }

    @Override
    public String getString() {
        return Strings.fromUTF8ByteArray(this.string);
    }

    public String toString() {
        return this.getString();
    }

    @Override
    boolean isConstructed() {
        return false;
    }

    @Override
    int encodedLength() {
        return 1 + StreamUtil.calculateBodyLength(this.string.length) + this.string.length;
    }

    @Override
    void encode(ASN1OutputStream out) throws IOException {
        out.writeEncoded(20, this.string);
    }

    public byte[] getOctets() {
        return Arrays.clone(this.string);
    }

    @Override
    boolean asn1Equals(ASN1Primitive o2) {
        if (!(o2 instanceof DERT61UTF8String)) {
            return false;
        }
        return Arrays.areEqual(this.string, ((DERT61UTF8String)o2).string);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.string);
    }
}

