/*
 * Decompiled with CFR 0.152.
 */
package port.org.bouncycastle.asn1;

import java.io.IOException;
import port.org.bouncycastle.asn1.ASN1OctetString;
import port.org.bouncycastle.asn1.ASN1OutputStream;
import port.org.bouncycastle.asn1.ASN1Primitive;
import port.org.bouncycastle.asn1.ASN1String;
import port.org.bouncycastle.asn1.ASN1TaggedObject;
import port.org.bouncycastle.asn1.StreamUtil;
import port.org.bouncycastle.util.Arrays;
import port.org.bouncycastle.util.Strings;

public class DERIA5String
extends ASN1Primitive
implements ASN1String {
    private byte[] string;

    public static DERIA5String getInstance(Object obj) {
        if (obj == null || obj instanceof DERIA5String) {
            return (DERIA5String)obj;
        }
        if (obj instanceof byte[]) {
            try {
                return (DERIA5String)DERIA5String.fromByteArray((byte[])obj);
            }
            catch (Exception e2) {
                throw new IllegalArgumentException("encoding error in getInstance: " + e2.toString());
            }
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static DERIA5String getInstance(ASN1TaggedObject obj, boolean explicit) {
        ASN1Primitive o2 = obj.getObject();
        if (explicit || o2 instanceof DERIA5String) {
            return DERIA5String.getInstance(o2);
        }
        return new DERIA5String(((ASN1OctetString)o2).getOctets());
    }

    DERIA5String(byte[] string) {
        this.string = string;
    }

    public DERIA5String(String string) {
        this(string, false);
    }

    public DERIA5String(String string, boolean validate) {
        if (string == null) {
            throw new NullPointerException("string cannot be null");
        }
        if (validate && !DERIA5String.isIA5String(string)) {
            throw new IllegalArgumentException("string contains illegal characters");
        }
        this.string = Strings.toByteArray(string);
    }

    @Override
    public String getString() {
        return Strings.fromByteArray(this.string);
    }

    public String toString() {
        return this.getString();
    }

    public byte[] getOctets() {
        return Arrays.clone(this.string);
    }

    @Override
    boolean isConstructed() {
        return false;
    }

    @Override
    int encodedLength() {
        return 1 + StreamUtil.calculateBodyLength(this.string.length) + this.string.length;
    }

    @Override
    void encode(ASN1OutputStream out) throws IOException {
        out.writeEncoded(22, this.string);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.string);
    }

    @Override
    boolean asn1Equals(ASN1Primitive o2) {
        if (!(o2 instanceof DERIA5String)) {
            return false;
        }
        DERIA5String s = (DERIA5String)o2;
        return Arrays.areEqual(this.string, s.string);
    }

    public static boolean isIA5String(String str) {
        for (int i2 = str.length() - 1; i2 >= 0; --i2) {
            char ch = str.charAt(i2);
            if (ch <= '\u007f') continue;
            return false;
        }
        return true;
    }
}

