/*
 * Decompiled with CFR 0.152.
 */
package port.org.bouncycastle.asn1;

import java.io.IOException;
import port.org.bouncycastle.asn1.ASN1Encodable;
import port.org.bouncycastle.asn1.ASN1Exception;
import port.org.bouncycastle.asn1.ASN1ParsingException;
import port.org.bouncycastle.asn1.ASN1Primitive;
import port.org.bouncycastle.asn1.ASN1StreamParser;
import port.org.bouncycastle.asn1.DERExternal;
import port.org.bouncycastle.asn1.InMemoryRepresentable;

public class DERExternalParser
implements ASN1Encodable,
InMemoryRepresentable {
    private ASN1StreamParser _parser;

    public DERExternalParser(ASN1StreamParser parser) {
        this._parser = parser;
    }

    public ASN1Encodable readObject() throws IOException {
        return this._parser.readObject();
    }

    @Override
    public ASN1Primitive getLoadedObject() throws IOException {
        try {
            return new DERExternal(this._parser.readVector());
        }
        catch (IllegalArgumentException e2) {
            throw new ASN1Exception(e2.getMessage(), e2);
        }
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        try {
            return this.getLoadedObject();
        }
        catch (IOException ioe) {
            throw new ASN1ParsingException("unable to get DER object", ioe);
        }
        catch (IllegalArgumentException ioe) {
            throw new ASN1ParsingException("unable to get DER object", ioe);
        }
    }
}

