/*
 * Decompiled with CFR 0.152.
 */
package port.org.bouncycastle.asn1;

import java.io.IOException;
import port.org.bouncycastle.asn1.ASN1OctetString;
import port.org.bouncycastle.asn1.ASN1OutputStream;
import port.org.bouncycastle.asn1.ASN1Primitive;
import port.org.bouncycastle.asn1.ASN1String;
import port.org.bouncycastle.asn1.ASN1TaggedObject;
import port.org.bouncycastle.asn1.StreamUtil;
import port.org.bouncycastle.util.Arrays;

public class DERBMPString
extends ASN1Primitive
implements ASN1String {
    private char[] string;

    public static DERBMPString getInstance(Object obj) {
        if (obj == null || obj instanceof DERBMPString) {
            return (DERBMPString)obj;
        }
        if (obj instanceof byte[]) {
            try {
                return (DERBMPString)DERBMPString.fromByteArray((byte[])obj);
            }
            catch (Exception e2) {
                throw new IllegalArgumentException("encoding error in getInstance: " + e2.toString());
            }
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static DERBMPString getInstance(ASN1TaggedObject obj, boolean explicit) {
        ASN1Primitive o2 = obj.getObject();
        if (explicit || o2 instanceof DERBMPString) {
            return DERBMPString.getInstance(o2);
        }
        return new DERBMPString(ASN1OctetString.getInstance(o2).getOctets());
    }

    DERBMPString(byte[] string) {
        char[] cs = new char[string.length / 2];
        for (int i2 = 0; i2 != cs.length; ++i2) {
            cs[i2] = (char)(string[2 * i2] << 8 | string[2 * i2 + 1] & 0xFF);
        }
        this.string = cs;
    }

    DERBMPString(char[] string) {
        this.string = string;
    }

    public DERBMPString(String string) {
        this.string = string.toCharArray();
    }

    @Override
    public String getString() {
        return new String(this.string);
    }

    public String toString() {
        return this.getString();
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.string);
    }

    @Override
    protected boolean asn1Equals(ASN1Primitive o2) {
        if (!(o2 instanceof DERBMPString)) {
            return false;
        }
        DERBMPString s = (DERBMPString)o2;
        return Arrays.areEqual(this.string, s.string);
    }

    @Override
    boolean isConstructed() {
        return false;
    }

    @Override
    int encodedLength() {
        return 1 + StreamUtil.calculateBodyLength(this.string.length * 2) + this.string.length * 2;
    }

    @Override
    void encode(ASN1OutputStream out) throws IOException {
        out.write(30);
        out.writeLength(this.string.length * 2);
        for (int i2 = 0; i2 != this.string.length; ++i2) {
            char c2 = this.string[i2];
            out.write((byte)(c2 >> 8));
            out.write((byte)c2);
        }
    }
}

