/*
 * Decompiled with CFR 0.152.
 */
package port.org.bouncycastle.asn1;

import java.io.IOException;
import java.io.InputStream;
import port.org.bouncycastle.asn1.ASN1OctetStringParser;
import port.org.bouncycastle.asn1.ASN1StreamParser;

class ConstructedOctetStream
extends InputStream {
    private final ASN1StreamParser _parser;
    private boolean _first = true;
    private InputStream _currentStream;

    ConstructedOctetStream(ASN1StreamParser parser) {
        this._parser = parser;
    }

    @Override
    public int read(byte[] b2, int off, int len) throws IOException {
        if (this._currentStream == null) {
            if (!this._first) {
                return -1;
            }
            ASN1OctetStringParser s = (ASN1OctetStringParser)this._parser.readObject();
            if (s == null) {
                return -1;
            }
            this._first = false;
            this._currentStream = s.getOctetStream();
        }
        int totalRead = 0;
        while (true) {
            int numRead;
            if ((numRead = this._currentStream.read(b2, off + totalRead, len - totalRead)) >= 0) {
                if ((totalRead += numRead) != len) continue;
                return totalRead;
            }
            ASN1OctetStringParser aos = (ASN1OctetStringParser)this._parser.readObject();
            if (aos == null) {
                this._currentStream = null;
                return totalRead < 1 ? -1 : totalRead;
            }
            this._currentStream = aos.getOctetStream();
        }
    }

    @Override
    public int read() throws IOException {
        if (this._currentStream == null) {
            if (!this._first) {
                return -1;
            }
            ASN1OctetStringParser s = (ASN1OctetStringParser)this._parser.readObject();
            if (s == null) {
                return -1;
            }
            this._first = false;
            this._currentStream = s.getOctetStream();
        }
        int b2;
        while ((b2 = this._currentStream.read()) < 0) {
            ASN1OctetStringParser s = (ASN1OctetStringParser)this._parser.readObject();
            if (s == null) {
                this._currentStream = null;
                return -1;
            }
            this._currentStream = s.getOctetStream();
        }
        return b2;
    }
}

