/*
 * Decompiled with CFR 0.152.
 */
package port.org.bouncycastle.asn1;

import java.io.IOException;
import java.util.Enumeration;
import port.org.bouncycastle.asn1.ASN1Encodable;
import port.org.bouncycastle.asn1.ASN1OctetString;
import port.org.bouncycastle.asn1.ASN1OutputStream;
import port.org.bouncycastle.asn1.ASN1Primitive;
import port.org.bouncycastle.asn1.ASN1Sequence;
import port.org.bouncycastle.asn1.ASN1Set;
import port.org.bouncycastle.asn1.ASN1TaggedObject;
import port.org.bouncycastle.asn1.BEROctetString;
import port.org.bouncycastle.asn1.BERSequence;
import port.org.bouncycastle.asn1.StreamUtil;

public class BERTaggedObject
extends ASN1TaggedObject {
    public BERTaggedObject(int tagNo, ASN1Encodable obj) {
        super(true, tagNo, obj);
    }

    public BERTaggedObject(boolean explicit, int tagNo, ASN1Encodable obj) {
        super(explicit, tagNo, obj);
    }

    public BERTaggedObject(int tagNo) {
        super(false, tagNo, new BERSequence());
    }

    @Override
    boolean isConstructed() {
        if (!this.empty) {
            if (this.explicit) {
                return true;
            }
            ASN1Primitive primitive = this.obj.toASN1Primitive().toDERObject();
            return primitive.isConstructed();
        }
        return true;
    }

    @Override
    int encodedLength() throws IOException {
        if (!this.empty) {
            ASN1Primitive primitive = this.obj.toASN1Primitive();
            int length = primitive.encodedLength();
            if (this.explicit) {
                return StreamUtil.calculateTagLength(this.tagNo) + StreamUtil.calculateBodyLength(length) + length;
            }
            return StreamUtil.calculateTagLength(this.tagNo) + --length;
        }
        return StreamUtil.calculateTagLength(this.tagNo) + 1;
    }

    @Override
    void encode(ASN1OutputStream out) throws IOException {
        out.writeTag(160, this.tagNo);
        out.write(128);
        if (!this.empty) {
            if (!this.explicit) {
                Enumeration e2;
                if (this.obj instanceof ASN1OctetString) {
                    if (this.obj instanceof BEROctetString) {
                        e2 = ((BEROctetString)this.obj).getObjects();
                    } else {
                        ASN1OctetString octs = (ASN1OctetString)this.obj;
                        BEROctetString berO = new BEROctetString(octs.getOctets());
                        e2 = berO.getObjects();
                    }
                } else if (this.obj instanceof ASN1Sequence) {
                    e2 = ((ASN1Sequence)this.obj).getObjects();
                } else if (this.obj instanceof ASN1Set) {
                    e2 = ((ASN1Set)this.obj).getObjects();
                } else {
                    throw new RuntimeException("not implemented: " + this.obj.getClass().getName());
                }
                while (e2.hasMoreElements()) {
                    out.writeObject((ASN1Encodable)e2.nextElement());
                }
            } else {
                out.writeObject(this.obj);
            }
        }
        out.write(0);
        out.write(0);
    }
}

