/*
 * Decompiled with CFR 0.152.
 */
package port.org.bouncycastle.asn1;

import java.io.IOException;
import port.org.bouncycastle.asn1.ASN1ApplicationSpecificParser;
import port.org.bouncycastle.asn1.ASN1Encodable;
import port.org.bouncycastle.asn1.ASN1ParsingException;
import port.org.bouncycastle.asn1.ASN1Primitive;
import port.org.bouncycastle.asn1.ASN1StreamParser;
import port.org.bouncycastle.asn1.BERApplicationSpecific;

public class BERApplicationSpecificParser
implements ASN1ApplicationSpecificParser {
    private final int tag;
    private final ASN1StreamParser parser;

    BERApplicationSpecificParser(int tag, ASN1StreamParser parser) {
        this.tag = tag;
        this.parser = parser;
    }

    @Override
    public ASN1Encodable readObject() throws IOException {
        return this.parser.readObject();
    }

    @Override
    public ASN1Primitive getLoadedObject() throws IOException {
        return new BERApplicationSpecific(this.tag, this.parser.readVector());
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        try {
            return this.getLoadedObject();
        }
        catch (IOException e2) {
            throw new ASN1ParsingException(e2.getMessage(), e2);
        }
    }
}

