/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.util;

public abstract class JavaScriptUtils {
    public static String javaScriptEscape(String input) {
        StringBuilder filtered = new StringBuilder(input.length());
        char prevChar = '\u0000';
        for (int i2 = 0; i2 < input.length(); ++i2) {
            char c2 = input.charAt(i2);
            if (c2 == '\"') {
                filtered.append("\\\"");
            } else if (c2 == '\'') {
                filtered.append("\\'");
            } else if (c2 == '\\') {
                filtered.append("\\\\");
            } else if (c2 == '/') {
                filtered.append("\\/");
            } else if (c2 == '\t') {
                filtered.append("\\t");
            } else if (c2 == '\n') {
                if (prevChar != '\r') {
                    filtered.append("\\n");
                }
            } else if (c2 == '\r') {
                filtered.append("\\n");
            } else if (c2 == '\f') {
                filtered.append("\\f");
            } else if (c2 == '\b') {
                filtered.append("\\b");
            } else if (c2 == '\u000b') {
                filtered.append("\\v");
            } else if (c2 == '<') {
                filtered.append("\\u003C");
            } else if (c2 == '>') {
                filtered.append("\\u003E");
            } else if (c2 == '\u2028') {
                filtered.append("\\u2028");
            } else if (c2 == '\u2029') {
                filtered.append("\\u2029");
            } else {
                filtered.append(c2);
            }
            prevChar = c2;
        }
        return filtered.toString();
    }
}

