/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cglib.proxy;

import java.lang.reflect.Method;
import java.util.HashSet;
import org.springframework.asm.ClassVisitor;
import org.springframework.asm.Type;
import org.springframework.cglib.core.ClassEmitter;
import org.springframework.cglib.core.CodeEmitter;
import org.springframework.cglib.core.Constants;
import org.springframework.cglib.core.EmitUtils;
import org.springframework.cglib.core.MethodInfo;
import org.springframework.cglib.core.MethodWrapper;
import org.springframework.cglib.core.ReflectUtils;
import org.springframework.cglib.core.Signature;
import org.springframework.cglib.core.TypeUtils;

class MixinEmitter
extends ClassEmitter {
    private static final String FIELD_NAME = "CGLIB$DELEGATES";
    private static final Signature CSTRUCT_OBJECT_ARRAY = TypeUtils.parseConstructor("Object[]");
    private static final Type MIXIN = TypeUtils.parseType("org.springframework.cglib.proxy.Mixin");
    private static final Signature NEW_INSTANCE = new Signature("newInstance", MIXIN, new Type[]{Constants.TYPE_OBJECT_ARRAY});

    public MixinEmitter(ClassVisitor v, String className, Class[] classes, int[] route) {
        super(v);
        this.begin_class(52, 1, className, MIXIN, TypeUtils.getTypes(this.getInterfaces(classes)), "<generated>");
        EmitUtils.null_constructor(this);
        EmitUtils.factory_method(this, NEW_INSTANCE);
        this.declare_field(2, FIELD_NAME, Constants.TYPE_OBJECT_ARRAY, null);
        CodeEmitter e2 = this.begin_method(1, CSTRUCT_OBJECT_ARRAY, null);
        e2.load_this();
        e2.super_invoke_constructor();
        e2.load_this();
        e2.load_arg(0);
        e2.putfield(FIELD_NAME);
        e2.return_value();
        e2.end_method();
        HashSet<Object> unique = new HashSet<Object>();
        for (int i2 = 0; i2 < classes.length; ++i2) {
            Method[] methods = this.getMethods(classes[i2]);
            for (int j2 = 0; j2 < methods.length; ++j2) {
                if (!unique.add(MethodWrapper.create(methods[j2]))) continue;
                MethodInfo method = ReflectUtils.getMethodInfo(methods[j2]);
                int modifiers = 1;
                if ((method.getModifiers() & 0x80) == 128) {
                    modifiers |= 0x80;
                }
                e2 = EmitUtils.begin_method(this, method, modifiers);
                e2.load_this();
                e2.getfield(FIELD_NAME);
                e2.aaload(route != null ? route[i2] : i2);
                e2.checkcast(method.getClassInfo().getType());
                e2.load_args();
                e2.invoke(method);
                e2.return_value();
                e2.end_method();
            }
        }
        this.end_class();
    }

    protected Class[] getInterfaces(Class[] classes) {
        return classes;
    }

    protected Method[] getMethods(Class type) {
        return type.getMethods();
    }
}

