/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import java.io.PrintStream;
import java.io.PrintWriter;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyAccessException;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class PropertyBatchUpdateException
extends BeansException {
    private PropertyAccessException[] propertyAccessExceptions;

    public PropertyBatchUpdateException(PropertyAccessException[] propertyAccessExceptions) {
        super((String)null);
        Assert.notEmpty((Object[])propertyAccessExceptions, "At least 1 PropertyAccessException required");
        this.propertyAccessExceptions = propertyAccessExceptions;
    }

    public final int getExceptionCount() {
        return this.propertyAccessExceptions.length;
    }

    public final PropertyAccessException[] getPropertyAccessExceptions() {
        return this.propertyAccessExceptions;
    }

    public PropertyAccessException getPropertyAccessException(String propertyName) {
        for (PropertyAccessException pae : this.propertyAccessExceptions) {
            if (!ObjectUtils.nullSafeEquals(propertyName, pae.getPropertyName())) continue;
            return pae;
        }
        return null;
    }

    public String getMessage() {
        StringBuilder sb = new StringBuilder("Failed properties: ");
        for (int i2 = 0; i2 < this.propertyAccessExceptions.length; ++i2) {
            sb.append(this.propertyAccessExceptions[i2].getMessage());
            if (i2 >= this.propertyAccessExceptions.length - 1) continue;
            sb.append("; ");
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName()).append("; nested PropertyAccessExceptions (");
        sb.append(this.getExceptionCount()).append(") are:");
        for (int i2 = 0; i2 < this.propertyAccessExceptions.length; ++i2) {
            sb.append('\n').append("PropertyAccessException ").append(i2 + 1).append(": ");
            sb.append(this.propertyAccessExceptions[i2]);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintStream ps) {
        PrintStream printStream = ps;
        synchronized (printStream) {
            ps.println(this.getClass().getName() + "; nested PropertyAccessException details (" + this.getExceptionCount() + ") are:");
            for (int i2 = 0; i2 < this.propertyAccessExceptions.length; ++i2) {
                ps.println("PropertyAccessException " + (i2 + 1) + ":");
                this.propertyAccessExceptions[i2].printStackTrace(ps);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintWriter pw) {
        PrintWriter printWriter = pw;
        synchronized (printWriter) {
            pw.println(this.getClass().getName() + "; nested PropertyAccessException details (" + this.getExceptionCount() + ") are:");
            for (int i2 = 0; i2 < this.propertyAccessExceptions.length; ++i2) {
                pw.println("PropertyAccessException " + (i2 + 1) + ":");
                this.propertyAccessExceptions[i2].printStackTrace(pw);
            }
        }
    }

    public boolean contains(Class exType) {
        if (exType == null) {
            return false;
        }
        if (exType.isInstance(this)) {
            return true;
        }
        for (PropertyAccessException pae : this.propertyAccessExceptions) {
            if (!pae.contains(exType)) continue;
            return true;
        }
        return false;
    }
}

