/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.io.payload;

import java.nio.ByteBuffer;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.common.io.payload.PayloadProcessor;

public class DeMaskProcessor
implements PayloadProcessor {
    private boolean isMasked;
    private byte[] mask;
    private int offset;

    @Override
    public void process(ByteBuffer payload) {
        if (!this.isMasked) {
            return;
        }
        int start = payload.position();
        int end = payload.limit();
        int i2 = start;
        while (i2 < end) {
            payload.put(i2, (byte)(payload.get(i2) ^ this.mask[this.offset % 4]));
            ++i2;
            ++this.offset;
        }
    }

    @Override
    public void reset(Frame frame) {
        this.isMasked = frame.isMasked();
        this.mask = (byte[])(this.isMasked ? frame.getMask() : null);
        this.offset = 0;
    }
}

