/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.io;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.common.CloseInfo;
import org.eclipse.jetty.websocket.common.ConnectionState;

public class IOState {
    private static final Logger LOG = Log.getLogger(IOState.class);
    private ConnectionState state;
    private final List<ConnectionStateListener> listeners = new CopyOnWriteArrayList<ConnectionStateListener>();
    private final AtomicBoolean inputAvailable;
    private final AtomicBoolean outputAvailable;
    private final AtomicReference<CloseHandshakeSource> closeHandshakeSource;
    private final AtomicReference<CloseInfo> closeInfo;
    private final AtomicBoolean cleanClose;

    public IOState() {
        this.state = ConnectionState.CONNECTING;
        this.inputAvailable = new AtomicBoolean(false);
        this.outputAvailable = new AtomicBoolean(false);
        this.closeHandshakeSource = new AtomicReference<CloseHandshakeSource>(CloseHandshakeSource.NONE);
        this.closeInfo = new AtomicReference();
        this.cleanClose = new AtomicBoolean(false);
    }

    public void addListener(ConnectionStateListener listener) {
        this.listeners.add(listener);
    }

    public void assertInputOpen() throws IOException {
        if (!this.isInputAvailable()) {
            throw new IOException("Connection input is closed");
        }
    }

    public void assertOutputOpen() throws IOException {
        if (!this.isOutputAvailable()) {
            throw new IOException("Connection output is closed");
        }
    }

    public CloseInfo getCloseInfo() {
        return this.closeInfo.get();
    }

    public ConnectionState getConnectionState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        ConnectionState connectionState = this.state;
        synchronized (connectionState) {
            return this.state == ConnectionState.CLOSED;
        }
    }

    public boolean isInputAvailable() {
        return this.inputAvailable.get();
    }

    public boolean isOpen() {
        return this.getConnectionState() != ConnectionState.CLOSED;
    }

    public boolean isOutputAvailable() {
        return this.outputAvailable.get();
    }

    private void notifyStateListeners(ConnectionState state) {
        for (ConnectionStateListener listener : this.listeners) {
            listener.onConnectionStateChange(state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onAbnormalClose(CloseInfo close) {
        ConnectionState event = null;
        ConnectionState connectionState = this.state;
        synchronized (connectionState) {
            if (this.state == ConnectionState.CLOSED) {
                return;
            }
            if (this.state == ConnectionState.OPEN) {
                this.cleanClose.set(false);
            }
            this.state = ConnectionState.CLOSED;
            this.closeInfo.compareAndSet(null, close);
            this.inputAvailable.set(false);
            this.outputAvailable.set(false);
            this.closeHandshakeSource.set(CloseHandshakeSource.ABNORMAL);
            event = this.state;
        }
        this.notifyStateListeners(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCloseLocal(CloseInfo close) {
        ConnectionState event = null;
        ConnectionState initialState = this.state;
        if (initialState == ConnectionState.CLOSED) {
            return;
        }
        if (initialState == ConnectionState.CONNECTED) {
            LOG.debug("FastClose in CONNECTED detected", new Object[0]);
            this.onOpened();
        }
        ConnectionState connectionState = this.state;
        synchronized (connectionState) {
            this.closeInfo.compareAndSet(null, close);
            boolean in = this.inputAvailable.get();
            boolean out = this.outputAvailable.get();
            this.closeHandshakeSource.compareAndSet(CloseHandshakeSource.NONE, CloseHandshakeSource.LOCAL);
            out = false;
            this.outputAvailable.set(false);
            LOG.debug("onCloseLocal(), input={}, output={}", in, out);
            if (!in && !out) {
                LOG.debug("Close Handshake satisfied, disconnecting", new Object[0]);
                this.cleanClose.set(true);
                event = this.state = ConnectionState.CLOSED;
            } else if (this.state == ConnectionState.OPEN) {
                event = this.state = ConnectionState.CLOSING;
            }
        }
        if (event != null) {
            this.notifyStateListeners(event);
            if (close.getStatusCode() == 1001) {
                connectionState = this.state;
                synchronized (connectionState) {
                    this.state = ConnectionState.CLOSED;
                    this.cleanClose.set(false);
                    this.outputAvailable.set(false);
                    this.inputAvailable.set(false);
                    this.closeHandshakeSource.set(CloseHandshakeSource.ABNORMAL);
                    event = this.state;
                }
                this.notifyStateListeners(event);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCloseRemote(CloseInfo close) {
        ConnectionState event = null;
        ConnectionState connectionState = this.state;
        synchronized (connectionState) {
            if (this.state == ConnectionState.CLOSED) {
                return;
            }
            this.closeInfo.compareAndSet(null, close);
            boolean in = this.inputAvailable.get();
            boolean out = this.outputAvailable.get();
            this.closeHandshakeSource.compareAndSet(CloseHandshakeSource.NONE, CloseHandshakeSource.REMOTE);
            in = false;
            this.inputAvailable.set(false);
            LOG.debug("onCloseRemote(), input={}, output={}", in, out);
            if (!in && !out) {
                LOG.debug("Close Handshake satisfied, disconnecting", new Object[0]);
                this.cleanClose.set(true);
                event = this.state = ConnectionState.CLOSED;
            } else if (this.state == ConnectionState.OPEN) {
                event = this.state = ConnectionState.CLOSING;
            }
        }
        if (event != null) {
            this.notifyStateListeners(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onConnected() {
        if (this.state != ConnectionState.CONNECTING) {
            LOG.debug("Unable to set to connected, not in CONNECTING state: {}", new Object[]{this.state});
            return;
        }
        ConnectionState event = null;
        ConnectionState connectionState = this.state;
        synchronized (connectionState) {
            this.state = ConnectionState.CONNECTED;
            this.inputAvailable.set(false);
            this.outputAvailable.set(true);
            event = this.state;
        }
        this.notifyStateListeners(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFailedUpgrade() {
        assert (this.state == ConnectionState.CONNECTING);
        ConnectionState event = null;
        ConnectionState connectionState = this.state;
        synchronized (connectionState) {
            this.state = ConnectionState.CLOSED;
            this.cleanClose.set(false);
            this.inputAvailable.set(false);
            this.outputAvailable.set(false);
            event = this.state;
        }
        this.notifyStateListeners(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onOpened() {
        if (this.state != ConnectionState.CONNECTED) {
            LOG.debug("Unable to open, not in CONNECTED state: {}", new Object[]{this.state});
            return;
        }
        assert (this.state == ConnectionState.CONNECTED);
        ConnectionState event = null;
        ConnectionState connectionState = this.state;
        synchronized (connectionState) {
            this.state = ConnectionState.OPEN;
            this.inputAvailable.set(true);
            this.outputAvailable.set(true);
            event = this.state;
        }
        this.notifyStateListeners(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onReadEOF() {
        ConnectionState event = null;
        ConnectionState connectionState = this.state;
        synchronized (connectionState) {
            if (this.state == ConnectionState.CLOSED) {
                return;
            }
            CloseInfo close = new CloseInfo(1006, "Read EOF");
            this.cleanClose.set(false);
            this.state = ConnectionState.CLOSED;
            this.closeInfo.compareAndSet(null, close);
            this.inputAvailable.set(false);
            this.outputAvailable.set(false);
            this.closeHandshakeSource.set(CloseHandshakeSource.ABNORMAL);
            event = this.state;
        }
        this.notifyStateListeners(event);
    }

    public boolean wasAbnormalClose() {
        return this.closeHandshakeSource.get() == CloseHandshakeSource.ABNORMAL;
    }

    public boolean wasCleanClose() {
        return this.cleanClose.get();
    }

    public boolean wasLocalCloseInitiated() {
        return this.closeHandshakeSource.get() == CloseHandshakeSource.LOCAL;
    }

    public boolean wasRemoteCloseInitiated() {
        return this.closeHandshakeSource.get() == CloseHandshakeSource.REMOTE;
    }

    public static interface ConnectionStateListener {
        public void onConnectionStateChange(ConnectionState var1);
    }

    private static enum CloseHandshakeSource {
        NONE,
        LOCAL,
        REMOTE,
        ABNORMAL;

    }
}

