/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.extensions.mux;

import org.eclipse.jetty.websocket.common.OpCode;
import org.eclipse.jetty.websocket.common.WebSocketFrame;

public class MuxedFrame
extends WebSocketFrame {
    private long channelId = -1L;

    public MuxedFrame() {
    }

    public MuxedFrame(MuxedFrame frame) {
        super(frame);
        this.channelId = frame.channelId;
    }

    public long getChannelId() {
        return this.channelId;
    }

    @Override
    public void reset() {
        super.reset();
        this.channelId = -1L;
    }

    public void setChannelId(long channelId) {
        this.channelId = channelId;
    }

    @Override
    public String toString() {
        StringBuilder b2 = new StringBuilder();
        b2.append(OpCode.name(this.getOpCode()));
        b2.append('[');
        b2.append("channel=").append(this.channelId);
        b2.append(",len=").append(this.getPayloadLength());
        b2.append(",fin=").append(this.isFin());
        b2.append(",rsv=");
        b2.append(this.isRsv1() ? (char)'1' : '.');
        b2.append(this.isRsv2() ? (char)'1' : '.');
        b2.append(this.isRsv3() ? (char)'1' : '.');
        b2.append(",continuation=").append(this.isContinuation());
        b2.append(']');
        return b2.toString();
    }
}

