/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.extensions;

import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.websocket.api.WebSocketException;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.extensions.Extension;
import org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import org.eclipse.jetty.websocket.api.extensions.ExtensionFactory;
import org.eclipse.jetty.websocket.common.extensions.AbstractExtension;
import org.eclipse.jetty.websocket.common.extensions.fragment.FragmentExtension;
import org.eclipse.jetty.websocket.common.extensions.identity.IdentityExtension;

public class WebSocketExtensionFactory
extends ExtensionFactory {
    private WebSocketPolicy policy;
    private ByteBufferPool bufferPool;

    public WebSocketExtensionFactory(WebSocketPolicy policy, ByteBufferPool bufferPool) {
        this.policy = policy;
        this.bufferPool = bufferPool;
        this.register("identity", IdentityExtension.class);
        this.register("fragment", FragmentExtension.class);
    }

    @Override
    public Extension newInstance(ExtensionConfig config) {
        if (config == null) {
            return null;
        }
        String name = config.getName();
        if (StringUtil.isBlank(name)) {
            return null;
        }
        Class<? extends Extension> extClass = this.getExtension(name);
        if (extClass == null) {
            return null;
        }
        try {
            Extension ext = extClass.newInstance();
            if (ext instanceof AbstractExtension) {
                AbstractExtension aext = (AbstractExtension)ext;
                aext.setConfig(config);
                aext.setPolicy(this.policy);
                aext.setBufferPool(this.bufferPool);
            }
            return ext;
        }
        catch (IllegalAccessException | InstantiationException e2) {
            throw new WebSocketException("Cannot instantiate extension: " + extClass, e2);
        }
    }
}

