/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.events;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.Utf8Appendable;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.CloseException;
import org.eclipse.jetty.websocket.api.WebSocketException;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.api.extensions.IncomingFrames;
import org.eclipse.jetty.websocket.common.CloseInfo;
import org.eclipse.jetty.websocket.common.WebSocketSession;

public abstract class EventDriver
implements IncomingFrames {
    private static final Logger LOG = Log.getLogger(EventDriver.class);
    protected final WebSocketPolicy policy;
    protected final Object websocket;
    protected WebSocketSession session;

    public EventDriver(WebSocketPolicy policy, Object websocket) {
        this.policy = policy;
        this.websocket = websocket;
    }

    public WebSocketPolicy getPolicy() {
        return this.policy;
    }

    public WebSocketSession getSession() {
        return this.session;
    }

    @Override
    public final void incomingError(WebSocketException e2) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("incoming(WebSocketException)", e2);
        }
        if (e2 instanceof CloseException) {
            CloseException close = (CloseException)e2;
            this.terminateConnection(close.getStatusCode(), close.getMessage());
        }
        this.onError(e2);
    }

    @Override
    public void incomingFrame(Frame frame) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}.onFrame({})", this.websocket.getClass().getSimpleName(), frame);
        }
        this.onFrame(frame);
        try {
            switch (frame.getType().getOpCode()) {
                case 8: {
                    boolean validate = true;
                    CloseInfo close = new CloseInfo(frame, validate);
                    this.onClose(close);
                    this.session.getConnection().getIOState().onCloseRemote(close);
                    return;
                }
                case 9: {
                    byte[] pongBuf = new byte[]{};
                    if (frame.hasPayload()) {
                        pongBuf = BufferUtil.toArray(frame.getPayload());
                    }
                    this.session.getRemote().sendPong(ByteBuffer.wrap(pongBuf));
                    break;
                }
                case 2: {
                    this.onBinaryFrame(frame.getPayload(), frame.isFin());
                    return;
                }
                case 1: {
                    this.onTextFrame(frame.getPayload(), frame.isFin());
                    return;
                }
            }
        }
        catch (Utf8Appendable.NotUtf8Exception e2) {
            this.terminateConnection(1007, e2.getMessage());
        }
        catch (CloseException e3) {
            this.terminateConnection(e3.getStatusCode(), e3.getMessage());
        }
        catch (Throwable t) {
            this.unhandled(t);
        }
    }

    public abstract void onBinaryFrame(ByteBuffer var1, boolean var2) throws IOException;

    public abstract void onBinaryMessage(byte[] var1);

    public abstract void onClose(CloseInfo var1);

    public abstract void onConnect();

    public abstract void onError(Throwable var1);

    public abstract void onFrame(Frame var1);

    public abstract void onTextFrame(ByteBuffer var1, boolean var2) throws IOException;

    public abstract void onTextMessage(String var1);

    public void openSession(WebSocketSession session) {
        LOG.debug("openSession({})", session);
        this.session = session;
        this.onConnect();
    }

    protected void terminateConnection(int statusCode, String rawreason) {
        String reason = rawreason;
        reason = StringUtil.truncate(reason, 123);
        LOG.debug("terminateConnection({},{})", statusCode, rawreason);
        this.session.close(statusCode, reason);
    }

    private void unhandled(Throwable t) {
        LOG.warn("Unhandled Error (closing connection)", t);
        switch (this.policy.getBehavior()) {
            case SERVER: {
                this.terminateConnection(1011, t.getClass().getSimpleName());
                break;
            }
            case CLIENT: {
                this.terminateConnection(1008, t.getClass().getSimpleName());
            }
        }
    }
}

