/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.api.util;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class QuoteUtil {
    public static final String ABNF_REQUIRED_QUOTING = "\"'\\\n\r\t\f\b%+ ;=";
    private static final char UNICODE_TAG = '\uffff';
    private static final char[] escapes = new char[32];

    private static int dehex(byte b2) {
        if (b2 >= 48 && b2 <= 57) {
            return (byte)(b2 - 48);
        }
        if (b2 >= 97 && b2 <= 102) {
            return (byte)(b2 - 97 + 10);
        }
        if (b2 >= 65 && b2 <= 70) {
            return (byte)(b2 - 65 + 10);
        }
        throw new IllegalArgumentException("!hex:" + Integer.toHexString(0xFF & b2));
    }

    public static String dequote(String str) {
        char end;
        char start = str.charAt(0);
        if ((start == '\'' || start == '\"') && start == (end = str.charAt(str.length() - 1))) {
            return str.substring(1, str.length() - 1);
        }
        return str;
    }

    public static void escape(StringBuilder buf, String str) {
        for (char c2 : str.toCharArray()) {
            if (c2 >= ' ') {
                if (c2 == '\"' || c2 == '\\') {
                    buf.append('\\');
                }
                buf.append(c2);
                continue;
            }
            char escaped = escapes[c2];
            if (escaped == '\uffff') {
                buf.append("\\u00");
                if (c2 < '\u0010') {
                    buf.append('0');
                }
                buf.append(Integer.toString(c2, 16));
                continue;
            }
            buf.append('\\').append(escaped);
        }
    }

    public static void quote(StringBuilder buf, String str) {
        buf.append('\"');
        QuoteUtil.escape(buf, str);
        buf.append('\"');
    }

    public static void quoteIfNeeded(StringBuilder buf, String str, String delim) {
        int len = str.length();
        for (int i2 = 0; i2 < len; ++i2) {
            int ch = str.codePointAt(i2);
            if (delim.indexOf(ch) < 0) continue;
            QuoteUtil.quote(buf, str);
            return;
        }
        buf.append(str);
    }

    public static Iterator<String> splitAt(String str, String delims) {
        return new DeQuotingStringIterator(str.trim(), delims);
    }

    public static String unescape(String str) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len <= 1) {
            return str;
        }
        StringBuilder ret = new StringBuilder(len - 2);
        boolean escaped = false;
        for (int i2 = 0; i2 < len; ++i2) {
            char c2 = str.charAt(i2);
            if (escaped) {
                escaped = false;
                switch (c2) {
                    case 'n': {
                        ret.append('\n');
                        break;
                    }
                    case 'r': {
                        ret.append('\r');
                        break;
                    }
                    case 't': {
                        ret.append('\t');
                        break;
                    }
                    case 'f': {
                        ret.append('\f');
                        break;
                    }
                    case 'b': {
                        ret.append('\b');
                        break;
                    }
                    case '\\': {
                        ret.append('\\');
                        break;
                    }
                    case '/': {
                        ret.append('/');
                        break;
                    }
                    case '\"': {
                        ret.append('\"');
                        break;
                    }
                    case 'u': {
                        ret.append((char)((QuoteUtil.dehex((byte)str.charAt(i2++)) << 24) + (QuoteUtil.dehex((byte)str.charAt(i2++)) << 16) + (QuoteUtil.dehex((byte)str.charAt(i2++)) << 8) + QuoteUtil.dehex((byte)str.charAt(i2++))));
                        break;
                    }
                    default: {
                        ret.append(c2);
                        break;
                    }
                }
                continue;
            }
            if (c2 == '\\') {
                escaped = true;
                continue;
            }
            ret.append(c2);
        }
        return ret.toString();
    }

    static {
        Arrays.fill(escapes, '\uffff');
        QuoteUtil.escapes[8] = 98;
        QuoteUtil.escapes[9] = 116;
        QuoteUtil.escapes[10] = 110;
        QuoteUtil.escapes[12] = 102;
        QuoteUtil.escapes[13] = 114;
    }

    private static class DeQuotingStringIterator
    implements Iterator<String> {
        private static final boolean DEBUG = false;
        private final String input;
        private final String delims;
        private StringBuilder token;
        private boolean hasToken = false;
        private int i = 0;

        public DeQuotingStringIterator(String input, String delims) {
            this.input = input;
            this.delims = delims;
            int len = input.length();
            this.token = new StringBuilder(len > 1024 ? 512 : len / 2);
        }

        private void appendToken(char c2) {
            if (this.hasToken) {
                this.token.append(c2);
            } else {
                if (Character.isWhitespace(c2)) {
                    return;
                }
                this.token.append(c2);
                this.hasToken = true;
            }
        }

        private void debug(String format, Object ... args) {
        }

        @Override
        public boolean hasNext() {
            if (this.hasToken) {
                return true;
            }
            State state = State.START;
            boolean escape = false;
            int inputLen = this.input.length();
            while (this.i < inputLen) {
                char c2 = this.input.charAt(this.i++);
                switch (state) {
                    case START: {
                        if (c2 == '\'') {
                            state = State.QUOTE_SINGLE;
                            this.appendToken(c2);
                            break;
                        }
                        if (c2 == '\"') {
                            state = State.QUOTE_DOUBLE;
                            this.appendToken(c2);
                            break;
                        }
                        this.appendToken(c2);
                        state = State.TOKEN;
                        break;
                    }
                    case TOKEN: {
                        if (this.delims.indexOf(c2) >= 0) {
                            this.debug("hasNext/t: %b [%s]%n", this.hasToken, this.token);
                            return this.hasToken;
                        }
                        if (c2 == '\'') {
                            state = State.QUOTE_SINGLE;
                        } else if (c2 == '\"') {
                            state = State.QUOTE_DOUBLE;
                        }
                        this.appendToken(c2);
                        break;
                    }
                    case QUOTE_SINGLE: {
                        if (escape) {
                            escape = false;
                            this.appendToken(c2);
                            break;
                        }
                        if (c2 == '\'') {
                            this.appendToken(c2);
                            state = State.TOKEN;
                            break;
                        }
                        if (c2 == '\\') {
                            escape = true;
                            break;
                        }
                        this.appendToken(c2);
                        break;
                    }
                    case QUOTE_DOUBLE: {
                        if (escape) {
                            escape = false;
                            this.appendToken(c2);
                            break;
                        }
                        if (c2 == '\"') {
                            this.appendToken(c2);
                            state = State.TOKEN;
                            break;
                        }
                        if (c2 == '\\') {
                            escape = true;
                            break;
                        }
                        this.appendToken(c2);
                    }
                }
                this.debug("%s <%s> : [%s]%n", new Object[]{state, Character.valueOf(c2), this.token});
            }
            this.debug("hasNext/e: %b [%s]%n", this.hasToken, this.token);
            return this.hasToken;
        }

        @Override
        public String next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            String ret = this.token.toString();
            this.token.setLength(0);
            this.hasToken = false;
            return QuoteUtil.dequote(ret.trim());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove not supported with this iterator");
        }

        private static enum State {
            START,
            TOKEN,
            QUOTE_SINGLE,
            QUOTE_DOUBLE;

        }
    }
}

