/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.component;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.ManagedOperation;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.component.Destroyable;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

@ManagedObject(value="Implementation of Container and LifeCycle")
public class ContainerLifeCycle
extends AbstractLifeCycle
implements Container,
Destroyable,
Dumpable {
    private static final Logger LOG = Log.getLogger(ContainerLifeCycle.class);
    private final List<Bean> _beans = new CopyOnWriteArrayList<Bean>();
    private final List<Container.Listener> _listeners = new CopyOnWriteArrayList<Container.Listener>();
    private boolean _started = false;

    @Override
    protected void doStart() throws Exception {
        this._started = true;
        for (Bean b2 : this._beans) {
            if (!(b2._bean instanceof LifeCycle)) continue;
            LifeCycle l2 = (LifeCycle)b2._bean;
            switch (b2._managed) {
                case MANAGED: {
                    if (l2.isRunning()) break;
                    this.start(l2);
                    break;
                }
                case AUTO: {
                    if (l2.isRunning()) {
                        this.unmanage(b2);
                        break;
                    }
                    this.manage(b2);
                    this.start(l2);
                }
            }
        }
        super.doStart();
    }

    protected void start(LifeCycle l2) throws Exception {
        l2.start();
    }

    @Override
    protected void doStop() throws Exception {
        this._started = false;
        super.doStop();
        ArrayList<Bean> reverse = new ArrayList<Bean>(this._beans);
        Collections.reverse(reverse);
        for (Bean b2 : reverse) {
            LifeCycle l2;
            if (b2._managed != Managed.MANAGED || !(b2._bean instanceof LifeCycle) || !(l2 = (LifeCycle)b2._bean).isRunning()) continue;
            l2.stop();
        }
    }

    @Override
    public void destroy() {
        ArrayList<Bean> reverse = new ArrayList<Bean>(this._beans);
        Collections.reverse(reverse);
        for (Bean b2 : reverse) {
            if (!(b2._bean instanceof Destroyable) || b2._managed != Managed.MANAGED && b2._managed != Managed.POJO) continue;
            Destroyable d2 = (Destroyable)b2._bean;
            d2.destroy();
        }
        this._beans.clear();
    }

    public boolean contains(Object bean) {
        for (Bean b2 : this._beans) {
            if (b2._bean != bean) continue;
            return true;
        }
        return false;
    }

    public boolean isManaged(Object bean) {
        for (Bean b2 : this._beans) {
            if (b2._bean != bean) continue;
            return b2.isManaged();
        }
        return false;
    }

    @Override
    public boolean addBean(Object o2) {
        if (o2 instanceof LifeCycle) {
            LifeCycle l2 = (LifeCycle)o2;
            return this.addBean(o2, l2.isRunning() ? Managed.UNMANAGED : Managed.AUTO);
        }
        return this.addBean(o2, Managed.POJO);
    }

    public boolean addBean(Object o2, boolean managed) {
        if (o2 instanceof LifeCycle) {
            return this.addBean(o2, managed ? Managed.MANAGED : Managed.UNMANAGED);
        }
        return this.addBean(o2, managed ? Managed.POJO : Managed.UNMANAGED);
    }

    public boolean addBean(Object o2, Managed managed) {
        if (this.contains(o2)) {
            return false;
        }
        Bean new_bean = new Bean(o2);
        if (o2 instanceof Container.Listener) {
            Container.Listener listener = (Container.Listener)o2;
            this._listeners.add(listener);
            for (Bean b2 : this._beans) {
                listener.beanAdded(this, b2._bean);
                if (!(listener instanceof Container.InheritedListener) || !b2.isManaged() || !(b2._bean instanceof Container)) continue;
                if (b2._bean instanceof ContainerLifeCycle) {
                    ((ContainerLifeCycle)b2._bean).addBean((Object)listener, false);
                    continue;
                }
                ((Container)b2._bean).addBean(listener);
            }
        }
        this._beans.add(new_bean);
        for (Container.Listener l2 : this._listeners) {
            l2.beanAdded(this, o2);
        }
        try {
            switch (managed) {
                case UNMANAGED: {
                    this.unmanage(new_bean);
                    break;
                }
                case MANAGED: {
                    this.manage(new_bean);
                    if (!this._started) break;
                    LifeCycle l3 = (LifeCycle)o2;
                    if (!l3.isRunning()) {
                        l3.start();
                    }
                    break;
                }
                case AUTO: {
                    LifeCycle l3;
                    if (o2 instanceof LifeCycle) {
                        l3 = (LifeCycle)o2;
                        if (this._started) {
                            if (l3.isRunning()) {
                                this.unmanage(new_bean);
                                break;
                            }
                            this.manage(new_bean);
                            l3.start();
                            break;
                        }
                        new_bean._managed = Managed.AUTO;
                        break;
                    }
                    new_bean._managed = Managed.POJO;
                    break;
                }
                case POJO: {
                    new_bean._managed = Managed.POJO;
                }
            }
        }
        catch (Error | RuntimeException e2) {
            throw e2;
        }
        catch (Exception e3) {
            throw new RuntimeException(e3);
        }
        LOG.debug("{} added {}", this, new_bean);
        return true;
    }

    public void manage(Object bean) {
        for (Bean b2 : this._beans) {
            if (b2._bean != bean) continue;
            this.manage(b2);
            return;
        }
        throw new IllegalArgumentException("Unknown bean " + bean);
    }

    private void manage(Bean bean) {
        if (bean._managed != Managed.MANAGED) {
            bean._managed = Managed.MANAGED;
            if (bean._bean instanceof Container) {
                for (Container.Listener l2 : this._listeners) {
                    if (!(l2 instanceof Container.InheritedListener)) continue;
                    if (bean._bean instanceof ContainerLifeCycle) {
                        ((ContainerLifeCycle)bean._bean).addBean((Object)l2, false);
                        continue;
                    }
                    ((Container)bean._bean).addBean(l2);
                }
            }
            if (bean._bean instanceof AbstractLifeCycle) {
                ((AbstractLifeCycle)bean._bean).setStopTimeout(this.getStopTimeout());
            }
        }
    }

    public void unmanage(Object bean) {
        for (Bean b2 : this._beans) {
            if (b2._bean != bean) continue;
            this.unmanage(b2);
            return;
        }
        throw new IllegalArgumentException("Unknown bean " + bean);
    }

    private void unmanage(Bean bean) {
        if (bean._managed != Managed.UNMANAGED) {
            if (bean._managed == Managed.MANAGED && bean._bean instanceof Container) {
                for (Container.Listener l2 : this._listeners) {
                    if (!(l2 instanceof Container.InheritedListener)) continue;
                    ((Container)bean._bean).removeBean(l2);
                }
            }
            bean._managed = Managed.UNMANAGED;
        }
    }

    @Override
    public Collection<Object> getBeans() {
        return this.getBeans(Object.class);
    }

    public void setBeans(Collection<Object> beans) {
        for (Object bean : beans) {
            this.addBean(bean);
        }
    }

    @Override
    public <T> Collection<T> getBeans(Class<T> clazz) {
        ArrayList<T> beans = new ArrayList<T>();
        for (Bean b2 : this._beans) {
            if (!clazz.isInstance(b2._bean)) continue;
            beans.add(clazz.cast(b2._bean));
        }
        return beans;
    }

    @Override
    public <T> T getBean(Class<T> clazz) {
        for (Bean b2 : this._beans) {
            if (!clazz.isInstance(b2._bean)) continue;
            return clazz.cast(b2._bean);
        }
        return null;
    }

    public void removeBeans() {
        ArrayList<Bean> beans = new ArrayList<Bean>(this._beans);
        for (Bean b2 : beans) {
            this.remove(b2);
        }
    }

    private Bean getBean(Object o2) {
        for (Bean b2 : this._beans) {
            if (b2._bean != o2) continue;
            return b2;
        }
        return null;
    }

    @Override
    public boolean removeBean(Object o2) {
        Bean b2 = this.getBean(o2);
        return b2 != null && this.remove(b2);
    }

    private boolean remove(Bean bean) {
        if (this._beans.remove(bean)) {
            Container.Listener listener;
            this.unmanage(bean);
            for (Container.Listener l2 : this._listeners) {
                l2.beanRemoved(this, bean._bean);
            }
            if (bean._bean instanceof Container.Listener && this._listeners.remove(listener = (Container.Listener)bean._bean)) {
                for (Bean b2 : this._beans) {
                    listener.beanRemoved(this, b2._bean);
                    if (!(listener instanceof Container.InheritedListener) || !b2.isManaged() || !(b2._bean instanceof Container)) continue;
                    ((Container)b2._bean).removeBean(listener);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void setStopTimeout(long stopTimeout) {
        super.setStopTimeout(stopTimeout);
        for (Bean bean : this._beans) {
            if (!bean.isManaged() || !(bean._bean instanceof AbstractLifeCycle)) continue;
            ((AbstractLifeCycle)bean._bean).setStopTimeout(stopTimeout);
        }
    }

    @ManagedOperation(value="Dump the object to stderr")
    public void dumpStdErr() {
        try {
            this.dump(System.err, "");
        }
        catch (IOException e2) {
            LOG.warn(e2);
        }
    }

    @Override
    @ManagedOperation(value="Dump the object to a string")
    public String dump() {
        return ContainerLifeCycle.dump(this);
    }

    public static String dump(Dumpable dumpable) {
        StringBuilder b2 = new StringBuilder();
        try {
            dumpable.dump(b2, "");
        }
        catch (IOException e2) {
            LOG.warn(e2);
        }
        return b2.toString();
    }

    public void dump(Appendable out) throws IOException {
        this.dump(out, "");
    }

    protected void dumpThis(Appendable out) throws IOException {
        out.append(String.valueOf(this)).append(" - ").append(this.getState()).append("\n");
    }

    public static void dumpObject(Appendable out, Object o2) throws IOException {
        try {
            if (o2 instanceof LifeCycle) {
                out.append(String.valueOf(o2)).append(" - ").append(AbstractLifeCycle.getState((LifeCycle)o2)).append("\n");
            } else {
                out.append(String.valueOf(o2)).append("\n");
            }
        }
        catch (Throwable th) {
            out.append(" => ").append(th.toString()).append('\n');
        }
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        this.dumpBeans(out, indent, new Collection[0]);
    }

    protected void dumpBeans(Appendable out, String indent, Collection<?> ... collections) throws IOException {
        this.dumpThis(out);
        int size = this._beans.size();
        for (Collection<?> c2 : collections) {
            size += c2.size();
        }
        if (size == 0) {
            return;
        }
        int i2 = 0;
        for (Bean b2 : this._beans) {
            ++i2;
            switch (b2._managed) {
                case POJO: {
                    out.append(indent).append(" +- ");
                    if (b2._bean instanceof Dumpable) {
                        ((Dumpable)b2._bean).dump(out, indent + (i2 == size ? "    " : " |  "));
                        break;
                    }
                    ContainerLifeCycle.dumpObject(out, b2._bean);
                    break;
                }
                case MANAGED: {
                    out.append(indent).append(" += ");
                    if (b2._bean instanceof Dumpable) {
                        ((Dumpable)b2._bean).dump(out, indent + (i2 == size ? "    " : " |  "));
                        break;
                    }
                    ContainerLifeCycle.dumpObject(out, b2._bean);
                    break;
                }
                case UNMANAGED: {
                    out.append(indent).append(" +~ ");
                    ContainerLifeCycle.dumpObject(out, b2._bean);
                    break;
                }
                case AUTO: {
                    out.append(indent).append(" +? ");
                    if (b2._bean instanceof Dumpable) {
                        ((Dumpable)b2._bean).dump(out, indent + (i2 == size ? "    " : " |  "));
                        break;
                    }
                    ContainerLifeCycle.dumpObject(out, b2._bean);
                }
            }
        }
        if (i2 < size) {
            out.append(indent).append(" |\n");
        }
        for (Collection<?> c3 : collections) {
            for (Object o2 : c3) {
                ++i2;
                out.append(indent).append(" +> ");
                if (o2 instanceof Dumpable) {
                    ((Dumpable)o2).dump(out, indent + (i2 == size ? "    " : " |  "));
                    continue;
                }
                ContainerLifeCycle.dumpObject(out, o2);
            }
        }
    }

    public static void dump(Appendable out, String indent, Collection<?> ... collections) throws IOException {
        if (collections.length == 0) {
            return;
        }
        int size = 0;
        for (Collection<?> c2 : collections) {
            size += c2.size();
        }
        if (size == 0) {
            return;
        }
        int i2 = 0;
        for (Collection<?> c3 : collections) {
            for (Object o2 : c3) {
                ++i2;
                out.append(indent).append(" +- ");
                if (o2 instanceof Dumpable) {
                    ((Dumpable)o2).dump(out, indent + (i2 == size ? "    " : " |  "));
                    continue;
                }
                ContainerLifeCycle.dumpObject(out, o2);
            }
        }
    }

    public void updateBean(Object oldBean, Object newBean) {
        if (newBean != oldBean) {
            if (oldBean != null) {
                this.removeBean(oldBean);
            }
            if (newBean != null) {
                this.addBean(newBean);
            }
        }
    }

    public void updateBeans(Object[] oldBeans, Object[] newBeans) {
        if (oldBeans != null) {
            block0: for (Object o2 : oldBeans) {
                if (newBeans != null) {
                    for (Object n2 : newBeans) {
                        if (o2 == n2) continue block0;
                    }
                }
                this.removeBean(o2);
            }
        }
        if (newBeans != null) {
            block2: for (Object n3 : newBeans) {
                if (oldBeans != null) {
                    for (Object o3 : oldBeans) {
                        if (o3 == n3) continue block2;
                    }
                }
                this.addBean(n3);
            }
        }
    }

    private static class Bean {
        private final Object _bean;
        private volatile Managed _managed = Managed.POJO;

        private Bean(Object b2) {
            this._bean = b2;
        }

        public boolean isManaged() {
            return this._managed == Managed.MANAGED;
        }

        public String toString() {
            return String.format("{%s,%s}", new Object[]{this._bean, this._managed});
        }
    }

    static enum Managed {
        POJO,
        MANAGED,
        UNMANAGED,
        AUTO;

    }
}

