/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.eclipse.jetty.util.ByteArrayOutputStream2;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.MultiMap;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.Utf8Appendable;
import org.eclipse.jetty.util.Utf8StringBuffer;
import org.eclipse.jetty.util.Utf8StringBuilder;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class UrlEncoded
extends MultiMap<String>
implements Cloneable {
    static final Logger LOG = Log.getLogger(UrlEncoded.class);
    public static final Charset ENCODING;

    public UrlEncoded(UrlEncoded url) {
        super(url);
    }

    public UrlEncoded() {
    }

    public void decode(String query) {
        UrlEncoded.decodeTo(query, (MultiMap<String>)this, ENCODING, -1);
    }

    public void decode(String query, Charset charset) {
        UrlEncoded.decodeTo(query, (MultiMap<String>)this, charset, -1);
    }

    public String encode() {
        return this.encode(ENCODING, false);
    }

    public String encode(Charset charset) {
        return this.encode(charset, false);
    }

    public synchronized String encode(Charset charset, boolean equalsForNullValue) {
        return UrlEncoded.encode(this, charset, equalsForNullValue);
    }

    public static String encode(MultiMap<String> map, Charset charset, boolean equalsForNullValue) {
        if (charset == null) {
            charset = ENCODING;
        }
        StringBuilder result = new StringBuilder(128);
        boolean delim = false;
        for (Map.Entry entry : map.entrySet()) {
            String key = ((String)entry.getKey()).toString();
            List list = (List)entry.getValue();
            int s = list.size();
            if (delim) {
                result.append('&');
            }
            if (s == 0) {
                result.append(UrlEncoded.encodeString(key, charset));
                if (equalsForNullValue) {
                    result.append('=');
                }
            } else {
                for (int i2 = 0; i2 < s; ++i2) {
                    if (i2 > 0) {
                        result.append('&');
                    }
                    String val = (String)list.get(i2);
                    result.append(UrlEncoded.encodeString(key, charset));
                    if (val != null) {
                        String str = val.toString();
                        if (str.length() > 0) {
                            result.append('=');
                            result.append(UrlEncoded.encodeString(str, charset));
                            continue;
                        }
                        if (!equalsForNullValue) continue;
                        result.append('=');
                        continue;
                    }
                    if (!equalsForNullValue) continue;
                    result.append('=');
                }
            }
            delim = true;
        }
        return result.toString();
    }

    public static void decodeTo(String content, MultiMap<String> map, String charset, int maxKeys) {
        UrlEncoded.decodeTo(content, map, charset == null ? null : Charset.forName(charset), maxKeys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decodeTo(String content, MultiMap<String> map, Charset charset, int maxKeys) {
        if (charset == null) {
            charset = ENCODING;
        }
        MultiMap<String> multiMap = map;
        synchronized (multiMap) {
            String key = null;
            String value = null;
            int mark = -1;
            boolean encoded = false;
            block9: for (int i2 = 0; i2 < content.length(); ++i2) {
                char c2 = content.charAt(i2);
                switch (c2) {
                    case '&': {
                        int l2 = i2 - mark - 1;
                        value = l2 == 0 ? "" : (encoded ? UrlEncoded.decodeString(content, mark + 1, l2, charset) : content.substring(mark + 1, i2));
                        mark = i2;
                        encoded = false;
                        if (key != null) {
                            map.add(key, value);
                        } else if (value != null && value.length() > 0) {
                            map.add(value, "");
                        }
                        key = null;
                        value = null;
                        if (maxKeys <= 0 || map.size() <= maxKeys) continue block9;
                        throw new IllegalStateException("Form too many keys");
                    }
                    case '=': {
                        if (key != null) continue block9;
                        key = encoded ? UrlEncoded.decodeString(content, mark + 1, i2 - mark - 1, charset) : content.substring(mark + 1, i2);
                        mark = i2;
                        encoded = false;
                        continue block9;
                    }
                    case '+': {
                        encoded = true;
                        continue block9;
                    }
                    case '%': {
                        encoded = true;
                    }
                }
            }
            if (key != null) {
                int l3 = content.length() - mark - 1;
                value = l3 == 0 ? "" : (encoded ? UrlEncoded.decodeString(content, mark + 1, l3, charset) : content.substring(mark + 1));
                map.add(key, value);
            } else if (mark < content.length()) {
                String string = key = encoded ? UrlEncoded.decodeString(content, mark + 1, content.length() - mark - 1, charset) : content.substring(mark + 1);
                if (key != null && key.length() > 0) {
                    map.add(key, "");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decodeUtf8To(byte[] raw, int offset, int length, MultiMap<String> map) {
        Utf8StringBuilder buffer = new Utf8StringBuilder();
        MultiMap<String> multiMap = map;
        synchronized (multiMap) {
            String key = null;
            String value = null;
            int end = offset + length;
            for (int i2 = offset; i2 < end; ++i2) {
                byte b2 = raw[i2];
                try {
                    switch ((char)(0xFF & b2)) {
                        case '&': {
                            value = buffer.length() == 0 ? "" : buffer.toString();
                            buffer.reset();
                            if (key != null) {
                                map.add(key, value);
                            } else if (value != null && value.length() > 0) {
                                map.add(value, "");
                            }
                            key = null;
                            value = null;
                            break;
                        }
                        case '=': {
                            if (key != null) {
                                buffer.append(b2);
                                break;
                            }
                            key = buffer.toString();
                            buffer.reset();
                            break;
                        }
                        case '+': {
                            buffer.append((byte)32);
                            break;
                        }
                        case '%': {
                            if (i2 + 2 < end) {
                                if (117 == raw[i2 + 1]) {
                                    if (++i2 + 4 < end) {
                                        buffer.getStringBuilder().append(Character.toChars((TypeUtil.convertHexDigit(raw[++i2]) << 12) + (TypeUtil.convertHexDigit(raw[++i2]) << 8) + (TypeUtil.convertHexDigit(raw[++i2]) << 4) + TypeUtil.convertHexDigit(raw[++i2])));
                                        break;
                                    }
                                    buffer.getStringBuilder().append('\ufffd');
                                    i2 = end;
                                    break;
                                }
                                buffer.append((byte)((TypeUtil.convertHexDigit(raw[++i2]) << 4) + TypeUtil.convertHexDigit(raw[++i2])));
                                break;
                            }
                            buffer.getStringBuilder().append('\ufffd');
                            i2 = end;
                            break;
                        }
                        default: {
                            buffer.append(b2);
                            break;
                        }
                    }
                    continue;
                }
                catch (Utf8Appendable.NotUtf8Exception e2) {
                    LOG.warn(e2.toString(), new Object[0]);
                    LOG.debug(e2);
                }
            }
            if (key != null) {
                value = buffer.length() == 0 ? "" : buffer.toReplacedString();
                buffer.reset();
                map.add(key, value);
            } else if (buffer.length() > 0) {
                map.add(buffer.toReplacedString(), "");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decode88591To(InputStream in, MultiMap<String> map, int maxLength, int maxKeys) throws IOException {
        MultiMap<String> multiMap = map;
        synchronized (multiMap) {
            int b2;
            StringBuffer buffer = new StringBuffer();
            String key = null;
            String value = null;
            int totalLength = 0;
            while ((b2 = in.read()) >= 0) {
                switch ((char)b2) {
                    case '&': {
                        value = buffer.length() == 0 ? "" : buffer.toString();
                        buffer.setLength(0);
                        if (key != null) {
                            map.add(key, value);
                        } else if (value != null && value.length() > 0) {
                            map.add(value, "");
                        }
                        key = null;
                        value = null;
                        if (maxKeys <= 0 || map.size() <= maxKeys) break;
                        throw new IllegalStateException("Form too many keys");
                    }
                    case '=': {
                        if (key != null) {
                            buffer.append((char)b2);
                            break;
                        }
                        key = buffer.toString();
                        buffer.setLength(0);
                        break;
                    }
                    case '+': {
                        buffer.append(' ');
                        break;
                    }
                    case '%': {
                        int code1;
                        int code0 = in.read();
                        if (117 == code0) {
                            int code3;
                            int code2;
                            code1 = in.read();
                            if (code1 < 0 || (code2 = in.read()) < 0 || (code3 = in.read()) < 0) break;
                            buffer.append(Character.toChars((TypeUtil.convertHexDigit(code0) << 12) + (TypeUtil.convertHexDigit(code1) << 8) + (TypeUtil.convertHexDigit(code2) << 4) + TypeUtil.convertHexDigit(code3)));
                            break;
                        }
                        if (code0 < 0 || (code1 = in.read()) < 0) break;
                        buffer.append((char)((TypeUtil.convertHexDigit(code0) << 4) + TypeUtil.convertHexDigit(code1)));
                        break;
                    }
                    default: {
                        buffer.append((char)b2);
                    }
                }
                if (maxLength < 0 || ++totalLength <= maxLength) continue;
                throw new IllegalStateException("Form too large");
            }
            if (key != null) {
                value = buffer.length() == 0 ? "" : buffer.toString();
                buffer.setLength(0);
                map.add(key, value);
            } else if (buffer.length() > 0) {
                map.add(buffer.toString(), "");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decodeUtf8To(InputStream in, MultiMap<String> map, int maxLength, int maxKeys) throws IOException {
        MultiMap<String> multiMap = map;
        synchronized (multiMap) {
            int b2;
            Utf8StringBuilder buffer = new Utf8StringBuilder();
            String key = null;
            String value = null;
            int totalLength = 0;
            while ((b2 = in.read()) >= 0) {
                try {
                    switch ((char)b2) {
                        case '&': {
                            value = buffer.length() == 0 ? "" : buffer.toString();
                            buffer.reset();
                            if (key != null) {
                                map.add(key, value);
                            } else if (value != null && value.length() > 0) {
                                map.add(value, "");
                            }
                            key = null;
                            value = null;
                            if (maxKeys > 0 && map.size() > maxKeys) {
                                throw new IllegalStateException("Form too many keys");
                            }
                            break;
                        }
                        case '=': {
                            if (key != null) {
                                buffer.append((byte)b2);
                                break;
                            }
                            key = buffer.toString();
                            buffer.reset();
                            break;
                        }
                        case '+': {
                            buffer.append((byte)32);
                            break;
                        }
                        case '%': {
                            int code1;
                            int code0 = in.read();
                            if (117 == code0) {
                                int code3;
                                int code2;
                                code1 = in.read();
                                if (code1 >= 0 && (code2 = in.read()) >= 0 && (code3 = in.read()) >= 0) {
                                    buffer.getStringBuilder().append(Character.toChars((TypeUtil.convertHexDigit(code0) << 12) + (TypeUtil.convertHexDigit(code1) << 8) + (TypeUtil.convertHexDigit(code2) << 4) + TypeUtil.convertHexDigit(code3)));
                                }
                            } else if (code0 >= 0 && (code1 = in.read()) >= 0) {
                                buffer.append((byte)((TypeUtil.convertHexDigit(code0) << 4) + TypeUtil.convertHexDigit(code1)));
                            }
                            break;
                        }
                        default: {
                            buffer.append((byte)b2);
                        }
                    }
                }
                catch (Utf8Appendable.NotUtf8Exception e2) {
                    LOG.warn(e2.toString(), new Object[0]);
                    LOG.debug(e2);
                }
                if (maxLength < 0 || ++totalLength <= maxLength) continue;
                throw new IllegalStateException("Form too large");
            }
            if (key != null) {
                value = buffer.length() == 0 ? "" : buffer.toString();
                buffer.reset();
                map.add(key, value);
            } else if (buffer.length() > 0) {
                map.add(buffer.toString(), "");
            }
        }
    }

    public static void decodeUtf16To(InputStream in, MultiMap<String> map, int maxLength, int maxKeys) throws IOException {
        InputStreamReader input = new InputStreamReader(in, "UTF-16");
        StringWriter buf = new StringWriter(8192);
        IO.copy(input, buf, (long)maxLength);
        UrlEncoded.decodeTo(buf.getBuffer().toString(), map, "UTF-16", maxKeys);
    }

    public static void decodeTo(InputStream in, MultiMap<String> map, String charset, int maxLength, int maxKeys) throws IOException {
        if (charset == null) {
            if (ENCODING == StringUtil.__UTF8_CHARSET) {
                UrlEncoded.decodeUtf8To(in, map, maxLength, maxKeys);
            } else {
                UrlEncoded.decodeTo(in, map, ENCODING, maxLength, maxKeys);
            }
        } else if ("UTF-8".equalsIgnoreCase(charset)) {
            UrlEncoded.decodeUtf8To(in, map, maxLength, maxKeys);
        } else if ("ISO-8859-1".equalsIgnoreCase(charset)) {
            UrlEncoded.decode88591To(in, map, maxLength, maxKeys);
        } else if ("UTF-16".equalsIgnoreCase(charset)) {
            UrlEncoded.decodeUtf16To(in, map, maxLength, maxKeys);
        } else {
            UrlEncoded.decodeTo(in, map, Charset.forName(charset), maxLength, maxKeys);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decodeTo(InputStream in, MultiMap<String> map, Charset charset, int maxLength, int maxKeys) throws IOException {
        if (charset == null) {
            charset = ENCODING;
        }
        if (StringUtil.__UTF8_CHARSET.equals(charset)) {
            UrlEncoded.decodeUtf8To(in, map, maxLength, maxKeys);
            return;
        }
        if (StringUtil.__ISO_8859_1_CHARSET.equals(charset)) {
            UrlEncoded.decode88591To(in, map, maxLength, maxKeys);
            return;
        }
        if (StringUtil.__UTF16_CHARSET.equals(charset)) {
            UrlEncoded.decodeUtf16To(in, map, maxLength, maxKeys);
            return;
        }
        MultiMap<String> multiMap = map;
        synchronized (multiMap) {
            int c2;
            String key = null;
            String value = null;
            int totalLength = 0;
            ByteArrayOutputStream2 output = new ByteArrayOutputStream2();
            int size = 0;
            while ((c2 = in.read()) > 0) {
                switch ((char)c2) {
                    case '&': {
                        size = output.size();
                        value = size == 0 ? "" : output.toString(charset);
                        output.setCount(0);
                        if (key != null) {
                            map.add(key, value);
                        } else if (value != null && value.length() > 0) {
                            map.add(value, "");
                        }
                        key = null;
                        value = null;
                        if (maxKeys <= 0 || map.size() <= maxKeys) break;
                        throw new IllegalStateException("Form too many keys");
                    }
                    case '=': {
                        if (key != null) {
                            output.write(c2);
                            break;
                        }
                        size = output.size();
                        key = size == 0 ? "" : output.toString(charset);
                        output.setCount(0);
                        break;
                    }
                    case '+': {
                        output.write(32);
                        break;
                    }
                    case '%': {
                        int code1;
                        int code0 = in.read();
                        if (117 == code0) {
                            int code3;
                            int code2;
                            code1 = in.read();
                            if (code1 < 0 || (code2 = in.read()) < 0 || (code3 = in.read()) < 0) break;
                            output.write(new String(Character.toChars((TypeUtil.convertHexDigit(code0) << 12) + (TypeUtil.convertHexDigit(code1) << 8) + (TypeUtil.convertHexDigit(code2) << 4) + TypeUtil.convertHexDigit(code3))).getBytes(charset));
                            break;
                        }
                        if (code0 < 0 || (code1 = in.read()) < 0) break;
                        output.write((TypeUtil.convertHexDigit(code0) << 4) + TypeUtil.convertHexDigit(code1));
                        break;
                    }
                    default: {
                        output.write(c2);
                    }
                }
                if (maxLength < 0 || ++totalLength <= maxLength) continue;
                throw new IllegalStateException("Form too large");
            }
            size = output.size();
            if (key != null) {
                value = size == 0 ? "" : output.toString(charset);
                output.setCount(0);
                map.add(key, value);
            } else if (size > 0) {
                map.add(output.toString(charset), "");
            }
        }
    }

    public static String decodeString(String encoded, int offset, int length, Charset charset) {
        if (charset == null || StringUtil.__UTF8_CHARSET.equals(charset)) {
            Utf8Appendable buffer = null;
            for (int i2 = 0; i2 < length; ++i2) {
                char c2 = encoded.charAt(offset + i2);
                if (c2 < '\u0000' || c2 > '\u00ff') {
                    if (buffer == null) {
                        buffer = new Utf8StringBuffer(length);
                        ((Utf8StringBuffer)buffer).getStringBuffer().append(encoded, offset, offset + i2 + 1);
                        continue;
                    }
                    ((Utf8StringBuffer)buffer).getStringBuffer().append(c2);
                    continue;
                }
                if (c2 == '+') {
                    if (buffer == null) {
                        buffer = new Utf8StringBuffer(length);
                        ((Utf8StringBuffer)buffer).getStringBuffer().append(encoded, offset, offset + i2);
                    }
                    ((Utf8StringBuffer)buffer).getStringBuffer().append(' ');
                    continue;
                }
                if (c2 == '%') {
                    if (buffer == null) {
                        buffer = new Utf8StringBuffer(length);
                        ((Utf8StringBuffer)buffer).getStringBuffer().append(encoded, offset, offset + i2);
                    }
                    if (i2 + 2 < length) {
                        try {
                            if ('u' == encoded.charAt(offset + i2 + 1)) {
                                if (i2 + 5 < length) {
                                    int o2 = offset + i2 + 2;
                                    i2 += 5;
                                    String unicode = new String(Character.toChars(TypeUtil.parseInt(encoded, o2, 4, 16)));
                                    ((Utf8StringBuffer)buffer).getStringBuffer().append(unicode);
                                    continue;
                                }
                                i2 = length;
                                ((Utf8StringBuffer)buffer).getStringBuffer().append('\ufffd');
                                continue;
                            }
                            int o3 = offset + i2 + 1;
                            i2 += 2;
                            byte b2 = (byte)TypeUtil.parseInt(encoded, o3, 2, 16);
                            buffer.append(b2);
                        }
                        catch (Utf8Appendable.NotUtf8Exception e2) {
                            LOG.warn(e2.toString(), new Object[0]);
                            LOG.debug(e2);
                        }
                        catch (NumberFormatException nfe) {
                            LOG.debug(nfe);
                            ((Utf8StringBuffer)buffer).getStringBuffer().append('\ufffd');
                        }
                        continue;
                    }
                    ((Utf8StringBuffer)buffer).getStringBuffer().append('\ufffd');
                    i2 = length;
                    continue;
                }
                if (buffer == null) continue;
                ((Utf8StringBuffer)buffer).getStringBuffer().append(c2);
            }
            if (buffer == null) {
                if (offset == 0 && encoded.length() == length) {
                    return encoded;
                }
                return encoded.substring(offset, offset + length);
            }
            return buffer.toReplacedString();
        }
        StringBuffer buffer = null;
        for (int i3 = 0; i3 < length; ++i3) {
            char c3 = encoded.charAt(offset + i3);
            if (c3 < '\u0000' || c3 > '\u00ff') {
                if (buffer == null) {
                    buffer = new StringBuffer(length);
                    buffer.append(encoded, offset, offset + i3 + 1);
                    continue;
                }
                buffer.append(c3);
                continue;
            }
            if (c3 == '+') {
                if (buffer == null) {
                    buffer = new StringBuffer(length);
                    buffer.append(encoded, offset, offset + i3);
                }
                buffer.append(' ');
                continue;
            }
            if (c3 == '%') {
                if (buffer == null) {
                    buffer = new StringBuffer(length);
                    buffer.append(encoded, offset, offset + i3);
                }
                byte[] ba = new byte[length];
                int n2 = 0;
                while (c3 >= '\u0000' && c3 <= '\u00ff') {
                    block37: {
                        if (c3 == '%') {
                            if (i3 + 2 < length) {
                                try {
                                    if ('u' == encoded.charAt(offset + i3 + 1)) {
                                        if (i3 + 6 < length) {
                                            int o4 = offset + i3 + 2;
                                            i3 += 6;
                                            String unicode = new String(Character.toChars(TypeUtil.parseInt(encoded, o4, 4, 16)));
                                            byte[] reencoded = unicode.getBytes(charset);
                                            System.arraycopy(reencoded, 0, ba, n2, reencoded.length);
                                            n2 += reencoded.length;
                                        } else {
                                            ba[n2++] = 63;
                                            i3 = length;
                                        }
                                        break block37;
                                    }
                                    int o5 = offset + i3 + 1;
                                    i3 += 3;
                                    ba[n2] = (byte)TypeUtil.parseInt(encoded, o5, 2, 16);
                                    ++n2;
                                }
                                catch (NumberFormatException nfe) {
                                    LOG.ignore(nfe);
                                    ba[n2++] = 63;
                                }
                            } else {
                                ba[n2++] = 63;
                                i3 = length;
                            }
                        } else if (c3 == '+') {
                            ba[n2++] = 32;
                            ++i3;
                        } else {
                            ba[n2++] = (byte)c3;
                            ++i3;
                        }
                    }
                    if (i3 >= length) break;
                    c3 = encoded.charAt(offset + i3);
                }
                --i3;
                buffer.append(new String(ba, 0, n2, charset));
                continue;
            }
            if (buffer == null) continue;
            buffer.append(c3);
        }
        if (buffer == null) {
            if (offset == 0 && encoded.length() == length) {
                return encoded;
            }
            return encoded.substring(offset, offset + length);
        }
        return buffer.toString();
    }

    public static String encodeString(String string) {
        return UrlEncoded.encodeString(string, ENCODING);
    }

    public static String encodeString(String string, Charset charset) {
        if (charset == null) {
            charset = ENCODING;
        }
        byte[] bytes = null;
        bytes = string.getBytes(charset);
        int len = bytes.length;
        byte[] encoded = new byte[bytes.length * 3];
        int n2 = 0;
        boolean noEncode = true;
        for (int i2 = 0; i2 < len; ++i2) {
            byte b2 = bytes[i2];
            if (b2 == 32) {
                noEncode = false;
                encoded[n2++] = 43;
                continue;
            }
            if (b2 >= 97 && b2 <= 122 || b2 >= 65 && b2 <= 90 || b2 >= 48 && b2 <= 57) {
                encoded[n2++] = b2;
                continue;
            }
            noEncode = false;
            encoded[n2++] = 37;
            byte nibble = (byte)((b2 & 0xF0) >> 4);
            encoded[n2++] = nibble >= 10 ? (byte)(65 + nibble - 10) : (byte)(48 + nibble);
            nibble = (byte)(b2 & 0xF);
            encoded[n2++] = nibble >= 10 ? (byte)(65 + nibble - 10) : (byte)(48 + nibble);
        }
        if (noEncode) {
            return string;
        }
        return new String(encoded, 0, n2, charset);
    }

    @Override
    public Object clone() {
        return new UrlEncoded(this);
    }

    static {
        Charset encoding = null;
        try {
            encoding = Charset.forName(System.getProperty("org.eclipse.jetty.util.UrlEncoding.charset", "UTF-8"));
        }
        catch (Exception e2) {
            LOG.warn(e2);
            encoding = StringUtil.__UTF8_CHARSET;
        }
        ENCODING = encoding;
    }
}

