/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.nio.charset.Charset;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.TypeUtil;

public class URIUtil
implements Cloneable {
    public static final String SLASH = "/";
    public static final String HTTP = "http";
    public static final String HTTP_COLON = "http:";
    public static final String HTTPS = "https";
    public static final String HTTPS_COLON = "https:";
    public static final Charset __CHARSET = Charset.forName(System.getProperty("org.eclipse.jetty.util.URI.charset", "UTF-8"));

    private URIUtil() {
    }

    public static String encodePath(String path) {
        if (path == null || path.length() == 0) {
            return path;
        }
        StringBuilder buf = URIUtil.encodePath(null, path);
        return buf == null ? path : buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringBuilder encodePath(StringBuilder buf, String path) {
        byte[] bytes = null;
        if (buf == null) {
            block28: for (int i2 = 0; i2 < path.length(); ++i2) {
                char c2 = path.charAt(i2);
                switch (c2) {
                    case ' ': 
                    case '\"': 
                    case '#': 
                    case '%': 
                    case '\'': 
                    case ';': 
                    case '<': 
                    case '>': 
                    case '?': {
                        buf = new StringBuilder(path.length() * 2);
                        break block28;
                    }
                    default: {
                        if (c2 <= '\u007f') continue block28;
                        bytes = path.getBytes(__CHARSET);
                        buf = new StringBuilder(path.length() * 2);
                        break block28;
                    }
                }
            }
            if (buf == null) {
                return null;
            }
        }
        StringBuilder stringBuilder = buf;
        synchronized (stringBuilder) {
            int i3;
            if (bytes != null) {
                block29: for (i3 = 0; i3 < bytes.length; ++i3) {
                    void c3 = bytes[i3];
                    switch (c3) {
                        case 37: {
                            buf.append("%25");
                            continue block29;
                        }
                        case 63: {
                            buf.append("%3F");
                            continue block29;
                        }
                        case 59: {
                            buf.append("%3B");
                            continue block29;
                        }
                        case 35: {
                            buf.append("%23");
                            continue block29;
                        }
                        case 34: {
                            buf.append("%22");
                            continue block29;
                        }
                        case 39: {
                            buf.append("%27");
                            continue block29;
                        }
                        case 60: {
                            buf.append("%3C");
                            continue block29;
                        }
                        case 62: {
                            buf.append("%3E");
                            continue block29;
                        }
                        case 32: {
                            buf.append("%20");
                            continue block29;
                        }
                        default: {
                            if (c3 < 0) {
                                buf.append('%');
                                TypeUtil.toHex((byte)c3, (Appendable)buf);
                                continue block29;
                            }
                            buf.append((char)c3);
                            continue block29;
                        }
                    }
                }
            } else {
                block30: for (i3 = 0; i3 < path.length(); ++i3) {
                    char c4 = path.charAt(i3);
                    switch (c4) {
                        case '%': {
                            buf.append("%25");
                            continue block30;
                        }
                        case '?': {
                            buf.append("%3F");
                            continue block30;
                        }
                        case ';': {
                            buf.append("%3B");
                            continue block30;
                        }
                        case '#': {
                            buf.append("%23");
                            continue block30;
                        }
                        case '\"': {
                            buf.append("%22");
                            continue block30;
                        }
                        case '\'': {
                            buf.append("%27");
                            continue block30;
                        }
                        case '<': {
                            buf.append("%3C");
                            continue block30;
                        }
                        case '>': {
                            buf.append("%3E");
                            continue block30;
                        }
                        case ' ': {
                            buf.append("%20");
                            continue block30;
                        }
                        default: {
                            buf.append(c4);
                            continue block30;
                        }
                    }
                }
            }
        }
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringBuilder encodeString(StringBuilder buf, String path, String encode) {
        if (buf == null) {
            for (int i2 = 0; i2 < path.length(); ++i2) {
                char c2 = path.charAt(i2);
                if (c2 != '%' && encode.indexOf(c2) < 0) continue;
                buf = new StringBuilder(path.length() << 1);
                break;
            }
            if (buf == null) {
                return null;
            }
        }
        StringBuilder stringBuilder = buf;
        synchronized (stringBuilder) {
            for (int i3 = 0; i3 < path.length(); ++i3) {
                char c3 = path.charAt(i3);
                if (c3 == '%' || encode.indexOf(c3) >= 0) {
                    buf.append('%');
                    StringUtil.append(buf, (byte)(0xFF & c3), 16);
                    continue;
                }
                buf.append(c3);
            }
        }
        return buf;
    }

    public static String decodePath(String path) {
        if (path == null) {
            return null;
        }
        char[] chars = null;
        int n2 = 0;
        byte[] bytes = null;
        int b2 = 0;
        int len = path.length();
        for (int i2 = 0; i2 < len; ++i2) {
            char c2 = path.charAt(i2);
            if (c2 == '%' && i2 + 2 < len) {
                if (chars == null) {
                    chars = new char[len];
                    bytes = new byte[len];
                    path.getChars(0, i2, chars, 0);
                }
                bytes[b2++] = (byte)(0xFF & TypeUtil.parseInt(path, i2 + 1, 2, 16));
                i2 += 2;
                continue;
            }
            if (c2 == ';') {
                if (chars != null) break;
                chars = new char[len];
                path.getChars(0, i2, chars, 0);
                n2 = i2;
                break;
            }
            if (bytes == null) {
                ++n2;
                continue;
            }
            if (b2 > 0) {
                String s = new String(bytes, 0, b2, __CHARSET);
                s.getChars(0, s.length(), chars, n2);
                n2 += s.length();
                b2 = 0;
            }
            chars[n2++] = c2;
        }
        if (chars == null) {
            return path;
        }
        if (b2 > 0) {
            String s = new String(bytes, 0, b2, __CHARSET);
            s.getChars(0, s.length(), chars, n2);
            n2 += s.length();
        }
        return new String(chars, 0, n2);
    }

    public static String decodePath(byte[] buf, int offset, int length) {
        byte[] bytes = null;
        int n2 = 0;
        for (int i2 = 0; i2 < length; ++i2) {
            byte b2 = buf[i2 + offset];
            if (b2 == 37 && i2 + 2 < length) {
                b2 = (byte)(0xFF & TypeUtil.parseInt(buf, i2 + offset + 1, 2, 16));
                i2 += 2;
            } else {
                if (b2 == 59) {
                    length = i2;
                    break;
                }
                if (bytes == null) {
                    ++n2;
                    continue;
                }
            }
            if (bytes == null) {
                bytes = new byte[length];
                for (int j2 = 0; j2 < n2; ++j2) {
                    bytes[j2] = buf[j2 + offset];
                }
            }
            bytes[n2++] = b2;
        }
        if (bytes == null) {
            return new String(buf, offset, length, __CHARSET);
        }
        return new String(bytes, 0, n2, __CHARSET);
    }

    public static String addPaths(String p1, String p2) {
        if (p1 == null || p1.length() == 0) {
            if (p1 != null && p2 == null) {
                return p1;
            }
            return p2;
        }
        if (p2 == null || p2.length() == 0) {
            return p1;
        }
        int split = p1.indexOf(59);
        if (split < 0) {
            split = p1.indexOf(63);
        }
        if (split == 0) {
            return p2 + p1;
        }
        if (split < 0) {
            split = p1.length();
        }
        StringBuilder buf = new StringBuilder(p1.length() + p2.length() + 2);
        buf.append(p1);
        if (buf.charAt(split - 1) == '/') {
            if (p2.startsWith(SLASH)) {
                buf.deleteCharAt(split - 1);
                buf.insert(split - 1, p2);
            } else {
                buf.insert(split, p2);
            }
        } else if (p2.startsWith(SLASH)) {
            buf.insert(split, p2);
        } else {
            buf.insert(split, '/');
            buf.insert(split + 1, p2);
        }
        return buf.toString();
    }

    public static String parentPath(String p) {
        if (p == null || SLASH.equals(p)) {
            return null;
        }
        int slash = p.lastIndexOf(47, p.length() - 2);
        if (slash >= 0) {
            return p.substring(0, slash + 1);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String canonicalPath(String path) {
        if (path == null || path.length() == 0) {
            return path;
        }
        int end = path.length();
        int start = path.lastIndexOf(47, end);
        block8: while (end > 0) {
            switch (end - start) {
                case 2: {
                    if (path.charAt(start + 1) == '.') break block8;
                    break;
                }
                case 3: {
                    if (path.charAt(start + 1) == '.' && path.charAt(start + 2) == '.') break block8;
                }
            }
            end = start;
            start = path.lastIndexOf(47, end - 1);
        }
        if (start >= end) {
            return path;
        }
        StringBuilder buf = new StringBuilder(path);
        int delStart = -1;
        int delEnd = -1;
        int skip = 0;
        block9: while (end > 0) {
            switch (end - start) {
                case 2: {
                    if (buf.charAt(start + 1) != '.') {
                        if (skip <= 0 || --skip != 0) break;
                        int n2 = delStart = start >= 0 ? start : 0;
                        if (delStart <= 0 || delEnd != buf.length() || buf.charAt(delEnd - 1) != '.') break;
                        ++delStart;
                        break;
                    }
                    if (start < 0 && buf.length() > 2 && buf.charAt(1) == '/' && buf.charAt(2) == '/') break;
                    if (delEnd < 0) {
                        delEnd = end;
                    }
                    if ((delStart = start) < 0 || delStart == 0 && buf.charAt(delStart) == '/') {
                        ++delStart;
                        if (delEnd >= buf.length() || buf.charAt(delEnd) != '/') break;
                        ++delEnd;
                        break;
                    }
                    if (end == buf.length()) {
                        ++delStart;
                    }
                    end = start--;
                    while (start >= 0 && buf.charAt(start) != '/') {
                        --start;
                    }
                    continue block9;
                }
                case 3: {
                    if (buf.charAt(start + 1) != '.' || buf.charAt(start + 2) != '.') {
                        if (skip <= 0 || --skip != 0) break;
                        int n3 = delStart = start >= 0 ? start : 0;
                        if (delStart <= 0 || delEnd != buf.length() || buf.charAt(delEnd - 1) != '.') break;
                        ++delStart;
                        break;
                    }
                    delStart = start;
                    if (delEnd < 0) {
                        delEnd = end;
                    }
                    ++skip;
                    end = start--;
                    while (start >= 0 && buf.charAt(start) != '/') {
                        --start;
                    }
                    continue block9;
                }
                default: {
                    if (skip <= 0 || --skip != 0) break;
                    int n4 = delStart = start >= 0 ? start : 0;
                    if (delEnd != buf.length() || buf.charAt(delEnd - 1) != '.') break;
                    ++delStart;
                }
            }
            if (skip <= 0 && delStart >= 0 && delEnd >= delStart) {
                buf.delete(delStart, delEnd);
                delEnd = -1;
                delStart = -1;
                if (skip > 0) {
                    delEnd = end;
                }
            }
            end = start--;
            while (start >= 0 && buf.charAt(start) != '/') {
                --start;
            }
        }
        if (skip > 0) {
            return null;
        }
        if (delEnd >= 0) {
            buf.delete(delStart, delEnd);
        }
        return buf.toString();
    }

    public static String compactPath(String path) {
        int i2;
        if (path == null || path.length() == 0) {
            return path;
        }
        int state = 0;
        int end = path.length();
        block8: for (i2 = 0; i2 < end; ++i2) {
            char c2 = path.charAt(i2);
            switch (c2) {
                case '?': {
                    return path;
                }
                case '/': {
                    if (++state != 2) continue block8;
                    break block8;
                }
                default: {
                    state = 0;
                }
            }
        }
        if (state < 2) {
            return path;
        }
        StringBuffer buf = new StringBuffer(path.length());
        buf.append(path, 0, i2);
        block9: while (i2 < end) {
            char c3 = path.charAt(i2);
            switch (c3) {
                case '?': {
                    buf.append(path, i2, end);
                    break block9;
                }
                case '/': {
                    if (state++ != 0) break;
                    buf.append(c3);
                    break;
                }
                default: {
                    state = 0;
                    buf.append(c3);
                }
            }
            ++i2;
        }
        return buf.toString();
    }

    public static boolean hasScheme(String uri) {
        for (int i2 = 0; i2 < uri.length(); ++i2) {
            char c2 = uri.charAt(i2);
            if (c2 == ':') {
                return true;
            }
            if (!(c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' || i2 > 0 && (c2 >= '0' && c2 <= '9' || c2 == '.' || c2 == '+' || c2 == '-'))) break;
        }
        return false;
    }

    public static void appendSchemeHostPort(StringBuilder url, String scheme, String server, int port) {
        if (server.indexOf(58) >= 0 && server.charAt(0) != '[') {
            url.append(scheme).append("://").append('[').append(server).append(']');
        } else {
            url.append(scheme).append("://").append(server);
        }
        if (port > 0 && (HTTP.equalsIgnoreCase(scheme) && port != 80 || HTTPS.equalsIgnoreCase(scheme) && port != 443)) {
            url.append(':').append(port);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void appendSchemeHostPort(StringBuffer url, String scheme, String server, int port) {
        StringBuffer stringBuffer = url;
        synchronized (stringBuffer) {
            if (server.indexOf(58) >= 0 && server.charAt(0) != '[') {
                url.append(scheme).append("://").append('[').append(server).append(']');
            } else {
                url.append(scheme).append("://").append(server);
            }
            if (port > 0 && (HTTP.equalsIgnoreCase(scheme) && port != 80 || HTTPS.equalsIgnoreCase(scheme) && port != 443)) {
                url.append(':').append(port);
            }
        }
    }
}

