/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import org.eclipse.jetty.util.ArrayTrie;
import org.eclipse.jetty.util.QuotedStringTokenizer;
import org.eclipse.jetty.util.Trie;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class StringUtil {
    private static final Logger LOG = Log.getLogger(StringUtil.class);
    private static final Trie<String> CHARSETS = new ArrayTrie<String>(256);
    public static final String ALL_INTERFACES = "0.0.0.0";
    public static final String CRLF = "\r\n";
    public static final String __LINE_SEPARATOR = System.getProperty("line.separator", "\n");
    public static final String __ISO_8859_1 = "ISO-8859-1";
    public static final String __UTF8 = "UTF-8";
    public static final String __UTF16 = "UTF-16";
    public static final Charset __UTF8_CHARSET = Charset.forName("UTF-8");
    public static final Charset __ISO_8859_1_CHARSET = Charset.forName("ISO-8859-1");
    public static final Charset __UTF16_CHARSET = Charset.forName("UTF-16");
    public static char[] lowercases;

    public static String normalizeCharset(String s) {
        String n2 = CHARSETS.get(s);
        return n2 == null ? s : n2;
    }

    public static String normalizeCharset(String s, int offset, int length) {
        String n2 = CHARSETS.get(s, offset, length);
        return n2 == null ? s.substring(offset, offset + length) : n2;
    }

    public static String asciiToLowerCase(String s) {
        char[] c2 = null;
        int i2 = s.length();
        while (i2-- > 0) {
            char c22;
            char c1 = s.charAt(i2);
            if (c1 > '\u007f' || c1 == (c22 = lowercases[c1])) continue;
            c2 = s.toCharArray();
            c2[i2] = c22;
            break;
        }
        while (i2-- > 0) {
            if (c2[i2] > 127) continue;
            c2[i2] = lowercases[c2[i2]];
        }
        return c2 == null ? s : new String(c2);
    }

    public static boolean startsWithIgnoreCase(String s, String w) {
        if (w == null) {
            return true;
        }
        if (s == null || s.length() < w.length()) {
            return false;
        }
        for (int i2 = 0; i2 < w.length(); ++i2) {
            char c2;
            char c1 = s.charAt(i2);
            if (c1 == (c2 = w.charAt(i2))) continue;
            if (c1 <= '\u007f') {
                c1 = lowercases[c1];
            }
            if (c2 <= '\u007f') {
                c2 = lowercases[c2];
            }
            if (c1 == c2) continue;
            return false;
        }
        return true;
    }

    public static boolean endsWithIgnoreCase(String s, String w) {
        int wl;
        if (w == null) {
            return true;
        }
        if (s == null) {
            return false;
        }
        int sl = s.length();
        if (sl < (wl = w.length())) {
            return false;
        }
        int i2 = wl;
        while (i2-- > 0) {
            char c2;
            char c1;
            if ((c1 = s.charAt(--sl)) == (c2 = w.charAt(i2))) continue;
            if (c1 <= '\u007f') {
                c1 = lowercases[c1];
            }
            if (c2 <= '\u007f') {
                c2 = lowercases[c2];
            }
            if (c1 == c2) continue;
            return false;
        }
        return true;
    }

    public static int indexFrom(String s, String chars) {
        for (int i2 = 0; i2 < s.length(); ++i2) {
            if (chars.indexOf(s.charAt(i2)) < 0) continue;
            return i2;
        }
        return -1;
    }

    public static String replace(String s, String sub, String with) {
        int c2 = 0;
        int i2 = s.indexOf(sub, c2);
        if (i2 == -1) {
            return s;
        }
        StringBuilder buf = new StringBuilder(s.length() + with.length());
        do {
            buf.append(s.substring(c2, i2));
            buf.append(with);
        } while ((i2 = s.indexOf(sub, c2 = i2 + sub.length())) != -1);
        if (c2 < s.length()) {
            buf.append(s.substring(c2, s.length()));
        }
        return buf.toString();
    }

    public static String unquote(String s) {
        return QuotedStringTokenizer.unquote(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void append(StringBuilder buf, String s, int offset, int length) {
        StringBuilder stringBuilder = buf;
        synchronized (stringBuilder) {
            int end = offset + length;
            for (int i2 = offset; i2 < end && i2 < s.length(); ++i2) {
                buf.append(s.charAt(i2));
            }
        }
    }

    public static void append(StringBuilder buf, byte b2, int base) {
        int bi = 0xFF & b2;
        int c2 = 48 + bi / base % base;
        if (c2 > 57) {
            c2 = 97 + (c2 - 48 - 10);
        }
        buf.append((char)c2);
        c2 = 48 + bi % base;
        if (c2 > 57) {
            c2 = 97 + (c2 - 48 - 10);
        }
        buf.append((char)c2);
    }

    public static void append2digits(StringBuffer buf, int i2) {
        if (i2 < 100) {
            buf.append((char)(i2 / 10 + 48));
            buf.append((char)(i2 % 10 + 48));
        }
    }

    public static void append2digits(StringBuilder buf, int i2) {
        if (i2 < 100) {
            buf.append((char)(i2 / 10 + 48));
            buf.append((char)(i2 % 10 + 48));
        }
    }

    public static String nonNull(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }

    public static boolean equals(String s, char[] buf, int offset, int length) {
        if (s.length() != length) {
            return false;
        }
        for (int i2 = 0; i2 < length; ++i2) {
            if (buf[offset + i2] == s.charAt(i2)) continue;
            return false;
        }
        return true;
    }

    public static String toUTF8String(byte[] b2, int offset, int length) {
        return new String(b2, offset, length, __UTF8_CHARSET);
    }

    public static String toString(byte[] b2, int offset, int length, String charset) {
        try {
            return new String(b2, offset, length, charset);
        }
        catch (UnsupportedEncodingException e2) {
            throw new IllegalArgumentException(e2);
        }
    }

    public static boolean isBlank(String str) {
        if (str == null) {
            return true;
        }
        int len = str.length();
        for (int i2 = 0; i2 < len; ++i2) {
            if (Character.isWhitespace(str.codePointAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(String str) {
        if (str == null) {
            return false;
        }
        int len = str.length();
        for (int i2 = 0; i2 < len; ++i2) {
            if (Character.isWhitespace(str.codePointAt(i2))) continue;
            return true;
        }
        return false;
    }

    public static boolean isUTF8(String charset) {
        return __UTF8.equalsIgnoreCase(charset) || __UTF8.equalsIgnoreCase(StringUtil.normalizeCharset(charset));
    }

    public static String printable(String name) {
        if (name == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder(name.length());
        for (int i2 = 0; i2 < name.length(); ++i2) {
            char c2 = name.charAt(i2);
            if (Character.isISOControl(c2)) continue;
            buf.append(c2);
        }
        return buf.toString();
    }

    public static String printable(byte[] b2) {
        StringBuilder buf = new StringBuilder();
        for (int i2 = 0; i2 < b2.length; ++i2) {
            char c2 = (char)b2[i2];
            if (Character.isWhitespace(c2) || c2 > ' ' && c2 < '\u007f') {
                buf.append(c2);
                continue;
            }
            buf.append("0x");
            TypeUtil.toHex(b2[i2], (Appendable)buf);
        }
        return buf.toString();
    }

    public static byte[] getBytes(String s) {
        return s.getBytes(__ISO_8859_1_CHARSET);
    }

    public static byte[] getUtf8Bytes(String s) {
        return s.getBytes(__UTF8_CHARSET);
    }

    public static byte[] getBytes(String s, String charset) {
        try {
            return s.getBytes(charset);
        }
        catch (Exception e2) {
            LOG.warn(e2);
            return s.getBytes();
        }
    }

    public static String sidBytesToString(byte[] sidBytes) {
        StringBuilder sidString = new StringBuilder();
        sidString.append("S-");
        sidString.append(Byte.toString(sidBytes[0])).append('-');
        StringBuilder tmpBuilder = new StringBuilder();
        for (int i2 = 2; i2 <= 7; ++i2) {
            tmpBuilder.append(Integer.toHexString(sidBytes[i2] & 0xFF));
        }
        sidString.append(Long.parseLong(tmpBuilder.toString(), 16));
        int subAuthorityCount = sidBytes[1];
        for (int i3 = 0; i3 < subAuthorityCount; ++i3) {
            int offset = i3 * 4;
            tmpBuilder.setLength(0);
            tmpBuilder.append(String.format("%02X%02X%02X%02X", sidBytes[11 + offset] & 0xFF, sidBytes[10 + offset] & 0xFF, sidBytes[9 + offset] & 0xFF, sidBytes[8 + offset] & 0xFF));
            sidString.append('-').append(Long.parseLong(tmpBuilder.toString(), 16));
        }
        return sidString.toString();
    }

    public static byte[] sidStringToBytes(String sidString) {
        int i2;
        String[] sidTokens = sidString.split("-");
        int subAuthorityCount = sidTokens.length - 3;
        int byteCount = 0;
        byte[] sidBytes = new byte[8 + 4 * subAuthorityCount];
        sidBytes[byteCount++] = (byte)Integer.parseInt(sidTokens[1]);
        sidBytes[byteCount++] = (byte)subAuthorityCount;
        String hexStr = Long.toHexString(Long.parseLong(sidTokens[2]));
        while (hexStr.length() < 12) {
            hexStr = "0" + hexStr;
        }
        for (i2 = 0; i2 < hexStr.length(); i2 += 2) {
            sidBytes[byteCount++] = (byte)Integer.parseInt(hexStr.substring(i2, i2 + 2), 16);
        }
        for (i2 = 3; i2 < sidTokens.length; ++i2) {
            hexStr = Long.toHexString(Long.parseLong(sidTokens[i2]));
            while (hexStr.length() < 8) {
                hexStr = "0" + hexStr;
            }
            for (int j2 = hexStr.length(); j2 > 0; j2 -= 2) {
                sidBytes[byteCount++] = (byte)Integer.parseInt(hexStr.substring(j2 - 2, j2), 16);
            }
        }
        return sidBytes;
    }

    public static int toInt(String string) {
        int val = 0;
        boolean started = false;
        boolean minus = false;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char b2 = string.charAt(i2);
            if (b2 <= ' ') {
                if (!started) continue;
                break;
            }
            if (b2 >= '0' && b2 <= '9') {
                val = val * 10 + (b2 - 48);
                started = true;
                continue;
            }
            if (b2 != '-' || started) break;
            minus = true;
        }
        if (started) {
            return minus ? -val : val;
        }
        throw new NumberFormatException(string);
    }

    public static long toLong(String string) {
        long val = 0L;
        boolean started = false;
        boolean minus = false;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char b2 = string.charAt(i2);
            if (b2 <= ' ') {
                if (!started) continue;
                break;
            }
            if (b2 >= '0' && b2 <= '9') {
                val = val * 10L + (long)(b2 - 48);
                started = true;
                continue;
            }
            if (b2 != '-' || started) break;
            minus = true;
        }
        if (started) {
            return minus ? -val : val;
        }
        throw new NumberFormatException(string);
    }

    public static String truncate(String str, int maxSize) {
        if (str == null) {
            return null;
        }
        if (str.length() <= maxSize) {
            return str;
        }
        return str.substring(0, maxSize);
    }

    static {
        CHARSETS.put(__UTF8, __UTF8);
        CHARSETS.put("UTF8", __UTF8);
        CHARSETS.put(__UTF16, __UTF16);
        CHARSETS.put("UTF16", __UTF16);
        CHARSETS.put(__ISO_8859_1, __ISO_8859_1);
        CHARSETS.put("ISO_8859_1", __ISO_8859_1);
        lowercases = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '\u007f'};
    }
}

