/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.jetty.util.StringUtil;

public class ReadLineInputStream
extends BufferedInputStream {
    boolean _seenCRLF;
    boolean _skipLF;

    public ReadLineInputStream(InputStream in) {
        super(in);
    }

    public ReadLineInputStream(InputStream in, int size) {
        super(in, size);
    }

    public String readLine() throws IOException {
        this.mark(this.buf.length);
        while (true) {
            int b2;
            if ((b2 = super.read()) == -1) {
                int m2 = this.markpos;
                this.markpos = -1;
                if (this.pos > m2) {
                    return new String(this.buf, m2, this.pos - m2, StringUtil.__UTF8_CHARSET);
                }
                return null;
            }
            if (b2 == 13) {
                int p = this.pos;
                if (this._seenCRLF && this.pos < this.count) {
                    if (this.buf[this.pos] == 10) {
                        ++this.pos;
                    }
                } else {
                    this._skipLF = true;
                }
                int m3 = this.markpos;
                this.markpos = -1;
                return new String(this.buf, m3, p - m3 - 1, StringUtil.__UTF8_CHARSET);
            }
            if (b2 != 10) continue;
            if (!this._skipLF) break;
            this._skipLF = false;
            this._seenCRLF = true;
            ++this.markpos;
        }
        int m4 = this.markpos;
        this.markpos = -1;
        return new String(this.buf, m4, this.pos - m4 - 1, StringUtil.__UTF8_CHARSET);
    }

    @Override
    public synchronized int read() throws IOException {
        int b2 = super.read();
        if (this._skipLF) {
            this._skipLF = false;
            if (this._seenCRLF && b2 == 10) {
                b2 = super.read();
            }
        }
        return b2;
    }

    @Override
    public synchronized int read(byte[] buf, int off, int len) throws IOException {
        if (this._skipLF && len > 0) {
            this._skipLF = false;
            if (this._seenCRLF) {
                int b2 = super.read();
                if (b2 == -1) {
                    return -1;
                }
                if (b2 != 10) {
                    buf[off] = (byte)(0xFF & b2);
                    return 1 + super.read(buf, off + 1, len - 1);
                }
            }
        }
        return super.read(buf, off, len);
    }
}

