/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MultiMap<V>
extends HashMap<String, List<V>> {
    public MultiMap() {
    }

    public MultiMap(Map<String, List<V>> map) {
        super(map);
    }

    public MultiMap(MultiMap<V> map) {
        super(map);
    }

    public List<V> getValues(String name) {
        List vals = (List)super.get(name);
        if (vals == null || vals.isEmpty()) {
            return null;
        }
        return vals;
    }

    public V getValue(String name, int i2) {
        List<V> vals = this.getValues(name);
        if (vals == null) {
            return null;
        }
        if (i2 == 0 && vals.isEmpty()) {
            return null;
        }
        return vals.get(i2);
    }

    public String getString(String name) {
        List vals = (List)this.get(name);
        if (vals == null || vals.isEmpty()) {
            return null;
        }
        if (vals.size() == 1) {
            return vals.get(0).toString();
        }
        StringBuilder values = new StringBuilder(128);
        for (Object e2 : vals) {
            if (e2 == null) continue;
            if (values.length() > 0) {
                values.append(',');
            }
            values.append(e2.toString());
        }
        return values.toString();
    }

    @Override
    public List<V> put(String name, V value) {
        if (value == null) {
            return super.put(name, null);
        }
        ArrayList<V> vals = new ArrayList<V>();
        vals.add(value);
        return this.put(name, vals);
    }

    public void putAllValues(Map<String, V> input) {
        for (Map.Entry<String, V> entry : input.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public List<V> putValues(String name, List<V> values) {
        return super.put(name, values);
    }

    @SafeVarargs
    public final List<V> putValues(String name, V ... values) {
        ArrayList<V> list = new ArrayList<V>();
        list.addAll(Arrays.asList(values));
        return super.put(name, list);
    }

    public void add(String name, V value) {
        ArrayList<V> lo = (ArrayList<V>)this.get(name);
        if (lo == null) {
            lo = new ArrayList<V>();
        }
        lo.add(value);
        super.put(name, lo);
    }

    public void addValues(String name, List<V> values) {
        ArrayList<V> lo = (ArrayList<V>)this.get(name);
        if (lo == null) {
            lo = new ArrayList<V>();
        }
        lo.addAll(values);
        this.put(name, lo);
    }

    public void addValues(String name, V[] values) {
        ArrayList<V> lo = (ArrayList<V>)this.get(name);
        if (lo == null) {
            lo = new ArrayList<V>();
        }
        lo.addAll(Arrays.asList(values));
        this.put(name, lo);
    }

    public boolean addAllValues(MultiMap<V> map) {
        boolean merged = false;
        if (map == null || map.isEmpty()) {
            return merged;
        }
        for (Map.Entry entry : map.entrySet()) {
            String name = (String)entry.getKey();
            List values = (List)entry.getValue();
            if (this.containsKey(name)) {
                merged = true;
            }
            this.addValues(name, values);
        }
        return merged;
    }

    public boolean removeValue(String name, V value) {
        List lo = (List)this.get(name);
        if (lo == null || lo.isEmpty()) {
            return false;
        }
        boolean ret = lo.remove(value);
        if (lo.isEmpty()) {
            this.remove(name);
        } else {
            this.put(name, lo);
        }
        return ret;
    }

    public boolean containsSimpleValue(V value) {
        for (List vals : this.values()) {
            if (vals.size() != 1 || !vals.contains(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        Iterator iter = this.entrySet().iterator();
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        boolean delim = false;
        while (iter.hasNext()) {
            Map.Entry e2 = iter.next();
            if (delim) {
                sb.append(", ");
            }
            String key = (String)e2.getKey();
            List vals = (List)e2.getValue();
            sb.append(key);
            sb.append('=');
            if (vals.size() == 1) {
                sb.append(vals.get(0));
            } else {
                sb.append(vals);
            }
            delim = true;
        }
        sb.append('}');
        return sb.toString();
    }

    public Map<String, String[]> toStringArrayMap() {
        HashMap<String, String[]> map = new HashMap<String, String[]>(this.size() * 3 / 2){

            @Override
            public String toString() {
                StringBuilder b2 = new StringBuilder();
                b2.append('{');
                for (String k2 : super.keySet()) {
                    if (b2.length() > 1) {
                        b2.append(',');
                    }
                    b2.append(k2);
                    b2.append('=');
                    b2.append(Arrays.asList((Object[])super.get(k2)));
                }
                b2.append('}');
                return b2.toString();
            }
        };
        for (Map.Entry entry : this.entrySet()) {
            String[] a2 = null;
            if (entry.getValue() != null) {
                a2 = new String[((List)entry.getValue()).size()];
                a2 = ((List)entry.getValue()).toArray(a2);
            }
            map.put((String)entry.getKey(), a2);
        }
        return map;
    }
}

