/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class LazyList
implements Cloneable,
Serializable {
    private static final String[] __EMTPY_STRING_ARRAY = new String[0];

    private LazyList() {
    }

    public static Object add(Object list, Object item) {
        if (list == null) {
            if (item instanceof List || item == null) {
                ArrayList<Object> l2 = new ArrayList<Object>();
                l2.add(item);
                return l2;
            }
            return item;
        }
        if (list instanceof List) {
            ((List)list).add(item);
            return list;
        }
        ArrayList<Object> l3 = new ArrayList<Object>();
        l3.add(list);
        l3.add(item);
        return l3;
    }

    public static Object add(Object list, int index, Object item) {
        if (list == null) {
            if (index > 0 || item instanceof List || item == null) {
                ArrayList<Object> l2 = new ArrayList<Object>();
                l2.add(index, item);
                return l2;
            }
            return item;
        }
        if (list instanceof List) {
            ((List)list).add(index, item);
            return list;
        }
        ArrayList<Object> l3 = new ArrayList<Object>();
        l3.add(list);
        l3.add(index, item);
        return l3;
    }

    public static Object addCollection(Object list, Collection<?> collection) {
        Iterator<?> i2 = collection.iterator();
        while (i2.hasNext()) {
            list = LazyList.add(list, i2.next());
        }
        return list;
    }

    public static Object addArray(Object list, Object[] array) {
        for (int i2 = 0; array != null && i2 < array.length; ++i2) {
            list = LazyList.add(list, array[i2]);
        }
        return list;
    }

    public static Object ensureSize(Object list, int initialSize) {
        if (list == null) {
            return new ArrayList(initialSize);
        }
        if (list instanceof ArrayList) {
            ArrayList ol = (ArrayList)list;
            if (ol.size() > initialSize) {
                return ol;
            }
            ArrayList nl = new ArrayList(initialSize);
            nl.addAll(ol);
            return nl;
        }
        ArrayList<Object> l2 = new ArrayList<Object>(initialSize);
        l2.add(list);
        return l2;
    }

    public static Object remove(Object list, Object o2) {
        if (list == null) {
            return null;
        }
        if (list instanceof List) {
            List l2 = (List)list;
            l2.remove(o2);
            if (l2.size() == 0) {
                return null;
            }
            return list;
        }
        if (list.equals(o2)) {
            return null;
        }
        return list;
    }

    public static Object remove(Object list, int i2) {
        if (list == null) {
            return null;
        }
        if (list instanceof List) {
            List l2 = (List)list;
            l2.remove(i2);
            if (l2.size() == 0) {
                return null;
            }
            return list;
        }
        if (i2 == 0) {
            return null;
        }
        return list;
    }

    public static <E> List<E> getList(Object list) {
        return LazyList.getList(list, false);
    }

    public static <E> List<E> getList(Object list, boolean nullForEmpty) {
        if (list == null) {
            if (nullForEmpty) {
                return null;
            }
            return Collections.emptyList();
        }
        if (list instanceof List) {
            return (List)list;
        }
        return Collections.singletonList(list);
    }

    public static String[] toStringArray(Object list) {
        if (list == null) {
            return __EMTPY_STRING_ARRAY;
        }
        if (list instanceof List) {
            List l2 = (List)list;
            String[] a2 = new String[l2.size()];
            int i2 = l2.size();
            while (i2-- > 0) {
                Object o2 = l2.get(i2);
                if (o2 == null) continue;
                a2[i2] = o2.toString();
            }
            return a2;
        }
        return new String[]{list.toString()};
    }

    public static Object toArray(Object list, Class<?> clazz) {
        if (list == null) {
            return Array.newInstance(clazz, 0);
        }
        if (list instanceof List) {
            List l2 = (List)list;
            if (clazz.isPrimitive()) {
                Object a2 = Array.newInstance(clazz, l2.size());
                for (int i2 = 0; i2 < l2.size(); ++i2) {
                    Array.set(a2, i2, l2.get(i2));
                }
                return a2;
            }
            return l2.toArray((Object[])Array.newInstance(clazz, l2.size()));
        }
        Object a3 = Array.newInstance(clazz, 1);
        Array.set(a3, 0, list);
        return a3;
    }

    public static int size(Object list) {
        if (list == null) {
            return 0;
        }
        if (list instanceof List) {
            return ((List)list).size();
        }
        return 1;
    }

    public static <E> E get(Object list, int i2) {
        if (list == null) {
            throw new IndexOutOfBoundsException();
        }
        if (list instanceof List) {
            return ((List)list).get(i2);
        }
        if (i2 == 0) {
            return (E)list;
        }
        throw new IndexOutOfBoundsException();
    }

    public static boolean contains(Object list, Object item) {
        if (list == null) {
            return false;
        }
        if (list instanceof List) {
            return ((List)list).contains(item);
        }
        return list.equals(item);
    }

    public static Object clone(Object list) {
        if (list == null) {
            return null;
        }
        if (list instanceof List) {
            return new ArrayList((List)list);
        }
        return list;
    }

    public static String toString(Object list) {
        if (list == null) {
            return "[]";
        }
        if (list instanceof List) {
            return list.toString();
        }
        return "[" + list + "]";
    }

    public static <E> Iterator<E> iterator(Object list) {
        if (list == null) {
            List empty = Collections.emptyList();
            return empty.iterator();
        }
        if (list instanceof List) {
            return ((List)list).iterator();
        }
        List<E> l2 = LazyList.getList(list);
        return l2.iterator();
    }

    public static <E> ListIterator<E> listIterator(Object list) {
        if (list == null) {
            List empty = Collections.emptyList();
            return empty.listIterator();
        }
        if (list instanceof List) {
            return ((List)list).listIterator();
        }
        List<E> l2 = LazyList.getList(list);
        return l2.listIterator();
    }
}

