/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.nio.ByteBuffer;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.jetty.util.BufferUtil;

public class DateCache {
    public static String DEFAULT_FORMAT = "EEE MMM dd HH:mm:ss zzz yyyy";
    private String _formatString;
    private String _tzFormatString;
    private SimpleDateFormat _tzFormat;
    private volatile Tick _tick;
    private Locale _locale = null;
    private DateFormatSymbols _dfs = null;
    private static Timer __timer;
    private volatile ByteBuffer _buffer;
    private volatile Object _last;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Timer getTimer() {
        Class<DateCache> clazz = DateCache.class;
        synchronized (DateCache.class) {
            if (__timer == null) {
                __timer = new Timer("DateCache", true);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return __timer;
        }
    }

    public DateCache() {
        this(DEFAULT_FORMAT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DateCache(String format) {
        this._formatString = format;
        this.setTimeZone(TimeZone.getDefault());
        Class<DateCache> clazz = DateCache.class;
        synchronized (DateCache.class) {
            long now = System.currentTimeMillis();
            long tick = 1000L * (now / 1000L + 1L) - now;
            this.formatNow();
            DateCache.getTimer().scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    DateCache.this.formatNow();
                }
            }, tick, 1000L);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public DateCache(String format, Locale l2) {
        this(format);
        this._locale = l2;
        this.setTimeZone(TimeZone.getDefault());
    }

    public DateCache(String format, DateFormatSymbols s) {
        this(format);
        this._dfs = s;
        this.setTimeZone(TimeZone.getDefault());
    }

    public void setTimeZone(TimeZone tz) {
        this.setTzFormatString(tz);
        this._tzFormat = this._locale != null ? new SimpleDateFormat(this._tzFormatString, this._locale) : (this._dfs != null ? new SimpleDateFormat(this._tzFormatString, this._dfs) : new SimpleDateFormat(this._tzFormatString));
        this._tzFormat.setTimeZone(tz);
        this._tick = null;
    }

    public TimeZone getTimeZone() {
        return this._tzFormat.getTimeZone();
    }

    public void setTimeZoneID(String timeZoneId) {
        this.setTimeZone(TimeZone.getTimeZone(timeZoneId));
    }

    private void setTzFormatString(TimeZone tz) {
        int zIndex = this._formatString.indexOf("ZZZ");
        if (zIndex >= 0) {
            String ss1 = this._formatString.substring(0, zIndex);
            String ss2 = this._formatString.substring(zIndex + 3);
            int tzOffset = tz.getRawOffset();
            StringBuilder sb = new StringBuilder(this._formatString.length() + 10);
            sb.append(ss1);
            sb.append("'");
            if (tzOffset >= 0) {
                sb.append('+');
            } else {
                tzOffset = -tzOffset;
                sb.append('-');
            }
            int raw = tzOffset / 60000;
            int hr = raw / 60;
            int min = raw % 60;
            if (hr < 10) {
                sb.append('0');
            }
            sb.append(hr);
            if (min < 10) {
                sb.append('0');
            }
            sb.append(min);
            sb.append('\'');
            sb.append(ss2);
            this._tzFormatString = sb.toString();
        } else {
            this._tzFormatString = this._formatString;
        }
        this._tick = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String format(Date inDate) {
        long seconds = inDate.getTime() / 1000L;
        Tick tick = this._tick;
        if (tick == null || seconds != tick._seconds) {
            DateCache dateCache = this;
            synchronized (dateCache) {
                return this._tzFormat.format(inDate);
            }
        }
        return tick._string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String format(long inDate) {
        long seconds = inDate / 1000L;
        Tick tick = this._tick;
        if (tick == null || seconds != tick._seconds) {
            Date d2 = new Date(inDate);
            DateCache dateCache = this;
            synchronized (dateCache) {
                return this._tzFormat.format(d2);
            }
        }
        return tick._string;
    }

    public String now() {
        return this._tick._string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void formatNow() {
        long now = System.currentTimeMillis();
        long seconds = now / 1000L;
        DateCache dateCache = this;
        synchronized (dateCache) {
            String s = this._tzFormat.format(new Date(now));
            this._tick = new Tick(seconds, s);
        }
    }

    public void format(long inDate, StringBuilder buffer) {
        buffer.append(this.format(inDate));
    }

    public String getFormatString() {
        return this._formatString;
    }

    public synchronized ByteBuffer formatBuffer(long date) {
        String d2 = this.format(date);
        if (d2 == this._last) {
            return this._buffer;
        }
        this._last = d2;
        this._buffer = BufferUtil.toBuffer(d2);
        return this._buffer;
    }

    private static class Tick {
        final long _seconds;
        final String _string;

        public Tick(long seconds, String string) {
            this._seconds = seconds;
            this._string = string;
        }
    }
}

