/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jetty.util.AbstractTrie;

public class ArrayTrie<V>
extends AbstractTrie<V> {
    private static final int ROW_SIZE = 32;
    private static final int[] __lookup = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 30, 31, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 26, -1, 27, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 28, 29, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1};
    private final char[] _rowIndex;
    private final String[] _key;
    private final Object[] _value;
    private char[][] _bigIndex;
    private char _rows;

    public ArrayTrie() {
        this(128);
    }

    public ArrayTrie(int capacityInNodes) {
        super(true);
        this._value = new Object[capacityInNodes];
        this._rowIndex = new char[capacityInNodes * 32];
        this._key = new String[capacityInNodes];
    }

    @Override
    public boolean put(String s, V v) {
        int t = 0;
        int limit = s.length();
        for (int k2 = 0; k2 < limit; ++k2) {
            char c2 = s.charAt(k2);
            int index = __lookup[c2 & 0x7F];
            if (index >= 0) {
                int idx = t * 32 + index;
                if ((t = this._rowIndex[idx]) != 0) continue;
                this._rows = (char)(this._rows + '\u0001');
                if (this._rows >= this._value.length) {
                    return false;
                }
                this._rowIndex[idx] = this._rows;
                t = this._rowIndex[idx];
                continue;
            }
            if (c2 > '\u007f') {
                throw new IllegalArgumentException("non ascii character");
            }
            if (this._bigIndex == null) {
                this._bigIndex = new char[this._value.length][];
            }
            if (t >= this._bigIndex.length) {
                return false;
            }
            char[] big = this._bigIndex[t];
            if (big == null) {
                this._bigIndex[t] = new char[128];
                big = this._bigIndex[t];
            }
            if ((t = big[c2]) != 0) continue;
            if (this._rows == this._value.length) {
                return false;
            }
            big[c2] = this._rows = (char)(this._rows + '\u0001');
            t = this._rows;
        }
        this._key[t] = v == null ? null : s;
        Object old = this._value[t];
        this._value[t] = v;
        return true;
    }

    @Override
    public V get(String s, int offset, int len) {
        int t = 0;
        for (int i2 = 0; i2 < len; ++i2) {
            char[] big;
            char c2 = s.charAt(offset + i2);
            int index = __lookup[c2 & 0x7F];
            if (index >= 0) {
                int idx = t * 32 + index;
                if ((t = this._rowIndex[idx]) != 0) continue;
                return null;
            }
            char[] cArray = big = this._bigIndex == null ? null : this._bigIndex[t];
            if (big == null) {
                return null;
            }
            t = big[c2];
            if (t != 0) continue;
            return null;
        }
        return (V)this._value[t];
    }

    @Override
    public V get(ByteBuffer b2, int offset, int len) {
        int t = 0;
        for (int i2 = 0; i2 < len; ++i2) {
            char[] big;
            byte c2 = b2.get(offset + i2);
            int index = __lookup[c2 & 0x7F];
            if (index >= 0) {
                int idx = t * 32 + index;
                if ((t = this._rowIndex[idx]) != 0) continue;
                return null;
            }
            char[] cArray = big = this._bigIndex == null ? null : this._bigIndex[t];
            if (big == null) {
                return null;
            }
            t = big[c2];
            if (t != 0) continue;
            return null;
        }
        return (V)this._value[t];
    }

    @Override
    public V getBest(byte[] b2, int offset, int len) {
        return this.getBest(0, b2, offset, len);
    }

    @Override
    public V getBest(ByteBuffer b2, int offset, int len) {
        if (b2.hasArray()) {
            return this.getBest(0, b2.array(), b2.arrayOffset() + b2.position() + offset, len);
        }
        return this.getBest(0, b2, offset, len);
    }

    @Override
    public V getBest(String s, int offset, int len) {
        return this.getBest(0, s, offset, len);
    }

    private V getBest(int t, String s, int offset, int len) {
        int pos = offset;
        for (int i2 = 0; i2 < len; ++i2) {
            char c2;
            int index;
            if ((index = __lookup[(c2 = s.charAt(pos++)) & 0x7F]) >= 0) {
                int idx = t * 32 + index;
                if ((t = this._rowIndex[idx]) == 0) {
                    return null;
                }
            } else {
                char[] big;
                char[] cArray = big = this._bigIndex == null ? null : this._bigIndex[t];
                if (big == null) {
                    return null;
                }
                t = big[c2];
                if (t == 0) {
                    return null;
                }
            }
            if (this._key[t] == null) continue;
            V best = this.getBest(t, s, offset + i2 + 1, len - i2 - 1);
            if (best != null) {
                return best;
            }
            return (V)this._value[t];
        }
        return (V)this._value[t];
    }

    private V getBest(int t, byte[] b2, int offset, int len) {
        for (int i2 = 0; i2 < len; ++i2) {
            byte c2 = b2[offset + i2];
            int index = __lookup[c2 & 0x7F];
            if (index >= 0) {
                int idx = t * 32 + index;
                if ((t = this._rowIndex[idx]) == 0) {
                    return null;
                }
            } else {
                char[] big;
                char[] cArray = big = this._bigIndex == null ? null : this._bigIndex[t];
                if (big == null) {
                    return null;
                }
                t = big[c2];
                if (t == 0) {
                    return null;
                }
            }
            if (this._key[t] == null) continue;
            V best = this.getBest(t, b2, offset + i2 + 1, len - i2 - 1);
            if (best != null) {
                return best;
            }
            return (V)this._value[t];
        }
        return (V)this._value[t];
    }

    private V getBest(int t, ByteBuffer b2, int offset, int len) {
        int pos = b2.position() + offset;
        for (int i2 = 0; i2 < len; ++i2) {
            byte c2;
            int index;
            if ((index = __lookup[(c2 = b2.get(pos++)) & 0x7F]) >= 0) {
                int idx = t * 32 + index;
                if ((t = this._rowIndex[idx]) == 0) {
                    return null;
                }
            } else {
                char[] big;
                char[] cArray = big = this._bigIndex == null ? null : this._bigIndex[t];
                if (big == null) {
                    return null;
                }
                t = big[c2];
                if (t == 0) {
                    return null;
                }
            }
            if (this._key[t] == null) continue;
            V best = this.getBest(t, b2, offset + i2 + 1, len - i2 - 1);
            if (best != null) {
                return best;
            }
            return (V)this._value[t];
        }
        return (V)this._value[t];
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        this.toString(buf, 0);
        if (buf.length() == 0) {
            return "{}";
        }
        buf.setCharAt(0, '{');
        buf.append('}');
        return buf.toString();
    }

    private <V> void toString(Appendable out, int t) {
        char[] big;
        if (this._value[t] != null) {
            try {
                out.append(',');
                out.append(this._key[t]);
                out.append('=');
                out.append(this._value[t].toString());
            }
            catch (IOException e2) {
                throw new RuntimeException(e2);
            }
        }
        for (int i2 = 0; i2 < 32; ++i2) {
            int idx = t * 32 + i2;
            if (this._rowIndex[idx] == '\u0000') continue;
            this.toString(out, this._rowIndex[idx]);
        }
        char[] cArray = big = this._bigIndex == null ? null : this._bigIndex[t];
        if (big != null) {
            for (char i3 : big) {
                if (i3 == '\u0000') continue;
                this.toString(out, i3);
            }
        }
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> keys = new HashSet<String>();
        this.keySet(keys, 0);
        return keys;
    }

    private void keySet(Set<String> set, int t) {
        char[] big;
        if (t < this._value.length && this._value[t] != null) {
            set.add(this._key[t]);
        }
        for (int i2 = 0; i2 < 32; ++i2) {
            int idx = t * 32 + i2;
            if (idx >= this._rowIndex.length || this._rowIndex[idx] == '\u0000') continue;
            this.keySet(set, this._rowIndex[idx]);
        }
        char[] cArray = big = this._bigIndex == null || t >= this._bigIndex.length ? null : this._bigIndex[t];
        if (big != null) {
            for (char i3 : big) {
                if (i3 == '\u0000') continue;
                this.keySet(set, i3);
            }
        }
    }

    @Override
    public boolean isFull() {
        return this._rows + '\u0001' == this._key.length;
    }
}

