/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jetty.util.AbstractTrie;
import org.eclipse.jetty.util.StringUtil;

public class ArrayTernaryTrie<V>
extends AbstractTrie<V> {
    private static int LO = 1;
    private static int EQ = 2;
    private static int HI = 3;
    private static final int ROW_SIZE = 4;
    private final char[] _tree;
    private final String[] _key;
    private final Object[] _value;
    private char _rows;

    public ArrayTernaryTrie() {
        this(128);
    }

    public ArrayTernaryTrie(boolean insensitive) {
        this(insensitive, 128);
    }

    public ArrayTernaryTrie(int capacityInNodes) {
        this(true, capacityInNodes);
    }

    public ArrayTernaryTrie(boolean insensitive, int capacityInNodes) {
        super(insensitive);
        this._value = new Object[capacityInNodes];
        this._tree = new char[capacityInNodes * 4];
        this._key = new String[capacityInNodes];
    }

    public ArrayTernaryTrie(ArrayTernaryTrie<V> trie, double factor) {
        this(trie.isCaseInsensitive(), (int)((double)trie._value.length * factor));
        this._rows = trie._rows;
        System.arraycopy(trie._value, 0, this._value, 0, trie._value.length);
        System.arraycopy(trie._tree, 0, this._tree, 0, trie._tree.length);
        System.arraycopy(trie._key, 0, this._key, 0, trie._key.length);
    }

    @Override
    public boolean put(String s, V v) {
        int last = EQ;
        int t = this._tree[last];
        int limit = s.length();
        int node = 0;
        for (int k2 = 0; k2 < limit; ++k2) {
            int row;
            char c2 = s.charAt(k2);
            if (this.isCaseInsensitive() && c2 < '\u0080') {
                c2 = StringUtil.lowercases[c2];
            }
            while (true) {
                char n2;
                int diff;
                if (t == 0) {
                    t = this._rows = (int)(this._rows + '\u0001');
                    node = this._rows;
                    if (this._rows >= this._key.length) {
                        this._rows = (char)(this._rows - '\u0001');
                        return false;
                    }
                    row = 4 * t;
                    this._tree[row] = c2;
                    this._tree[last] = (char)t;
                    last = row + EQ;
                }
                if ((diff = (n2 = this._tree[row = 4 * t]) - c2) == 0) break;
                if (diff < 0) {
                    last = row + LO;
                    t = this._tree[last];
                    continue;
                }
                last = row + HI;
                t = this._tree[last];
            }
            node = t;
            last = row + EQ;
            t = this._tree[last];
        }
        this._key[node] = v == null ? null : s;
        this._value[node] = v;
        return true;
    }

    @Override
    public V get(String s, int offset, int length) {
        char t = this._tree[EQ];
        int len = length;
        int i2 = 0;
        block0: while (i2 < len) {
            int diff;
            int row;
            char c2 = s.charAt(offset + i2++);
            if (this.isCaseInsensitive() && c2 < '\u0080') {
                c2 = StringUtil.lowercases[c2];
            }
            do {
                char n2;
                if ((diff = (n2 = this._tree[row = 4 * t]) - c2) != 0) continue;
                if (i2 == len) {
                    return (V)this._value[t];
                }
                t = this._tree[row + EQ];
                if (t != '\u0000') continue block0;
                return null;
            } while ((t = this._tree[row + (diff < 0 ? LO : HI)]) != '\u0000');
            return null;
        }
        return null;
    }

    @Override
    public V get(ByteBuffer b2, int offset, int length) {
        char t = this._tree[EQ];
        int len = length;
        int i2 = 0;
        offset += b2.position();
        block0: while (i2 < len) {
            int diff;
            int row;
            byte c2 = (byte)(b2.get(offset + i2++) & 0x7F);
            if (this.isCaseInsensitive()) {
                c2 = (byte)StringUtil.lowercases[c2];
            }
            do {
                char n2;
                if ((diff = (n2 = this._tree[row = 4 * t]) - c2) != 0) continue;
                if (i2 == len) {
                    return (V)this._value[t];
                }
                t = this._tree[row + EQ];
                if (t != '\u0000') continue block0;
                return null;
            } while ((t = this._tree[row + (diff < 0 ? LO : HI)]) != '\u0000');
            return null;
        }
        return null;
    }

    @Override
    public V getBest(String s) {
        return this.getBest((int)this._tree[EQ], s, 0, s.length());
    }

    @Override
    public V getBest(String s, int offset, int length) {
        return this.getBest((int)this._tree[EQ], s, offset, length);
    }

    private V getBest(int t, String s, int offset, int len) {
        int node = 0;
        block0: for (int i2 = 0; t != 0 && i2 < len; ++i2) {
            char c2 = s.charAt(offset + i2);
            if (this.isCaseInsensitive() && c2 < '\u0080') {
                c2 = StringUtil.lowercases[c2];
            }
            while (t != 0) {
                int row = 4 * t;
                char n2 = this._tree[row];
                int diff = n2 - c2;
                if (diff == 0) {
                    node = t;
                    t = this._tree[row + EQ];
                    if (this._key[node] == null) continue block0;
                    V best = this.getBest(t, s, offset + i2 + 1, len - i2 - 1);
                    if (best != null) {
                        return best;
                    }
                    return (V)this._value[node];
                }
                t = this._tree[row + (diff < 0 ? LO : HI)];
            }
        }
        return null;
    }

    @Override
    public V getBest(ByteBuffer b2, int offset, int len) {
        if (b2.hasArray()) {
            return this.getBest((int)this._tree[EQ], b2.array(), b2.arrayOffset() + b2.position() + offset, len);
        }
        return this.getBest((int)this._tree[EQ], b2, offset, len);
    }

    private V getBest(int t, byte[] b2, int offset, int len) {
        int node = 0;
        block0: for (int i2 = 0; t != 0 && i2 < len; ++i2) {
            byte c2 = (byte)(b2[offset + i2] & 0x7F);
            if (this.isCaseInsensitive()) {
                c2 = (byte)StringUtil.lowercases[c2];
            }
            while (t != 0) {
                int row = 4 * t;
                char n2 = this._tree[row];
                int diff = n2 - c2;
                if (diff == 0) {
                    node = t;
                    t = this._tree[row + EQ];
                    if (this._key[node] == null) continue block0;
                    V best = this.getBest(t, b2, offset + i2 + 1, len - i2 - 1);
                    if (best != null) {
                        return best;
                    }
                    return (V)this._value[node];
                }
                t = this._tree[row + (diff < 0 ? LO : HI)];
            }
        }
        return null;
    }

    private V getBest(int t, ByteBuffer b2, int offset, int len) {
        int node = 0;
        int o2 = offset + b2.position();
        block0: for (int i2 = 0; t != 0 && i2 < len; ++i2) {
            byte c2 = (byte)(b2.get(o2 + i2) & 0x7F);
            if (this.isCaseInsensitive()) {
                c2 = (byte)StringUtil.lowercases[c2];
            }
            while (t != 0) {
                int row = 4 * t;
                char n2 = this._tree[row];
                int diff = n2 - c2;
                if (diff == 0) {
                    node = t;
                    t = this._tree[row + EQ];
                    if (this._key[node] == null) continue block0;
                    V best = this.getBest(t, b2, offset + i2 + 1, len - i2 - 1);
                    if (best != null) {
                        return best;
                    }
                    return (V)this._value[node];
                }
                t = this._tree[row + (diff < 0 ? LO : HI)];
            }
        }
        return null;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (int r = 1; r <= this._rows; ++r) {
            if (this._key[r] == null || this._value[r] == null) continue;
            buf.append(',');
            buf.append(this._key[r]);
            buf.append('=');
            buf.append(this._value[r].toString());
        }
        if (buf.length() == 0) {
            return "{}";
        }
        buf.setCharAt(0, '{');
        buf.append('}');
        return buf.toString();
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> keys = new HashSet<String>();
        for (int r = 1; r <= this._rows; ++r) {
            if (this._key[r] == null || this._value[r] == null) continue;
            keys.add(this._key[r]);
        }
        return keys;
    }

    @Override
    public boolean isFull() {
        return this._rows + '\u0001' == this._key.length;
    }

    public void dump() {
        for (int r = 0; r <= this._rows; ++r) {
            char c2 = this._tree[r * 4 + 0];
            System.err.printf("%4d [%s,%d,%d,%d] %s:%s%n", r, c2 < ' ' || c2 > '\u007f' ? "" + c2 : "'" + c2 + "'", (int)this._tree[r * 4 + LO], (int)this._tree[r * 4 + EQ], (int)this._tree[r * 4 + HI], this._key[r], this._value[r]);
        }
    }
}

