/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.util.AbstractList;
import java.util.NoSuchElementException;
import java.util.Queue;

public class ArrayQueue<E>
extends AbstractList<E>
implements Queue<E> {
    public static final int DEFAULT_CAPACITY = 64;
    public static final int DEFAULT_GROWTH = 32;
    protected final Object _lock;
    protected final int _growCapacity;
    protected Object[] _elements;
    protected int _nextE;
    protected int _nextSlot;
    protected int _size;

    public ArrayQueue() {
        this(64, -1);
    }

    public ArrayQueue(int capacity) {
        this(capacity, -1);
    }

    public ArrayQueue(int initCapacity, int growBy) {
        this(initCapacity, growBy, null);
    }

    public ArrayQueue(int initCapacity, int growBy, Object lock) {
        this._lock = lock == null ? this : lock;
        this._growCapacity = growBy;
        this._elements = new Object[initCapacity];
    }

    public Object lock() {
        return this._lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCapacity() {
        Object object = this._lock;
        synchronized (object) {
            return this._elements.length;
        }
    }

    @Override
    public boolean add(E e2) {
        if (!this.offer(e2)) {
            throw new IllegalStateException("Full");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E e2) {
        Object object = this._lock;
        synchronized (object) {
            return this.enqueue(e2);
        }
    }

    private boolean enqueue(E e2) {
        if (this._size == this._elements.length && !this.grow()) {
            return false;
        }
        ++this._size;
        this._elements[this._nextSlot++] = e2;
        if (this._nextSlot == this._elements.length) {
            this._nextSlot = 0;
        }
        return true;
    }

    public void addUnsafe(E e2) {
        if (!this.enqueue(e2)) {
            throw new IllegalStateException("Full");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E element() {
        Object object = this._lock;
        synchronized (object) {
            if (this.isEmpty()) {
                throw new NoSuchElementException();
            }
            return this.at(this._nextE);
        }
    }

    private E at(int index) {
        return (E)this._elements[index];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E peek() {
        Object object = this._lock;
        synchronized (object) {
            if (this._size == 0) {
                return null;
            }
            return this.at(this._nextE);
        }
    }

    public E peekUnsafe() {
        if (this._size == 0) {
            return null;
        }
        return this.at(this._nextE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll() {
        Object object = this._lock;
        synchronized (object) {
            if (this._size == 0) {
                return null;
            }
            return this.dequeue();
        }
    }

    public E pollUnsafe() {
        if (this._size == 0) {
            return null;
        }
        return this.dequeue();
    }

    private E dequeue() {
        E e2 = this.at(this._nextE);
        this._elements[this._nextE] = null;
        --this._size;
        if (++this._nextE == this._elements.length) {
            this._nextE = 0;
        }
        return e2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E remove() {
        Object object = this._lock;
        synchronized (object) {
            if (this._size == 0) {
                throw new NoSuchElementException();
            }
            return this.dequeue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this._lock;
        synchronized (object) {
            this._size = 0;
            this._nextE = 0;
            this._nextSlot = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Object object = this._lock;
        synchronized (object) {
            return this._size == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Object object = this._lock;
        synchronized (object) {
            return this._size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E get(int index) {
        Object object = this._lock;
        synchronized (object) {
            if (index < 0 || index >= this._size) {
                throw new IndexOutOfBoundsException("!(0<" + index + "<=" + this._size + ")");
            }
            return this.getUnsafe(index);
        }
    }

    public E getUnsafe(int index) {
        int i2 = (this._nextE + index) % this._elements.length;
        return this.at(i2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E remove(int index) {
        Object object = this._lock;
        synchronized (object) {
            if (index < 0 || index >= this._size) {
                throw new IndexOutOfBoundsException("!(0<" + index + "<=" + this._size + ")");
            }
            int i2 = (this._nextE + index) % this._elements.length;
            E old = this.at(i2);
            if (i2 < this._nextSlot) {
                System.arraycopy(this._elements, i2 + 1, this._elements, i2, this._nextSlot - i2);
                --this._nextSlot;
                --this._size;
            } else {
                System.arraycopy(this._elements, i2 + 1, this._elements, i2, this._elements.length - i2 - 1);
                if (this._nextSlot > 0) {
                    this._elements[this._elements.length - 1] = this._elements[0];
                    System.arraycopy(this._elements, 1, this._elements, 0, this._nextSlot - 1);
                    --this._nextSlot;
                } else {
                    this._nextSlot = this._elements.length - 1;
                }
                --this._size;
            }
            return old;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E set(int index, E element) {
        Object object = this._lock;
        synchronized (object) {
            if (index < 0 || index >= this._size) {
                throw new IndexOutOfBoundsException("!(0<" + index + "<=" + this._size + ")");
            }
            int i2 = this._nextE + index;
            if (i2 >= this._elements.length) {
                i2 -= this._elements.length;
            }
            E old = this.at(i2);
            this._elements[i2] = element;
            return old;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(int index, E element) {
        Object object = this._lock;
        synchronized (object) {
            if (index < 0 || index > this._size) {
                throw new IndexOutOfBoundsException("!(0<" + index + "<=" + this._size + ")");
            }
            if (this._size == this._elements.length && !this.grow()) {
                throw new IllegalStateException("Full");
            }
            if (index == this._size) {
                this.add(element);
            } else {
                int i2 = this._nextE + index;
                if (i2 >= this._elements.length) {
                    i2 -= this._elements.length;
                }
                ++this._size;
                ++this._nextSlot;
                if (this._nextSlot == this._elements.length) {
                    this._nextSlot = 0;
                }
                if (i2 < this._nextSlot) {
                    System.arraycopy(this._elements, i2, this._elements, i2 + 1, this._nextSlot - i2);
                    this._elements[i2] = element;
                } else {
                    if (this._nextSlot > 0) {
                        System.arraycopy(this._elements, 0, this._elements, 1, this._nextSlot);
                        this._elements[0] = this._elements[this._elements.length - 1];
                    }
                    System.arraycopy(this._elements, i2, this._elements, i2 + 1, this._elements.length - i2 - 1);
                    this._elements[i2] = element;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean grow() {
        Object object = this._lock;
        synchronized (object) {
            if (this._growCapacity <= 0) {
                return false;
            }
            Object[] elements = new Object[this._elements.length + this._growCapacity];
            int split = this._elements.length - this._nextE;
            if (split > 0) {
                System.arraycopy(this._elements, this._nextE, elements, 0, split);
            }
            if (this._nextE != 0) {
                System.arraycopy(this._elements, 0, elements, split, this._nextSlot);
            }
            this._elements = elements;
            this._nextE = 0;
            this._nextSlot = this._size;
            return true;
        }
    }
}

