/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.nio.ByteBuffer;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.Trie;

public abstract class AbstractTrie<V>
implements Trie<V> {
    final boolean _caseInsensitive;

    protected AbstractTrie(boolean insensitive) {
        this._caseInsensitive = insensitive;
    }

    @Override
    public boolean put(V v) {
        return this.put(v.toString(), v);
    }

    @Override
    public V remove(String s) {
        V o2 = this.get(s);
        this.put(s, null);
        return o2;
    }

    @Override
    public V get(String s) {
        return this.get(s, 0, s.length());
    }

    @Override
    public V get(ByteBuffer b2) {
        return this.get(b2, 0, b2.remaining());
    }

    @Override
    public V getBest(String s) {
        return this.getBest(s, 0, s.length());
    }

    @Override
    public V getBest(byte[] b2, int offset, int len) {
        return this.getBest(new String(b2, offset, len, StringUtil.__ISO_8859_1_CHARSET));
    }

    @Override
    public boolean isCaseInsensitive() {
        return this._caseInsensitive;
    }
}

