/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.io.InterruptedIOException;
import javax.servlet.ServletInputStream;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.io.RuntimeIOException;
import org.eclipse.jetty.util.ArrayQueue;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public abstract class HttpInput<T>
extends ServletInputStream {
    private static final Logger LOG = Log.getLogger(HttpInput.class);
    private final ArrayQueue<T> _inputQ = new ArrayQueue();
    private boolean _earlyEOF;
    private boolean _inputEOF;

    public Object lock() {
        return this._inputQ.lock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recycle() {
        Object object = this.lock();
        synchronized (object) {
            T item = this._inputQ.peekUnsafe();
            while (item != null) {
                this._inputQ.pollUnsafe();
                this.onContentConsumed(item);
                item = this._inputQ.peekUnsafe();
                if (item != null) continue;
                this.onAllContentConsumed();
            }
            this._inputEOF = false;
            this._earlyEOF = false;
        }
    }

    @Override
    public int read() throws IOException {
        byte[] bytes = new byte[1];
        int read = this.read(bytes, 0, 1);
        return read < 0 ? -1 : 0xFF & bytes[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int available() {
        Object object = this.lock();
        synchronized (object) {
            T item = this._inputQ.peekUnsafe();
            if (item == null) {
                return 0;
            }
            return this.remaining(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] b2, int off, int len) throws IOException {
        T item = null;
        Object object = this.lock();
        synchronized (object) {
            item = this._inputQ.peekUnsafe();
            while (item != null && this.remaining(item) == 0) {
                this._inputQ.pollUnsafe();
                this.onContentConsumed(item);
                LOG.debug("{} consumed {}", this, item);
                item = this._inputQ.peekUnsafe();
                if (item != null) continue;
                this.onAllContentConsumed();
            }
            if (item == null) {
                if (this.isEarlyEOF()) {
                    throw new EofException();
                }
                if (this.isShutdown()) {
                    this.onEOF();
                    return -1;
                }
                this.blockForContent();
                item = this._inputQ.peekUnsafe();
                if (item == null) {
                    if (this.isEarlyEOF()) {
                        throw new EofException();
                    }
                    if (!this.isShutdown()) {
                        LOG.warn("Unexpected !EOF: " + this, new Object[0]);
                    }
                    this.onEOF();
                    return -1;
                }
            }
        }
        return this.get(item, b2, off, len);
    }

    protected abstract int remaining(T var1);

    protected abstract int get(T var1, byte[] var2, int var3, int var4);

    protected abstract void onContentConsumed(T var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void blockForContent() throws IOException {
        Object object = this.lock();
        synchronized (object) {
            while (this._inputQ.isEmpty() && !this.isShutdown() && !this.isEarlyEOF()) {
                try {
                    LOG.debug("{} waiting for content", this);
                    this.lock().wait();
                }
                catch (InterruptedException e2) {
                    throw (IOException)new InterruptedIOException().initCause(e2);
                }
            }
        }
    }

    protected void onContentQueued(T item) {
        this.lock().notify();
    }

    protected void onAllContentConsumed() {
    }

    protected void onEOF() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void content(T item) {
        Object object = this.lock();
        synchronized (object) {
            this._inputQ.add(item);
            this.onContentQueued(item);
            LOG.debug("{} queued {}", this, item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void earlyEOF() {
        Object object = this.lock();
        synchronized (object) {
            this._earlyEOF = true;
            this._inputEOF = true;
            this.lock().notify();
            LOG.debug("{} early EOF", this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEarlyEOF() {
        Object object = this.lock();
        synchronized (object) {
            return this._earlyEOF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.lock();
        synchronized (object) {
            this._inputEOF = true;
            this.lock().notify();
            LOG.debug("{} shutdown", this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isShutdown() {
        Object object = this.lock();
        synchronized (object) {
            return this._inputEOF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consumeAll() {
        Object object = this.lock();
        synchronized (object) {
            T item = this._inputQ.peekUnsafe();
            while (!this.isShutdown() && !this.isEarlyEOF()) {
                while (item != null) {
                    this._inputQ.pollUnsafe();
                    this.onContentConsumed(item);
                    item = this._inputQ.peekUnsafe();
                    if (item != null) continue;
                    this.onAllContentConsumed();
                }
                try {
                    this.blockForContent();
                    item = this._inputQ.peekUnsafe();
                    if (item != null) continue;
                    break;
                }
                catch (IOException e2) {
                    throw new RuntimeIOException(e2);
                }
            }
        }
    }
}

