/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.util.Locale;
import javax.servlet.http.Cookie;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.QuotedStringTokenizer;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class CookieCutter {
    private static final Logger LOG = Log.getLogger(CookieCutter.class);
    private Cookie[] _cookies;
    private Cookie[] _lastCookies;
    Object _lazyFields;
    int _fields;

    public Cookie[] getCookies() {
        if (this._cookies != null) {
            return this._cookies;
        }
        if (this._lastCookies != null && this._lazyFields != null && this._fields == LazyList.size(this._lazyFields)) {
            this._cookies = this._lastCookies;
        } else {
            this.parseFields();
        }
        this._lastCookies = this._cookies;
        return this._cookies;
    }

    public void setCookies(Cookie[] cookies) {
        this._cookies = cookies;
        this._lastCookies = null;
        this._lazyFields = null;
        this._fields = 0;
    }

    public void reset() {
        this._cookies = null;
        this._fields = 0;
    }

    public void addCookieField(String f2) {
        if (f2 == null) {
            return;
        }
        if ((f2 = f2.trim()).length() == 0) {
            return;
        }
        if (LazyList.size(this._lazyFields) > this._fields) {
            if (f2.equals(LazyList.get(this._lazyFields, this._fields))) {
                ++this._fields;
                return;
            }
            while (LazyList.size(this._lazyFields) > this._fields) {
                this._lazyFields = LazyList.remove(this._lazyFields, this._fields);
            }
        }
        this._cookies = null;
        this._lastCookies = null;
        this._lazyFields = LazyList.add(this._lazyFields, this._fields++, f2);
    }

    protected void parseFields() {
        this._lastCookies = null;
        this._cookies = null;
        Object cookies = null;
        int version = 0;
        while (LazyList.size(this._lazyFields) > this._fields) {
            this._lazyFields = LazyList.remove(this._lazyFields, this._fields);
        }
        for (int f2 = 0; f2 < this._fields; ++f2) {
            String hdr = (String)LazyList.get(this._lazyFields, f2);
            String name = null;
            String value = null;
            Cookie cookie = null;
            boolean invalue = false;
            boolean quoted = false;
            boolean escaped = false;
            int tokenstart = -1;
            int tokenend = -1;
            int length = hdr.length();
            int last = length - 1;
            block19: for (int i2 = 0; i2 < length; ++i2) {
                block46: {
                    char c2;
                    block45: {
                        c2 = hdr.charAt(i2);
                        if (!quoted) break block45;
                        if (escaped) {
                            escaped = false;
                            continue;
                        }
                        switch (c2) {
                            case '\"': {
                                tokenend = i2;
                                quoted = false;
                                if (i2 == last) {
                                    if (invalue) {
                                        value = hdr.substring(tokenstart, tokenend + 1);
                                    } else {
                                        name = hdr.substring(tokenstart, tokenend + 1);
                                        value = "";
                                    }
                                }
                                break block46;
                            }
                            case '\\': {
                                escaped = true;
                                break;
                            }
                        }
                        continue;
                    }
                    if (invalue) {
                        switch (c2) {
                            case '\t': 
                            case ' ': {
                                continue block19;
                            }
                            case '\"': {
                                if (tokenstart < 0) {
                                    quoted = true;
                                    tokenstart = i2;
                                }
                                tokenend = i2;
                                if (i2 != last) continue block19;
                                value = hdr.substring(tokenstart, tokenend + 1);
                                break;
                            }
                            case ';': {
                                value = tokenstart >= 0 ? hdr.substring(tokenstart, tokenend + 1) : "";
                                tokenstart = -1;
                                invalue = false;
                                break;
                            }
                            default: {
                                if (tokenstart < 0) {
                                    tokenstart = i2;
                                }
                                tokenend = i2;
                                if (i2 != last) continue block19;
                                value = hdr.substring(tokenstart, tokenend + 1);
                                break;
                            }
                        }
                    } else {
                        switch (c2) {
                            case '\t': 
                            case ' ': {
                                continue block19;
                            }
                            case '\"': {
                                if (tokenstart < 0) {
                                    quoted = true;
                                    tokenstart = i2;
                                }
                                tokenend = i2;
                                if (i2 != last) continue block19;
                                name = hdr.substring(tokenstart, tokenend + 1);
                                value = "";
                                break;
                            }
                            case ';': {
                                if (tokenstart >= 0) {
                                    name = hdr.substring(tokenstart, tokenend + 1);
                                    value = "";
                                }
                                tokenstart = -1;
                                break;
                            }
                            case '=': {
                                if (tokenstart >= 0) {
                                    name = hdr.substring(tokenstart, tokenend + 1);
                                }
                                tokenstart = -1;
                                invalue = true;
                                continue block19;
                            }
                            default: {
                                if (tokenstart < 0) {
                                    tokenstart = i2;
                                }
                                tokenend = i2;
                                if (i2 != last) continue block19;
                                name = hdr.substring(tokenstart, tokenend + 1);
                                value = "";
                            }
                        }
                    }
                }
                if (value == null || name == null) continue;
                name = QuotedStringTokenizer.unquoteOnly(name);
                value = QuotedStringTokenizer.unquoteOnly(value);
                try {
                    if (name.startsWith("$")) {
                        String lowercaseName = name.toLowerCase(Locale.ENGLISH);
                        if ("$path".equals(lowercaseName)) {
                            if (cookie != null) {
                                cookie.setPath(value);
                            }
                        } else if ("$domain".equals(lowercaseName)) {
                            if (cookie != null) {
                                cookie.setDomain(value);
                            }
                        } else if ("$port".equals(lowercaseName)) {
                            if (cookie != null) {
                                cookie.setComment("$port=" + value);
                            }
                        } else if ("$version".equals(lowercaseName)) {
                            version = Integer.parseInt(value);
                        }
                    } else {
                        cookie = new Cookie(name, value);
                        if (version > 0) {
                            cookie.setVersion(version);
                        }
                        cookies = LazyList.add(cookies, cookie);
                    }
                }
                catch (Exception e2) {
                    LOG.debug(e2);
                }
                name = null;
                value = null;
            }
        }
        this._cookies = (Cookie[])LazyList.toArray(cookies, Cookie.class);
        this._lastCookies = this._cookies;
    }
}

