/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

public class WriterOutputStream
extends OutputStream {
    protected final Writer _writer;
    protected final String _encoding;
    private final byte[] _buf = new byte[1];

    public WriterOutputStream(Writer writer, String encoding) {
        this._writer = writer;
        this._encoding = encoding;
    }

    public WriterOutputStream(Writer writer) {
        this._writer = writer;
        this._encoding = null;
    }

    @Override
    public void close() throws IOException {
        this._writer.close();
    }

    @Override
    public void flush() throws IOException {
        this._writer.flush();
    }

    @Override
    public void write(byte[] b2) throws IOException {
        if (this._encoding == null) {
            this._writer.write(new String(b2));
        } else {
            this._writer.write(new String(b2, this._encoding));
        }
    }

    @Override
    public void write(byte[] b2, int off, int len) throws IOException {
        if (this._encoding == null) {
            this._writer.write(new String(b2, off, len));
        } else {
            this._writer.write(new String(b2, off, len, this._encoding));
        }
    }

    @Override
    public synchronized void write(int b2) throws IOException {
        this._buf[0] = (byte)b2;
        this.write(this._buf);
    }
}

