/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.SocketChannel;
import org.eclipse.jetty.io.AbstractEndPoint;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.io.SocketBased;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Scheduler;

public class ChannelEndPoint
extends AbstractEndPoint
implements SocketBased {
    private static final Logger LOG = Log.getLogger(ChannelEndPoint.class);
    private final ByteChannel _channel;
    private final Socket _socket;
    private volatile boolean _ishut;
    private volatile boolean _oshut;

    public ChannelEndPoint(Scheduler scheduler, SocketChannel channel) {
        super(scheduler, (InetSocketAddress)channel.socket().getLocalSocketAddress(), (InetSocketAddress)channel.socket().getRemoteSocketAddress());
        this._channel = channel;
        this._socket = channel.socket();
    }

    @Override
    public boolean isOpen() {
        return this._channel.isOpen();
    }

    protected void shutdownInput() {
        LOG.debug("ishut {}", this);
        this._ishut = true;
        if (this._oshut) {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdownOutput() {
        LOG.debug("oshut {}", this);
        this._oshut = true;
        if (this._channel.isOpen()) {
            try {
                if (!this._socket.isOutputShutdown()) {
                    this._socket.shutdownOutput();
                }
            }
            catch (IOException e2) {
                LOG.debug(e2);
            }
            finally {
                if (this._ishut) {
                    this.close();
                }
            }
        }
    }

    @Override
    public boolean isOutputShutdown() {
        return this._oshut || !this._channel.isOpen() || this._socket.isOutputShutdown();
    }

    @Override
    public boolean isInputShutdown() {
        return this._ishut || !this._channel.isOpen() || this._socket.isInputShutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        LOG.debug("close {}", this);
        try {
            this._channel.close();
        }
        catch (IOException e2) {
            LOG.debug(e2);
        }
        finally {
            this._ishut = true;
            this._oshut = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int fill(ByteBuffer buffer) throws IOException {
        if (this._ishut) {
            return -1;
        }
        int pos = BufferUtil.flipToFill(buffer);
        try {
            int filled = this._channel.read(buffer);
            LOG.debug("filled {} {}", filled, this);
            if (filled > 0) {
                this.notIdle();
            } else if (filled == -1) {
                this.shutdownInput();
            }
            int n2 = filled;
            return n2;
        }
        catch (IOException e2) {
            LOG.debug(e2);
            this.shutdownInput();
            int n3 = -1;
            return n3;
        }
        finally {
            BufferUtil.flipToFlush(buffer, pos);
        }
    }

    @Override
    public boolean flush(ByteBuffer ... buffers) throws IOException {
        int flushed = 0;
        try {
            if (buffers.length == 1) {
                flushed = this._channel.write(buffers[0]);
            } else if (buffers.length > 1 && this._channel instanceof GatheringByteChannel) {
                flushed = (int)((GatheringByteChannel)((Object)this._channel)).write(buffers, 0, buffers.length);
            } else {
                for (ByteBuffer b2 : buffers) {
                    if (!b2.hasRemaining()) continue;
                    int l2 = this._channel.write(b2);
                    if (l2 > 0) {
                        flushed += l2;
                    }
                    if (b2.hasRemaining()) break;
                }
            }
            LOG.debug("flushed {} {}", flushed, this);
        }
        catch (IOException e2) {
            throw new EofException(e2);
        }
        boolean all_flushed = true;
        if (flushed > 0) {
            this.notIdle();
            for (ByteBuffer b3 : buffers) {
                if (BufferUtil.isEmpty(b3)) {
                    BufferUtil.clear(b3);
                    continue;
                }
                all_flushed = false;
            }
        }
        return all_flushed;
    }

    public ByteChannel getChannel() {
        return this._channel;
    }

    @Override
    public Object getTransport() {
        return this._channel;
    }

    @Override
    public Socket getSocket() {
        return this._socket;
    }

    @Override
    protected void onIncompleteFlush() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected boolean needsFill() throws IOException {
        throw new UnsupportedOperationException();
    }
}

