/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.util.BufferUtil;

public class ArrayByteBufferPool
implements ByteBufferPool {
    private final int _min;
    private final Bucket[] _direct;
    private final Bucket[] _indirect;
    private final int _inc;

    public ArrayByteBufferPool() {
        this(64, 2048, 65536);
    }

    public ArrayByteBufferPool(int minSize, int increment, int maxSize) {
        if (minSize >= increment) {
            throw new IllegalArgumentException("minSize >= increment");
        }
        if (maxSize % increment != 0 || increment >= maxSize) {
            throw new IllegalArgumentException("increment must be a divisor of maxSize");
        }
        this._min = minSize;
        this._inc = increment;
        this._direct = new Bucket[maxSize / increment];
        this._indirect = new Bucket[maxSize / increment];
        int size = 0;
        for (int i2 = 0; i2 < this._direct.length; ++i2) {
            this._direct[i2] = new Bucket(size += this._inc);
            this._indirect[i2] = new Bucket(size);
        }
    }

    @Override
    public ByteBuffer acquire(int size, boolean direct) {
        ByteBuffer buffer;
        Bucket bucket = this.bucketFor(size, direct);
        ByteBuffer byteBuffer = buffer = bucket == null ? null : bucket._queue.poll();
        if (buffer == null) {
            int capacity = bucket == null ? size : bucket._size;
            buffer = direct ? BufferUtil.allocateDirect(capacity) : BufferUtil.allocate(capacity);
        }
        return buffer;
    }

    @Override
    public void release(ByteBuffer buffer) {
        Bucket bucket;
        if (buffer != null && (bucket = this.bucketFor(buffer.capacity(), buffer.isDirect())) != null) {
            BufferUtil.clear(buffer);
            bucket._queue.offer(buffer);
        }
    }

    public void clear() {
        for (int i2 = 0; i2 < this._direct.length; ++i2) {
            this._direct[i2]._queue.clear();
            this._indirect[i2]._queue.clear();
        }
    }

    private Bucket bucketFor(int size, boolean direct) {
        if (size <= this._min) {
            return null;
        }
        int b2 = (size - 1) / this._inc;
        if (b2 >= this._direct.length) {
            return null;
        }
        Bucket bucket = direct ? this._direct[b2] : this._indirect[b2];
        return bucket;
    }

    Bucket[] bucketsFor(boolean direct) {
        return direct ? this._direct : this._indirect;
    }

    public static class Bucket {
        public final int _size;
        public final Queue<ByteBuffer> _queue = new ConcurrentLinkedQueue<ByteBuffer>();

        Bucket(int size) {
            this._size = size;
        }

        public String toString() {
            return String.format("Bucket@%x{%d,%d}", this.hashCode(), this._size, this._queue.size());
        }
    }
}

