/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.jetty.util.ArrayTrie;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.Trie;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class MimeTypes {
    private static final Logger LOG = Log.getLogger(MimeTypes.class);
    public static final Trie<Type> CACHE = new ArrayTrie<Type>(512);
    private static final Trie<ByteBuffer> TYPES = new ArrayTrie<ByteBuffer>(512);
    private static final Map<String, String> __dftMimeMap = new HashMap<String, String>();
    private static final Map<String, String> __encodings = new HashMap<String, String>();
    private final Map<String, String> _mimeMap = new HashMap<String, String>();

    public synchronized Map<String, String> getMimeMap() {
        return this._mimeMap;
    }

    public void setMimeMap(Map<String, String> mimeMap) {
        this._mimeMap.clear();
        if (mimeMap != null) {
            for (String ext : mimeMap.keySet()) {
                this._mimeMap.put(StringUtil.asciiToLowerCase(ext), MimeTypes.normalizeMimeType(mimeMap.get(ext)));
            }
        }
    }

    public String getMimeByExtension(String filename) {
        String type = null;
        if (filename != null) {
            int i2 = -1;
            while (type == null && (i2 = filename.indexOf(".", i2 + 1)) >= 0 && i2 < filename.length()) {
                String ext = StringUtil.asciiToLowerCase(filename.substring(i2 + 1));
                if (this._mimeMap != null) {
                    type = this._mimeMap.get(ext);
                }
                if (type != null) continue;
                type = __dftMimeMap.get(ext);
            }
        }
        if (type == null) {
            if (this._mimeMap != null) {
                type = this._mimeMap.get("*");
            }
            if (type == null) {
                type = __dftMimeMap.get("*");
            }
        }
        return type;
    }

    public void addMimeMapping(String extension, String type) {
        this._mimeMap.put(StringUtil.asciiToLowerCase(extension), MimeTypes.normalizeMimeType(type));
    }

    private static String normalizeMimeType(String type) {
        Type t = CACHE.get(type);
        if (t != null) {
            return t.asString();
        }
        return StringUtil.asciiToLowerCase(type);
    }

    public static String getCharsetFromContentType(String value) {
        int i2;
        if (value == null) {
            return null;
        }
        int end = value.length();
        int state = 0;
        int start = 0;
        boolean quote = false;
        block13: for (i2 = 0; i2 < end; ++i2) {
            char b2 = value.charAt(i2);
            if (quote && state != 10) {
                if ('\"' != b2) continue;
                quote = false;
                continue;
            }
            switch (state) {
                case 0: {
                    if ('\"' == b2) {
                        quote = true;
                        continue block13;
                    }
                    if (';' != b2) continue block13;
                    state = 1;
                    continue block13;
                }
                case 1: {
                    if ('c' == b2) {
                        state = 2;
                        continue block13;
                    }
                    if (' ' == b2) continue block13;
                    state = 0;
                    continue block13;
                }
                case 2: {
                    if ('h' == b2) {
                        state = 3;
                        continue block13;
                    }
                    state = 0;
                    continue block13;
                }
                case 3: {
                    if ('a' == b2) {
                        state = 4;
                        continue block13;
                    }
                    state = 0;
                    continue block13;
                }
                case 4: {
                    if ('r' == b2) {
                        state = 5;
                        continue block13;
                    }
                    state = 0;
                    continue block13;
                }
                case 5: {
                    if ('s' == b2) {
                        state = 6;
                        continue block13;
                    }
                    state = 0;
                    continue block13;
                }
                case 6: {
                    if ('e' == b2) {
                        state = 7;
                        continue block13;
                    }
                    state = 0;
                    continue block13;
                }
                case 7: {
                    if ('t' == b2) {
                        state = 8;
                        continue block13;
                    }
                    state = 0;
                    continue block13;
                }
                case 8: {
                    if ('=' == b2) {
                        state = 9;
                        continue block13;
                    }
                    if (' ' == b2) continue block13;
                    state = 0;
                    continue block13;
                }
                case 9: {
                    if (' ' == b2) continue block13;
                    if ('\"' == b2) {
                        quote = true;
                        start = i2 + 1;
                        state = 10;
                        continue block13;
                    }
                    start = i2;
                    state = 10;
                    continue block13;
                }
                case 10: {
                    if ((quote || ';' != b2 && ' ' != b2) && (!quote || '\"' != b2)) continue block13;
                    return StringUtil.normalizeCharset(value, start, i2 - start);
                }
            }
        }
        if (state == 10) {
            return StringUtil.normalizeCharset(value, start, i2 - start);
        }
        return null;
    }

    public static String inferCharsetFromContentType(String value) {
        return __encodings.get(value);
    }

    public static String getContentTypeWithoutCharset(String value) {
        int end = value.length();
        int state = 0;
        int start = 0;
        boolean quote = false;
        StringBuilder builder = null;
        block19: for (int i2 = 0; i2 < end; ++i2) {
            char b2 = value.charAt(i2);
            if ('\"' == b2) {
                quote = !quote;
                switch (state) {
                    case 11: {
                        builder.append(b2);
                        break;
                    }
                    case 10: {
                        break;
                    }
                    case 9: {
                        builder = new StringBuilder();
                        builder.append(value, 0, start + 1);
                        state = 10;
                        break;
                    }
                    default: {
                        start = i2;
                        state = 0;
                        break;
                    }
                }
                continue;
            }
            if (quote) {
                if (builder == null || state == 10) continue;
                builder.append(b2);
                continue;
            }
            switch (state) {
                case 0: {
                    if (';' == b2) {
                        state = 1;
                        continue block19;
                    }
                    if (' ' == b2) continue block19;
                    start = i2;
                    continue block19;
                }
                case 1: {
                    if ('c' == b2) {
                        state = 2;
                        continue block19;
                    }
                    if (' ' == b2) continue block19;
                    state = 0;
                    continue block19;
                }
                case 2: {
                    if ('h' == b2) {
                        state = 3;
                        continue block19;
                    }
                    state = 0;
                    continue block19;
                }
                case 3: {
                    if ('a' == b2) {
                        state = 4;
                        continue block19;
                    }
                    state = 0;
                    continue block19;
                }
                case 4: {
                    if ('r' == b2) {
                        state = 5;
                        continue block19;
                    }
                    state = 0;
                    continue block19;
                }
                case 5: {
                    if ('s' == b2) {
                        state = 6;
                        continue block19;
                    }
                    state = 0;
                    continue block19;
                }
                case 6: {
                    if ('e' == b2) {
                        state = 7;
                        continue block19;
                    }
                    state = 0;
                    continue block19;
                }
                case 7: {
                    if ('t' == b2) {
                        state = 8;
                        continue block19;
                    }
                    state = 0;
                    continue block19;
                }
                case 8: {
                    if ('=' == b2) {
                        state = 9;
                        continue block19;
                    }
                    if (' ' == b2) continue block19;
                    state = 0;
                    continue block19;
                }
                case 9: {
                    if (' ' == b2) continue block19;
                    builder = new StringBuilder();
                    builder.append(value, 0, start + 1);
                    state = 10;
                    continue block19;
                }
                case 10: {
                    if (';' != b2) continue block19;
                    builder.append(b2);
                    state = 11;
                    continue block19;
                }
                case 11: {
                    if (' ' == b2) continue block19;
                    builder.append(b2);
                }
            }
        }
        if (builder == null) {
            return value;
        }
        return builder.toString();
    }

    static {
        for (Type type : Type.values()) {
            CACHE.put(type.toString(), type);
            TYPES.put(type.toString(), type.asBuffer());
            int charset = type.toString().indexOf(";charset=");
            if (charset <= 0) continue;
            CACHE.put(type.toString().replace(";charset=", "; charset="), type);
            TYPES.put(type.toString().replace(";charset=", "; charset="), type.asBuffer());
        }
        try {
            ResourceBundle mime = ResourceBundle.getBundle("org/eclipse/jetty/http/mime");
            Enumeration<String> i2 = mime.getKeys();
            while (i2.hasMoreElements()) {
                String ext = i2.nextElement();
                String m2 = mime.getString(ext);
                __dftMimeMap.put(StringUtil.asciiToLowerCase(ext), MimeTypes.normalizeMimeType(m2));
            }
        }
        catch (MissingResourceException e2) {
            LOG.warn(e2.toString(), new Object[0]);
            LOG.debug(e2);
        }
        try {
            ResourceBundle encoding = ResourceBundle.getBundle("org/eclipse/jetty/http/encoding");
            Enumeration<String> i3 = encoding.getKeys();
            while (i3.hasMoreElements()) {
                String type = i3.nextElement();
                __encodings.put(type, encoding.getString(type));
            }
        }
        catch (MissingResourceException e3) {
            LOG.warn(e3.toString(), new Object[0]);
            LOG.debug(e3);
        }
    }

    public static enum Type {
        FORM_ENCODED("application/x-www-form-urlencoded"),
        MESSAGE_HTTP("message/http"),
        MULTIPART_BYTERANGES("multipart/byteranges"),
        TEXT_HTML("text/html"),
        TEXT_PLAIN("text/plain"),
        TEXT_XML("text/xml"),
        TEXT_JSON("text/json"),
        TEXT_HTML_8859_1("text/html;charset=ISO-8859-1"),
        TEXT_PLAIN_8859_1("text/plain;charset=ISO-8859-1"),
        TEXT_XML_8859_1("text/xml;charset=ISO-8859-1"),
        TEXT_HTML_UTF_8("text/html;charset=UTF-8"),
        TEXT_PLAIN_UTF_8("text/plain;charset=UTF-8"),
        TEXT_XML_UTF_8("text/xml;charset=UTF-8"),
        TEXT_JSON_UTF_8("text/json;charset=UTF-8");

        private final String _string;
        private final ByteBuffer _buffer;
        private final Charset _charset;

        private Type(String s) {
            this._string = s;
            this._buffer = BufferUtil.toBuffer(s);
            int i2 = s.toLowerCase(Locale.ENGLISH).indexOf("charset=");
            this._charset = i2 > 0 ? Charset.forName(s.substring(i2 + 8)) : null;
        }

        public ByteBuffer asBuffer() {
            return this._buffer.asReadOnlyBuffer();
        }

        public Charset getCharset() {
            return this._charset;
        }

        public boolean is(String s) {
            return this._string.equalsIgnoreCase(s);
        }

        public String asString() {
            return this._string;
        }

        public String toString() {
            return this._string;
        }
    }
}

