/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.util;

import java.math.BigInteger;
import java.security.SecureRandom;

public final class BigIntegers {
    private static final int MAX_ITERATIONS = 1000;
    private static final BigInteger ZERO = BigInteger.valueOf(0L);

    public static byte[] asUnsignedByteArray(BigInteger bigInteger) {
        byte[] byArray = bigInteger.toByteArray();
        if (byArray[0] == 0) {
            byte[] byArray2 = new byte[byArray.length - 1];
            System.arraycopy(byArray, 1, byArray2, 0, byArray2.length);
            return byArray2;
        }
        return byArray;
    }

    public static byte[] asUnsignedByteArray(int n2, BigInteger bigInteger) {
        byte[] byArray = bigInteger.toByteArray();
        if (byArray[0] == 0) {
            if (byArray.length - 1 > n2) {
                throw new IllegalArgumentException("standard length exceeded for value");
            }
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, 1, byArray2, byArray2.length - (byArray.length - 1), byArray.length - 1);
            return byArray2;
        }
        if (byArray.length == n2) {
            return byArray;
        }
        if (byArray.length > n2) {
            throw new IllegalArgumentException("standard length exceeded for value");
        }
        byte[] byArray3 = new byte[n2];
        System.arraycopy(byArray, 0, byArray3, byArray3.length - byArray.length, byArray.length);
        return byArray3;
    }

    public static BigInteger createRandomInRange(BigInteger bigInteger, BigInteger bigInteger2, SecureRandom secureRandom) {
        int n2 = bigInteger.compareTo(bigInteger2);
        if (n2 >= 0) {
            if (n2 > 0) {
                throw new IllegalArgumentException("'min' may not be greater than 'max'");
            }
            return bigInteger;
        }
        if (bigInteger.bitLength() > bigInteger2.bitLength() / 2) {
            return BigIntegers.createRandomInRange(ZERO, bigInteger2.subtract(bigInteger), secureRandom).add(bigInteger);
        }
        for (int i2 = 0; i2 < 1000; ++i2) {
            BigInteger bigInteger3 = new BigInteger(bigInteger2.bitLength(), secureRandom);
            if (bigInteger3.compareTo(bigInteger) < 0 || bigInteger3.compareTo(bigInteger2) > 0) continue;
            return bigInteger3;
        }
        return new BigInteger(bigInteger2.subtract(bigInteger).bitLength() - 1, secureRandom).add(bigInteger);
    }
}

