/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider.symmetric.util;

import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.PBEParametersGenerator;
import org.bouncycastle.crypto.digests.GOST3411Digest;
import org.bouncycastle.crypto.digests.MD2Digest;
import org.bouncycastle.crypto.digests.MD5Digest;
import org.bouncycastle.crypto.digests.RIPEMD160Digest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.digests.TigerDigest;
import org.bouncycastle.crypto.generators.OpenSSLPBEParametersGenerator;
import org.bouncycastle.crypto.generators.PKCS12ParametersGenerator;
import org.bouncycastle.crypto.generators.PKCS5S1ParametersGenerator;
import org.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import org.bouncycastle.crypto.params.DESParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.jcajce.provider.symmetric.util.BCPBEKey;

public interface PBE {
    public static final int MD5 = 0;
    public static final int SHA1 = 1;
    public static final int RIPEMD160 = 2;
    public static final int TIGER = 3;
    public static final int SHA256 = 4;
    public static final int MD2 = 5;
    public static final int GOST3411 = 6;
    public static final int PKCS5S1 = 0;
    public static final int PKCS5S2 = 1;
    public static final int PKCS12 = 2;
    public static final int OPENSSL = 3;
    public static final int PKCS5S1_UTF8 = 4;
    public static final int PKCS5S2_UTF8 = 5;

    public static class Util {
        private static PBEParametersGenerator makePBEGenerator(int n2, int n3) {
            PBEParametersGenerator pBEParametersGenerator;
            block15: {
                block17: {
                    block16: {
                        block14: {
                            if (n2 != 0 && n2 != 4) break block14;
                            switch (n3) {
                                case 5: {
                                    pBEParametersGenerator = new PKCS5S1ParametersGenerator(new MD2Digest());
                                    break block15;
                                }
                                case 0: {
                                    pBEParametersGenerator = new PKCS5S1ParametersGenerator(new MD5Digest());
                                    break block15;
                                }
                                case 1: {
                                    pBEParametersGenerator = new PKCS5S1ParametersGenerator(new SHA1Digest());
                                    break block15;
                                }
                                default: {
                                    throw new IllegalStateException("PKCS5 scheme 1 only supports MD2, MD5 and SHA1.");
                                }
                            }
                        }
                        if (n2 != 1 && n2 != 5) break block16;
                        pBEParametersGenerator = new PKCS5S2ParametersGenerator();
                        break block15;
                    }
                    if (n2 != 2) break block17;
                    switch (n3) {
                        case 5: {
                            pBEParametersGenerator = new PKCS12ParametersGenerator(new MD2Digest());
                            break block15;
                        }
                        case 0: {
                            pBEParametersGenerator = new PKCS12ParametersGenerator(new MD5Digest());
                            break block15;
                        }
                        case 1: {
                            pBEParametersGenerator = new PKCS12ParametersGenerator(new SHA1Digest());
                            break block15;
                        }
                        case 2: {
                            pBEParametersGenerator = new PKCS12ParametersGenerator(new RIPEMD160Digest());
                            break block15;
                        }
                        case 3: {
                            pBEParametersGenerator = new PKCS12ParametersGenerator(new TigerDigest());
                            break block15;
                        }
                        case 4: {
                            pBEParametersGenerator = new PKCS12ParametersGenerator(new SHA256Digest());
                            break block15;
                        }
                        case 6: {
                            pBEParametersGenerator = new PKCS12ParametersGenerator(new GOST3411Digest());
                            break block15;
                        }
                        default: {
                            throw new IllegalStateException("unknown digest scheme for PBE encryption.");
                        }
                    }
                }
                pBEParametersGenerator = new OpenSSLPBEParametersGenerator();
            }
            return pBEParametersGenerator;
        }

        public static CipherParameters makePBEParameters(BCPBEKey bCPBEKey, AlgorithmParameterSpec algorithmParameterSpec, String string) {
            if (algorithmParameterSpec == null || !(algorithmParameterSpec instanceof PBEParameterSpec)) {
                throw new IllegalArgumentException("Need a PBEParameter spec with a PBE key.");
            }
            PBEParameterSpec pBEParameterSpec = (PBEParameterSpec)algorithmParameterSpec;
            PBEParametersGenerator pBEParametersGenerator = Util.makePBEGenerator(bCPBEKey.getType(), bCPBEKey.getDigest());
            byte[] byArray = bCPBEKey.getEncoded();
            if (bCPBEKey.shouldTryWrongPKCS12()) {
                byArray = new byte[2];
            }
            pBEParametersGenerator.init(byArray, pBEParameterSpec.getSalt(), pBEParameterSpec.getIterationCount());
            CipherParameters cipherParameters = bCPBEKey.getIvSize() != 0 ? pBEParametersGenerator.generateDerivedParameters(bCPBEKey.getKeySize(), bCPBEKey.getIvSize()) : pBEParametersGenerator.generateDerivedParameters(bCPBEKey.getKeySize());
            if (string.startsWith("DES")) {
                KeyParameter keyParameter;
                if (cipherParameters instanceof ParametersWithIV) {
                    keyParameter = (KeyParameter)((ParametersWithIV)cipherParameters).getParameters();
                    DESParameters.setOddParity(keyParameter.getKey());
                } else {
                    keyParameter = (KeyParameter)cipherParameters;
                    DESParameters.setOddParity(keyParameter.getKey());
                }
            }
            for (int i2 = 0; i2 != byArray.length; ++i2) {
                byArray[i2] = 0;
            }
            return cipherParameters;
        }

        public static CipherParameters makePBEMacParameters(BCPBEKey bCPBEKey, AlgorithmParameterSpec algorithmParameterSpec) {
            if (algorithmParameterSpec == null || !(algorithmParameterSpec instanceof PBEParameterSpec)) {
                throw new IllegalArgumentException("Need a PBEParameter spec with a PBE key.");
            }
            PBEParameterSpec pBEParameterSpec = (PBEParameterSpec)algorithmParameterSpec;
            PBEParametersGenerator pBEParametersGenerator = Util.makePBEGenerator(bCPBEKey.getType(), bCPBEKey.getDigest());
            byte[] byArray = bCPBEKey.getEncoded();
            if (bCPBEKey.shouldTryWrongPKCS12()) {
                byArray = new byte[2];
            }
            pBEParametersGenerator.init(byArray, pBEParameterSpec.getSalt(), pBEParameterSpec.getIterationCount());
            CipherParameters cipherParameters = pBEParametersGenerator.generateDerivedMacParameters(bCPBEKey.getKeySize());
            for (int i2 = 0; i2 != byArray.length; ++i2) {
                byArray[i2] = 0;
            }
            return cipherParameters;
        }

        public static CipherParameters makePBEParameters(PBEKeySpec pBEKeySpec, int n2, int n3, int n4, int n5) {
            PBEParametersGenerator pBEParametersGenerator = Util.makePBEGenerator(n2, n3);
            byte[] byArray = Util.convertPassword(n2, pBEKeySpec);
            pBEParametersGenerator.init(byArray, pBEKeySpec.getSalt(), pBEKeySpec.getIterationCount());
            CipherParameters cipherParameters = n5 != 0 ? pBEParametersGenerator.generateDerivedParameters(n4, n5) : pBEParametersGenerator.generateDerivedParameters(n4);
            for (int i2 = 0; i2 != byArray.length; ++i2) {
                byArray[i2] = 0;
            }
            return cipherParameters;
        }

        public static CipherParameters makePBEMacParameters(PBEKeySpec pBEKeySpec, int n2, int n3, int n4) {
            PBEParametersGenerator pBEParametersGenerator = Util.makePBEGenerator(n2, n3);
            byte[] byArray = Util.convertPassword(n2, pBEKeySpec);
            pBEParametersGenerator.init(byArray, pBEKeySpec.getSalt(), pBEKeySpec.getIterationCount());
            CipherParameters cipherParameters = pBEParametersGenerator.generateDerivedMacParameters(n4);
            for (int i2 = 0; i2 != byArray.length; ++i2) {
                byArray[i2] = 0;
            }
            return cipherParameters;
        }

        private static byte[] convertPassword(int n2, PBEKeySpec pBEKeySpec) {
            byte[] byArray = n2 == 2 ? PBEParametersGenerator.PKCS12PasswordToBytes(pBEKeySpec.getPassword()) : (n2 == 5 || n2 == 4 ? PBEParametersGenerator.PKCS5PasswordToUTF8Bytes(pBEKeySpec.getPassword()) : PBEParametersGenerator.PKCS5PasswordToBytes(pBEKeySpec.getPassword()));
            return byArray;
        }
    }
}

