/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.tls;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Hashtable;
import org.bouncycastle.asn1.sec.SECNamedCurves;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.agreement.ECDHBasicAgreement;
import org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.tls.NamedCurve;
import org.bouncycastle.crypto.tls.TlsFatalAlert;
import org.bouncycastle.crypto.tls.TlsProtocol;
import org.bouncycastle.crypto.tls.TlsUtils;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.Integers;

public class TlsECCUtils {
    public static final Integer EXT_elliptic_curves = Integers.valueOf(10);
    public static final Integer EXT_ec_point_formats = Integers.valueOf(11);
    private static final String[] curveNames = new String[]{"sect163k1", "sect163r1", "sect163r2", "sect193r1", "sect193r2", "sect233k1", "sect233r1", "sect239k1", "sect283k1", "sect283r1", "sect409k1", "sect409r1", "sect571k1", "sect571r1", "secp160k1", "secp160r1", "secp160r2", "secp192k1", "secp192r1", "secp224k1", "secp224r1", "secp256k1", "secp256r1", "secp384r1", "secp521r1"};

    public static void addSupportedEllipticCurvesExtension(Hashtable hashtable, int[] nArray) throws IOException {
        hashtable.put(EXT_elliptic_curves, TlsECCUtils.createSupportedEllipticCurvesExtension(nArray));
    }

    public static void addSupportedPointFormatsExtension(Hashtable hashtable, short[] sArray) throws IOException {
        hashtable.put(EXT_ec_point_formats, TlsECCUtils.createSupportedPointFormatsExtension(sArray));
    }

    public static int[] getSupportedEllipticCurvesExtension(Hashtable hashtable) throws IOException {
        if (hashtable == null) {
            return null;
        }
        byte[] byArray = (byte[])hashtable.get(EXT_elliptic_curves);
        if (byArray == null) {
            return null;
        }
        return TlsECCUtils.readSupportedEllipticCurvesExtension(byArray);
    }

    public static short[] getSupportedPointFormatsExtension(Hashtable hashtable) throws IOException {
        if (hashtable == null) {
            return null;
        }
        byte[] byArray = (byte[])hashtable.get(EXT_ec_point_formats);
        if (byArray == null) {
            return null;
        }
        return TlsECCUtils.readSupportedPointFormatsExtension(byArray);
    }

    public static byte[] createSupportedEllipticCurvesExtension(int[] nArray) throws IOException {
        if (nArray == null || nArray.length < 1) {
            throw new TlsFatalAlert(80);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        TlsUtils.writeUint16(2 * nArray.length, byteArrayOutputStream);
        TlsUtils.writeUint16Array(nArray, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] createSupportedPointFormatsExtension(short[] object) throws IOException {
        Object object2;
        if (object == null) {
            object = new short[]{0};
        } else if (!TlsProtocol.arrayContains(object, (short)0)) {
            object2 = new short[((short[])object).length + 1];
            System.arraycopy(object, 0, object2, 0, ((short[])object).length);
            object2[((short[])object).length] = false;
            object = object2;
        }
        object2 = new ByteArrayOutputStream();
        TlsUtils.writeUint8((short)((short[])object).length, (OutputStream)object2);
        TlsUtils.writeUint8Array(object, (OutputStream)object2);
        return ((ByteArrayOutputStream)object2).toByteArray();
    }

    public static int[] readSupportedEllipticCurvesExtension(byte[] byArray) throws IOException {
        if (byArray == null) {
            throw new IllegalArgumentException("'extensionValue' cannot be null");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        int n2 = TlsUtils.readUint16(byteArrayInputStream);
        if (n2 < 2 || (n2 & 1) != 0) {
            throw new TlsFatalAlert(50);
        }
        int[] nArray = TlsUtils.readUint16Array(n2 / 2, byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        return nArray;
    }

    public static short[] readSupportedPointFormatsExtension(byte[] byArray) throws IOException {
        if (byArray == null) {
            throw new IllegalArgumentException("'extensionValue' cannot be null");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        short s = TlsUtils.readUint8(byteArrayInputStream);
        if (s < 1) {
            throw new TlsFatalAlert(50);
        }
        short[] sArray = TlsUtils.readUint8Array(s, byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        if (!TlsProtocol.arrayContains(sArray, (short)0)) {
            throw new TlsFatalAlert(47);
        }
        return sArray;
    }

    public static String getNameOfNamedCurve(int n2) {
        return TlsECCUtils.isSupportedNamedCurve(n2) ? curveNames[n2 - 1] : null;
    }

    public static ECDomainParameters getParametersForNamedCurve(int n2) {
        String string = TlsECCUtils.getNameOfNamedCurve(n2);
        if (string == null) {
            return null;
        }
        X9ECParameters x9ECParameters = SECNamedCurves.getByName(string);
        if (x9ECParameters == null) {
            return null;
        }
        return new ECDomainParameters(x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN(), x9ECParameters.getH(), x9ECParameters.getSeed());
    }

    public static boolean hasAnySupportedNamedCurves() {
        return curveNames.length > 0;
    }

    public static boolean containsECCCipherSuites(int[] nArray) {
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (!TlsECCUtils.isECCCipherSuite(nArray[i2])) continue;
            return true;
        }
        return false;
    }

    public static boolean isECCCipherSuite(int n2) {
        switch (n2) {
            case 49153: 
            case 49154: 
            case 49155: 
            case 49156: 
            case 49157: 
            case 49158: 
            case 49159: 
            case 49160: 
            case 49161: 
            case 49162: 
            case 49163: 
            case 49164: 
            case 49165: 
            case 49166: 
            case 49167: 
            case 49168: 
            case 49169: 
            case 49170: 
            case 49171: 
            case 49172: 
            case 49173: 
            case 49174: 
            case 49175: 
            case 49176: 
            case 49177: 
            case 49187: 
            case 49188: 
            case 49189: 
            case 49190: 
            case 49191: 
            case 49192: 
            case 49193: 
            case 49194: 
            case 49195: 
            case 49196: 
            case 49197: 
            case 49198: 
            case 49199: 
            case 49200: 
            case 49201: 
            case 49202: {
                return true;
            }
        }
        return false;
    }

    public static boolean areOnSameCurve(ECDomainParameters eCDomainParameters, ECDomainParameters eCDomainParameters2) {
        return eCDomainParameters.getCurve().equals(eCDomainParameters2.getCurve()) && eCDomainParameters.getG().equals(eCDomainParameters2.getG()) && eCDomainParameters.getN().equals(eCDomainParameters2.getN()) && eCDomainParameters.getH().equals(eCDomainParameters2.getH());
    }

    public static boolean isSupportedNamedCurve(int n2) {
        return n2 > 0 && n2 <= curveNames.length;
    }

    public static boolean isCompressionPreferred(short[] sArray, short s) {
        if (sArray == null) {
            return false;
        }
        for (int i2 = 0; i2 < sArray.length; ++i2) {
            short s2 = sArray[i2];
            if (s2 == 0) {
                return false;
            }
            if (s2 != s) continue;
            return true;
        }
        return false;
    }

    public static byte[] serializeECFieldElement(int n2, BigInteger bigInteger) throws IOException {
        int n3 = (n2 + 7) / 8;
        return BigIntegers.asUnsignedByteArray(n3, bigInteger);
    }

    public static byte[] serializeECPoint(short[] sArray, ECPoint eCPoint) throws IOException {
        ECCurve eCCurve = eCPoint.getCurve();
        boolean bl = false;
        if (eCCurve instanceof ECCurve.F2m) {
            bl = TlsECCUtils.isCompressionPreferred(sArray, (short)2);
        } else if (eCCurve instanceof ECCurve.Fp) {
            bl = TlsECCUtils.isCompressionPreferred(sArray, (short)1);
        }
        return eCPoint.getEncoded(bl);
    }

    public static byte[] serializeECPublicKey(short[] sArray, ECPublicKeyParameters eCPublicKeyParameters) throws IOException {
        return TlsECCUtils.serializeECPoint(sArray, eCPublicKeyParameters.getQ());
    }

    public static BigInteger deserializeECFieldElement(int n2, byte[] byArray) throws IOException {
        int n3 = (n2 + 7) / 8;
        if (byArray.length != n3) {
            throw new TlsFatalAlert(50);
        }
        return new BigInteger(1, byArray);
    }

    public static ECPoint deserializeECPoint(short[] sArray, ECCurve eCCurve, byte[] byArray) throws IOException {
        return eCCurve.decodePoint(byArray);
    }

    public static ECPublicKeyParameters deserializeECPublicKey(short[] sArray, ECDomainParameters eCDomainParameters, byte[] byArray) throws IOException {
        try {
            ECPoint eCPoint = TlsECCUtils.deserializeECPoint(sArray, eCDomainParameters.getCurve(), byArray);
            return new ECPublicKeyParameters(eCPoint, eCDomainParameters);
        }
        catch (RuntimeException runtimeException) {
            throw new TlsFatalAlert(47);
        }
    }

    public static byte[] calculateECDHBasicAgreement(ECPublicKeyParameters eCPublicKeyParameters, ECPrivateKeyParameters eCPrivateKeyParameters) {
        ECDHBasicAgreement eCDHBasicAgreement = new ECDHBasicAgreement();
        eCDHBasicAgreement.init(eCPrivateKeyParameters);
        BigInteger bigInteger = eCDHBasicAgreement.calculateAgreement(eCPublicKeyParameters);
        return BigIntegers.asUnsignedByteArray(eCDHBasicAgreement.getFieldSize(), bigInteger);
    }

    public static AsymmetricCipherKeyPair generateECKeyPair(SecureRandom secureRandom, ECDomainParameters eCDomainParameters) {
        ECKeyPairGenerator eCKeyPairGenerator = new ECKeyPairGenerator();
        ECKeyGenerationParameters eCKeyGenerationParameters = new ECKeyGenerationParameters(eCDomainParameters, secureRandom);
        eCKeyPairGenerator.init(eCKeyGenerationParameters);
        return eCKeyPairGenerator.generateKeyPair();
    }

    public static ECPublicKeyParameters validateECPublicKey(ECPublicKeyParameters eCPublicKeyParameters) throws IOException {
        return eCPublicKeyParameters;
    }

    public static int readECExponent(int n2, InputStream inputStream) throws IOException {
        int n3;
        BigInteger bigInteger = TlsECCUtils.readECParameter(inputStream);
        if (bigInteger.bitLength() < 32 && (n3 = bigInteger.intValue()) > 0 && n3 < n2) {
            return n3;
        }
        throw new TlsFatalAlert(47);
    }

    public static BigInteger readECFieldElement(int n2, InputStream inputStream) throws IOException {
        return TlsECCUtils.deserializeECFieldElement(n2, TlsUtils.readOpaque8(inputStream));
    }

    public static BigInteger readECParameter(InputStream inputStream) throws IOException {
        return new BigInteger(1, TlsUtils.readOpaque8(inputStream));
    }

    public static ECDomainParameters readECParameters(int[] nArray, short[] sArray, InputStream inputStream) throws IOException {
        try {
            short s = TlsUtils.readUint8(inputStream);
            switch (s) {
                case 1: {
                    BigInteger bigInteger = TlsECCUtils.readECParameter(inputStream);
                    BigInteger bigInteger2 = TlsECCUtils.readECFieldElement(bigInteger.bitLength(), inputStream);
                    BigInteger bigInteger3 = TlsECCUtils.readECFieldElement(bigInteger.bitLength(), inputStream);
                    ECCurve.Fp fp = new ECCurve.Fp(bigInteger, bigInteger2, bigInteger3);
                    ECPoint eCPoint = TlsECCUtils.deserializeECPoint(sArray, fp, TlsUtils.readOpaque8(inputStream));
                    BigInteger bigInteger4 = TlsECCUtils.readECParameter(inputStream);
                    BigInteger bigInteger5 = TlsECCUtils.readECParameter(inputStream);
                    return new ECDomainParameters(fp, eCPoint, bigInteger4, bigInteger5);
                }
                case 2: {
                    ECCurve.F2m f2m;
                    int n2 = TlsUtils.readUint16(inputStream);
                    short s2 = TlsUtils.readUint8(inputStream);
                    switch (s2) {
                        case 1: {
                            int n3 = TlsECCUtils.readECExponent(n2, inputStream);
                            BigInteger bigInteger = TlsECCUtils.readECFieldElement(n2, inputStream);
                            BigInteger bigInteger6 = TlsECCUtils.readECFieldElement(n2, inputStream);
                            f2m = new ECCurve.F2m(n2, n3, bigInteger, bigInteger6);
                            break;
                        }
                        case 2: {
                            int n3 = TlsECCUtils.readECExponent(n2, inputStream);
                            int n4 = TlsECCUtils.readECExponent(n2, inputStream);
                            int n5 = TlsECCUtils.readECExponent(n2, inputStream);
                            BigInteger bigInteger = TlsECCUtils.readECFieldElement(n2, inputStream);
                            BigInteger bigInteger7 = TlsECCUtils.readECFieldElement(n2, inputStream);
                            f2m = new ECCurve.F2m(n2, n3, n4, n5, bigInteger, bigInteger7);
                            break;
                        }
                        default: {
                            throw new TlsFatalAlert(47);
                        }
                    }
                    ECPoint eCPoint = TlsECCUtils.deserializeECPoint(sArray, f2m, TlsUtils.readOpaque8(inputStream));
                    BigInteger bigInteger = TlsECCUtils.readECParameter(inputStream);
                    BigInteger bigInteger8 = TlsECCUtils.readECParameter(inputStream);
                    return new ECDomainParameters(f2m, eCPoint, bigInteger, bigInteger8);
                }
                case 3: {
                    int n6 = TlsUtils.readUint16(inputStream);
                    if (!NamedCurve.refersToASpecificNamedCurve(n6)) {
                        throw new TlsFatalAlert(47);
                    }
                    if (!TlsProtocol.arrayContains(nArray, n6)) {
                        throw new TlsFatalAlert(47);
                    }
                    return TlsECCUtils.getParametersForNamedCurve(n6);
                }
            }
            throw new TlsFatalAlert(47);
        }
        catch (RuntimeException runtimeException) {
            throw new TlsFatalAlert(47);
        }
    }

    public static void writeECExponent(int n2, OutputStream outputStream) throws IOException {
        BigInteger bigInteger = BigInteger.valueOf(n2);
        TlsECCUtils.writeECParameter(bigInteger, outputStream);
    }

    public static void writeECFieldElement(int n2, BigInteger bigInteger, OutputStream outputStream) throws IOException {
        TlsUtils.writeOpaque8(TlsECCUtils.serializeECFieldElement(n2, bigInteger), outputStream);
    }

    public static void writeECParameter(BigInteger bigInteger, OutputStream outputStream) throws IOException {
        TlsUtils.writeOpaque8(BigIntegers.asUnsignedByteArray(bigInteger), outputStream);
    }

    public static void writeExplicitECParameters(short[] sArray, ECDomainParameters eCDomainParameters, OutputStream outputStream) throws IOException {
        ECCurve eCCurve = eCDomainParameters.getCurve();
        if (eCCurve instanceof ECCurve.Fp) {
            TlsUtils.writeUint8((short)1, outputStream);
            ECCurve.Fp fp = (ECCurve.Fp)eCCurve;
            TlsECCUtils.writeECParameter(fp.getQ(), outputStream);
        } else if (eCCurve instanceof ECCurve.F2m) {
            TlsUtils.writeUint8((short)2, outputStream);
            ECCurve.F2m f2m = (ECCurve.F2m)eCCurve;
            TlsUtils.writeUint16(f2m.getM(), outputStream);
            if (f2m.isTrinomial()) {
                TlsUtils.writeUint8((short)1, outputStream);
                TlsECCUtils.writeECExponent(f2m.getK1(), outputStream);
            } else {
                TlsUtils.writeUint8((short)2, outputStream);
                TlsECCUtils.writeECExponent(f2m.getK1(), outputStream);
                TlsECCUtils.writeECExponent(f2m.getK2(), outputStream);
                TlsECCUtils.writeECExponent(f2m.getK3(), outputStream);
            }
        } else {
            throw new IllegalArgumentException("'ecParameters' not a known curve type");
        }
        TlsECCUtils.writeECFieldElement(eCCurve.getFieldSize(), eCCurve.getA().toBigInteger(), outputStream);
        TlsECCUtils.writeECFieldElement(eCCurve.getFieldSize(), eCCurve.getB().toBigInteger(), outputStream);
        TlsUtils.writeOpaque8(TlsECCUtils.serializeECPoint(sArray, eCDomainParameters.getG()), outputStream);
        TlsECCUtils.writeECParameter(eCDomainParameters.getN(), outputStream);
        TlsECCUtils.writeECParameter(eCDomainParameters.getH(), outputStream);
    }

    public static void writeNamedECParameters(int n2, OutputStream outputStream) throws IOException {
        if (!NamedCurve.refersToASpecificNamedCurve(n2)) {
            throw new TlsFatalAlert(80);
        }
        TlsUtils.writeUint8((short)3, outputStream);
        TlsUtils.writeUint16(n2, outputStream);
    }
}

