/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.tls;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.bouncycastle.crypto.prng.ThreadedSeedGenerator;
import org.bouncycastle.crypto.tls.AbstractTlsContext;
import org.bouncycastle.crypto.tls.Certificate;
import org.bouncycastle.crypto.tls.CertificateRequest;
import org.bouncycastle.crypto.tls.NewSessionTicket;
import org.bouncycastle.crypto.tls.ProtocolVersion;
import org.bouncycastle.crypto.tls.SecurityParameters;
import org.bouncycastle.crypto.tls.TlsAuthentication;
import org.bouncycastle.crypto.tls.TlsClient;
import org.bouncycastle.crypto.tls.TlsClientContextImpl;
import org.bouncycastle.crypto.tls.TlsCredentials;
import org.bouncycastle.crypto.tls.TlsKeyExchange;
import org.bouncycastle.crypto.tls.TlsPeer;
import org.bouncycastle.crypto.tls.TlsProtocol;
import org.bouncycastle.crypto.tls.TlsSignerCredentials;
import org.bouncycastle.crypto.tls.TlsUtils;
import org.bouncycastle.util.Arrays;

public class TlsClientProtocol
extends TlsProtocol {
    protected TlsClient tlsClient = null;
    protected TlsClientContextImpl tlsClientContext = null;
    protected int[] offeredCipherSuites = null;
    protected short[] offeredCompressionMethods = null;
    protected Hashtable clientExtensions = null;
    protected int selectedCipherSuite;
    protected short selectedCompressionMethod;
    protected TlsKeyExchange keyExchange = null;
    protected TlsAuthentication authentication = null;
    protected CertificateRequest certificateRequest = null;

    private static SecureRandom createSecureRandom() {
        ThreadedSeedGenerator threadedSeedGenerator = new ThreadedSeedGenerator();
        SecureRandom secureRandom = new SecureRandom();
        secureRandom.setSeed(threadedSeedGenerator.generateSeed(20, true));
        return secureRandom;
    }

    public TlsClientProtocol(InputStream inputStream, OutputStream outputStream) {
        this(inputStream, outputStream, TlsClientProtocol.createSecureRandom());
    }

    public TlsClientProtocol(InputStream inputStream, OutputStream outputStream, SecureRandom secureRandom) {
        super(inputStream, outputStream, secureRandom);
    }

    public void connect(TlsClient tlsClient) throws IOException {
        if (tlsClient == null) {
            throw new IllegalArgumentException("'tlsClient' cannot be null");
        }
        if (this.tlsClient != null) {
            throw new IllegalStateException("connect can only be called once");
        }
        this.tlsClient = tlsClient;
        this.securityParameters = new SecurityParameters();
        this.securityParameters.entity = 1;
        this.securityParameters.clientRandom = TlsClientProtocol.createRandomBlock(this.secureRandom);
        this.tlsClientContext = new TlsClientContextImpl(this.secureRandom, this.securityParameters);
        this.tlsClient.init(this.tlsClientContext);
        this.recordStream.init(this.tlsClientContext);
        this.sendClientHelloMessage();
        this.connection_state = 1;
        this.completeHandshake();
        this.tlsClient.notifyHandshakeComplete();
    }

    protected AbstractTlsContext getContext() {
        return this.tlsClientContext;
    }

    protected TlsPeer getPeer() {
        return this.tlsClient;
    }

    protected void handleChangeCipherSpecMessage() throws IOException {
        switch (this.connection_state) {
            case 13: {
                if (this.expectSessionTicket) {
                    this.failWithError((short)2, (short)40);
                }
            }
            case 14: {
                this.connection_state = (short)15;
                break;
            }
            default: {
                this.failWithError((short)2, (short)40);
            }
        }
    }

    protected void handleHandshakeMessage(short s, byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        block0 : switch (s) {
            case 11: {
                switch (this.connection_state) {
                    case 2: {
                        this.handleSupplementalData(null);
                    }
                    case 3: {
                        Certificate certificate = Certificate.parse(byteArrayInputStream);
                        TlsClientProtocol.assertEmpty(byteArrayInputStream);
                        this.keyExchange.processServerCertificate(certificate);
                        this.authentication = this.tlsClient.getAuthentication();
                        this.authentication.notifyServerCertificate(certificate);
                        break;
                    }
                    default: {
                        this.failWithError((short)2, (short)10);
                    }
                }
                this.connection_state = (short)4;
                break;
            }
            case 20: {
                switch (this.connection_state) {
                    case 15: {
                        this.processFinishedMessage(byteArrayInputStream);
                        this.connection_state = (short)16;
                        break block0;
                    }
                }
                this.failWithError((short)2, (short)10);
                break;
            }
            case 2: {
                switch (this.connection_state) {
                    case 1: {
                        this.receiveServerHelloMessage(byteArrayInputStream);
                        this.connection_state = (short)2;
                        this.securityParameters.prfAlgorithm = TlsClientProtocol.getPRFAlgorithm(this.selectedCipherSuite);
                        this.securityParameters.compressionAlgorithm = this.selectedCompressionMethod;
                        this.securityParameters.verifyDataLength = 12;
                        this.recordStream.notifyHelloComplete();
                        break block0;
                    }
                }
                this.failWithError((short)2, (short)10);
                break;
            }
            case 23: {
                switch (this.connection_state) {
                    case 2: {
                        this.handleSupplementalData(TlsClientProtocol.readSupplementalDataMessage(byteArrayInputStream));
                        break block0;
                    }
                }
                this.failWithError((short)2, (short)10);
                break;
            }
            case 14: {
                switch (this.connection_state) {
                    case 2: {
                        this.handleSupplementalData(null);
                    }
                    case 3: {
                        this.keyExchange.skipServerCredentials();
                        this.authentication = null;
                    }
                    case 4: {
                        this.keyExchange.skipServerKeyExchange();
                    }
                    case 5: 
                    case 6: {
                        TlsClientProtocol.assertEmpty(byteArrayInputStream);
                        this.connection_state = (short)7;
                        Vector vector = this.tlsClient.getClientSupplementalData();
                        if (vector != null) {
                            this.sendSupplementalDataMessage(vector);
                        }
                        this.connection_state = (short)8;
                        TlsCredentials tlsCredentials = null;
                        if (this.certificateRequest == null) {
                            this.keyExchange.skipClientCredentials();
                        } else {
                            tlsCredentials = this.authentication.getClientCredentials(this.certificateRequest);
                            if (tlsCredentials == null) {
                                this.keyExchange.skipClientCredentials();
                                this.sendCertificateMessage(Certificate.EMPTY_CHAIN);
                            } else {
                                this.keyExchange.processClientCredentials(tlsCredentials);
                                this.sendCertificateMessage(tlsCredentials.getCertificate());
                            }
                        }
                        this.connection_state = (short)9;
                        this.sendClientKeyExchangeMessage();
                        TlsClientProtocol.establishMasterSecret(this.getContext(), this.keyExchange);
                        this.recordStream.setPendingConnectionState(this.tlsClient.getCompression(), this.tlsClient.getCipher());
                        this.connection_state = (short)10;
                        if (tlsCredentials != null && tlsCredentials instanceof TlsSignerCredentials) {
                            TlsSignerCredentials tlsSignerCredentials = (TlsSignerCredentials)tlsCredentials;
                            byte[] byArray2 = this.recordStream.getCurrentHash(null);
                            byte[] byArray3 = tlsSignerCredentials.generateCertificateSignature(byArray2);
                            this.sendCertificateVerifyMessage(byArray3);
                            this.connection_state = (short)11;
                        }
                        this.sendChangeCipherSpecMessage();
                        this.connection_state = (short)12;
                        this.sendFinishedMessage();
                        this.connection_state = (short)13;
                        break block0;
                    }
                }
                this.failWithError((short)2, (short)40);
                break;
            }
            case 12: {
                switch (this.connection_state) {
                    case 2: {
                        this.handleSupplementalData(null);
                    }
                    case 3: {
                        this.keyExchange.skipServerCredentials();
                        this.authentication = null;
                    }
                    case 4: {
                        this.keyExchange.processServerKeyExchange(byteArrayInputStream);
                        TlsClientProtocol.assertEmpty(byteArrayInputStream);
                        break;
                    }
                    default: {
                        this.failWithError((short)2, (short)10);
                    }
                }
                this.connection_state = (short)5;
                break;
            }
            case 13: {
                switch (this.connection_state) {
                    case 4: {
                        this.keyExchange.skipServerKeyExchange();
                    }
                    case 5: {
                        if (this.authentication == null) {
                            this.failWithError((short)2, (short)40);
                        }
                        this.certificateRequest = CertificateRequest.parse(byteArrayInputStream);
                        TlsClientProtocol.assertEmpty(byteArrayInputStream);
                        this.keyExchange.validateCertificateRequest(this.certificateRequest);
                        break;
                    }
                    default: {
                        this.failWithError((short)2, (short)10);
                    }
                }
                this.connection_state = (short)6;
                break;
            }
            case 4: {
                switch (this.connection_state) {
                    case 13: {
                        if (!this.expectSessionTicket) {
                            this.failWithError((short)2, (short)10);
                        }
                        this.receiveNewSessionTicketMessage(byteArrayInputStream);
                        this.connection_state = (short)14;
                        break;
                    }
                    default: {
                        this.failWithError((short)2, (short)10);
                    }
                }
            }
            case 0: {
                TlsClientProtocol.assertEmpty(byteArrayInputStream);
                if (this.connection_state != 16) break;
                String string = "Renegotiation not supported";
                this.raiseWarning((short)100, string);
                break;
            }
            default: {
                this.failWithError((short)2, (short)10);
            }
        }
    }

    protected void handleSupplementalData(Vector vector) throws IOException {
        this.tlsClient.processServerSupplementalData(vector);
        this.connection_state = (short)3;
        this.keyExchange = this.tlsClient.getKeyExchange();
        this.keyExchange.init(this.getContext());
    }

    protected void receiveNewSessionTicketMessage(ByteArrayInputStream byteArrayInputStream) throws IOException {
        NewSessionTicket newSessionTicket = NewSessionTicket.parse(byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        this.tlsClient.notifyNewSessionTicket(newSessionTicket);
    }

    protected void receiveServerHelloMessage(ByteArrayInputStream byteArrayInputStream) throws IOException {
        ProtocolVersion protocolVersion;
        ProtocolVersion protocolVersion2 = TlsUtils.readVersion(byteArrayInputStream);
        if (protocolVersion2.isDTLS()) {
            this.failWithError((short)2, (short)47);
        }
        if (!protocolVersion2.equals(this.recordStream.getReadVersion())) {
            this.failWithError((short)2, (short)47);
        }
        if (!protocolVersion2.isEqualOrEarlierVersionOf(protocolVersion = this.getContext().getClientVersion())) {
            this.failWithError((short)2, (short)47);
        }
        this.recordStream.setWriteVersion(protocolVersion2);
        this.getContext().setServerVersion(protocolVersion2);
        this.tlsClient.notifyServerVersion(protocolVersion2);
        this.securityParameters.serverRandom = TlsUtils.readFully(32, (InputStream)byteArrayInputStream);
        byte[] byArray = TlsUtils.readOpaque8(byteArrayInputStream);
        if (byArray.length > 32) {
            this.failWithError((short)2, (short)47);
        }
        this.tlsClient.notifySessionID(byArray);
        this.selectedCipherSuite = TlsUtils.readUint16(byteArrayInputStream);
        if (!TlsClientProtocol.arrayContains(this.offeredCipherSuites, this.selectedCipherSuite) || this.selectedCipherSuite == 0 || this.selectedCipherSuite == 255) {
            this.failWithError((short)2, (short)47);
        }
        this.tlsClient.notifySelectedCipherSuite(this.selectedCipherSuite);
        short s = TlsUtils.readUint8(byteArrayInputStream);
        if (!TlsClientProtocol.arrayContains(this.offeredCompressionMethods, s)) {
            this.failWithError((short)2, (short)47);
        }
        this.tlsClient.notifySelectedCompressionMethod(s);
        Hashtable hashtable = TlsClientProtocol.readExtensions(byteArrayInputStream);
        if (hashtable != null) {
            Object object;
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                object = (Integer)enumeration.nextElement();
                if (((Integer)object).equals(EXT_RenegotiationInfo) || this.clientExtensions != null && this.clientExtensions.get(object) != null) continue;
                this.failWithError((short)2, (short)110);
            }
            object = (byte[])hashtable.get(EXT_RenegotiationInfo);
            if (object != null) {
                this.secure_renegotiation = true;
                if (!Arrays.constantTimeAreEqual((byte[])object, TlsClientProtocol.createRenegotiationInfo(TlsUtils.EMPTY_BYTES))) {
                    this.failWithError((short)2, (short)40);
                }
            }
            this.expectSessionTicket = hashtable.containsKey(EXT_SessionTicket);
        }
        this.tlsClient.notifySecureRenegotiation(this.secure_renegotiation);
        if (this.clientExtensions != null) {
            this.tlsClient.processServerExtensions(hashtable);
        }
    }

    protected void sendCertificateVerifyMessage(byte[] byArray) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        TlsUtils.writeUint8((short)15, byteArrayOutputStream);
        TlsUtils.writeUint24(byArray.length + 2, byteArrayOutputStream);
        TlsUtils.writeOpaque16(byArray, byteArrayOutputStream);
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        this.safeWriteRecord((short)22, byArray2, 0, byArray2.length);
    }

    protected void sendClientHelloMessage() throws IOException {
        this.recordStream.setWriteVersion(this.tlsClient.getClientHelloRecordLayerVersion());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        TlsUtils.writeUint8((short)1, byteArrayOutputStream);
        TlsUtils.writeUint24(0, byteArrayOutputStream);
        ProtocolVersion protocolVersion = this.tlsClient.getClientVersion();
        if (protocolVersion.isDTLS()) {
            this.failWithError((short)2, (short)80);
        }
        this.getContext().setClientVersion(protocolVersion);
        TlsUtils.writeVersion(protocolVersion, byteArrayOutputStream);
        byteArrayOutputStream.write(this.securityParameters.clientRandom);
        TlsUtils.writeOpaque8(TlsUtils.EMPTY_BYTES, byteArrayOutputStream);
        this.offeredCipherSuites = this.tlsClient.getCipherSuites();
        this.clientExtensions = this.tlsClient.getClientExtensions();
        boolean bl = this.clientExtensions == null || this.clientExtensions.get(EXT_RenegotiationInfo) == null;
        int n2 = this.offeredCipherSuites.length;
        if (bl) {
            ++n2;
        }
        TlsUtils.writeUint16(2 * n2, byteArrayOutputStream);
        TlsUtils.writeUint16Array(this.offeredCipherSuites, byteArrayOutputStream);
        if (bl) {
            TlsUtils.writeUint16(255, byteArrayOutputStream);
        }
        this.offeredCompressionMethods = this.tlsClient.getCompressionMethods();
        TlsUtils.writeUint8((short)this.offeredCompressionMethods.length, byteArrayOutputStream);
        TlsUtils.writeUint8Array(this.offeredCompressionMethods, byteArrayOutputStream);
        if (this.clientExtensions != null) {
            TlsClientProtocol.writeExtensions(byteArrayOutputStream, this.clientExtensions);
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        TlsUtils.writeUint24(byArray.length - 4, byArray, 1);
        this.safeWriteRecord((short)22, byArray, 0, byArray.length);
    }

    protected void sendClientKeyExchangeMessage() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        TlsUtils.writeUint8((short)16, byteArrayOutputStream);
        TlsUtils.writeUint24(0, byteArrayOutputStream);
        this.keyExchange.generateClientKeyExchange(byteArrayOutputStream);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        TlsUtils.writeUint24(byArray.length - 4, byArray, 1);
        this.safeWriteRecord((short)22, byArray, 0, byArray.length);
    }
}

