/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.tls;

import java.io.IOException;
import java.security.SecureRandom;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.crypto.tls.ProtocolVersion;
import org.bouncycastle.crypto.tls.TlsCipher;
import org.bouncycastle.crypto.tls.TlsContext;
import org.bouncycastle.crypto.tls.TlsFatalAlert;
import org.bouncycastle.crypto.tls.TlsMac;
import org.bouncycastle.crypto.tls.TlsUtils;
import org.bouncycastle.util.Arrays;

public class TlsBlockCipher
implements TlsCipher {
    protected TlsContext context;
    protected byte[] randomData;
    protected boolean useExplicitIV;
    protected BlockCipher encryptCipher;
    protected BlockCipher decryptCipher;
    protected TlsMac writeMac;
    protected TlsMac readMac;

    public TlsMac getWriteMac() {
        return this.writeMac;
    }

    public TlsMac getReadMac() {
        return this.readMac;
    }

    public TlsBlockCipher(TlsContext tlsContext, BlockCipher blockCipher, BlockCipher blockCipher2, Digest digest, Digest digest2, int n2) throws IOException {
        ParametersWithIV parametersWithIV;
        ParametersWithIV parametersWithIV2;
        byte[] byArray;
        byte[] byArray2;
        this.context = tlsContext;
        this.randomData = new byte[256];
        tlsContext.getSecureRandom().nextBytes(this.randomData);
        this.useExplicitIV = ProtocolVersion.TLSv11.isEqualOrEarlierVersionOf(tlsContext.getServerVersion().getEquivalentTLSVersion());
        int n3 = 2 * n2 + digest.getDigestSize() + digest2.getDigestSize();
        if (!this.useExplicitIV) {
            n3 += blockCipher.getBlockSize() + blockCipher2.getBlockSize();
        }
        byte[] byArray3 = TlsUtils.calculateKeyBlock(tlsContext, n3);
        int n4 = 0;
        TlsMac tlsMac = new TlsMac(tlsContext, digest, byArray3, n4, digest.getDigestSize());
        TlsMac tlsMac2 = new TlsMac(tlsContext, digest2, byArray3, n4 += digest.getDigestSize(), digest2.getDigestSize());
        KeyParameter keyParameter = new KeyParameter(byArray3, n4 += digest2.getDigestSize(), n2);
        KeyParameter keyParameter2 = new KeyParameter(byArray3, n4 += n2, n2);
        n4 += n2;
        if (this.useExplicitIV) {
            byArray2 = new byte[blockCipher.getBlockSize()];
            byArray = new byte[blockCipher2.getBlockSize()];
        } else {
            byArray2 = Arrays.copyOfRange(byArray3, n4, n4 + blockCipher.getBlockSize());
            byArray = Arrays.copyOfRange(byArray3, n4 += blockCipher.getBlockSize(), n4 + blockCipher2.getBlockSize());
            n4 += blockCipher2.getBlockSize();
        }
        if (n4 != n3) {
            throw new TlsFatalAlert(80);
        }
        if (tlsContext.isServer()) {
            this.writeMac = tlsMac2;
            this.readMac = tlsMac;
            this.encryptCipher = blockCipher2;
            this.decryptCipher = blockCipher;
            parametersWithIV2 = new ParametersWithIV(keyParameter2, byArray);
            parametersWithIV = new ParametersWithIV(keyParameter, byArray2);
        } else {
            this.writeMac = tlsMac;
            this.readMac = tlsMac2;
            this.encryptCipher = blockCipher;
            this.decryptCipher = blockCipher2;
            parametersWithIV2 = new ParametersWithIV(keyParameter, byArray2);
            parametersWithIV = new ParametersWithIV(keyParameter2, byArray);
        }
        this.encryptCipher.init(true, parametersWithIV2);
        this.decryptCipher.init(false, parametersWithIV);
    }

    public int getPlaintextLimit(int n2) {
        int n3 = this.encryptCipher.getBlockSize();
        int n4 = this.writeMac.getSize();
        int n5 = n2 - n2 % n3 - n4 - 1;
        if (this.useExplicitIV) {
            n5 -= n3;
        }
        return n5;
    }

    public byte[] encodePlaintext(long l2, short s, byte[] byArray, int n2, int n3) {
        int n4;
        byte[] byArray2;
        int n5;
        int n6 = this.encryptCipher.getBlockSize();
        int n7 = this.writeMac.getSize();
        ProtocolVersion protocolVersion = this.context.getServerVersion();
        int n8 = n6 - 1 - (n3 + n7) % n6;
        if (!protocolVersion.isDTLS() && !protocolVersion.isSSL()) {
            n5 = (255 - n8) / n6;
            int n9 = this.chooseExtraPadBlocks(this.context.getSecureRandom(), n5);
            n8 += n9 * n6;
        }
        n5 = n3 + n7 + n8 + 1;
        if (this.useExplicitIV) {
            n5 += n6;
        }
        byte[] byArray3 = new byte[n5];
        int n10 = 0;
        if (this.useExplicitIV) {
            byArray2 = new byte[n6];
            this.context.getSecureRandom().nextBytes(byArray2);
            this.encryptCipher.init(true, new ParametersWithIV(null, byArray2));
            System.arraycopy(byArray2, 0, byArray3, n10, n6);
            n10 += n6;
        }
        byArray2 = this.writeMac.calculateMac(l2, s, byArray, n2, n3);
        System.arraycopy(byArray, n2, byArray3, n10, n3);
        System.arraycopy(byArray2, 0, byArray3, n10 + n3, byArray2.length);
        int n11 = n10 + n3 + byArray2.length;
        for (n4 = 0; n4 <= n8; ++n4) {
            byArray3[n4 + n11] = (byte)n8;
        }
        for (n4 = n10; n4 < n5; n4 += n6) {
            this.encryptCipher.processBlock(byArray3, n4, byArray3, n4);
        }
        return byArray3;
    }

    public byte[] decodeCiphertext(long l2, short s, byte[] byArray, int n2, int n3) throws IOException {
        boolean bl;
        int n4;
        int n5 = this.decryptCipher.getBlockSize();
        int n6 = this.readMac.getSize();
        int n7 = Math.max(n5, n6 + 1);
        if (this.useExplicitIV) {
            n7 += n5;
        }
        if (n3 < n7) {
            throw new TlsFatalAlert(50);
        }
        if (n3 % n5 != 0) {
            throw new TlsFatalAlert(21);
        }
        if (this.useExplicitIV) {
            this.decryptCipher.init(false, new ParametersWithIV(null, byArray, n2, n5));
            n2 += n5;
            n3 -= n5;
        }
        for (n4 = 0; n4 < n3; n4 += n5) {
            this.decryptCipher.processBlock(byArray, n2 + n4, byArray, n2 + n4);
        }
        n4 = this.checkPaddingConstantTime(byArray, n2, n3, n5, n6);
        int n8 = n3 - n4 - n6;
        byte[] byArray2 = Arrays.copyOfRange(byArray, n2 + n8, n2 + n8 + n6);
        byte[] byArray3 = this.readMac.calculateMacConstantTime(l2, s, byArray, n2, n8, n3 - n6, this.randomData);
        boolean bl2 = bl = !Arrays.constantTimeAreEqual(byArray3, byArray2);
        if (bl || n4 == 0) {
            throw new TlsFatalAlert(20);
        }
        return Arrays.copyOfRange(byArray, n2, n2 + n8);
    }

    protected int checkPaddingConstantTime(byte[] byArray, int n2, int n3, int n4, int n5) {
        int n6 = n2 + n3;
        byte by = byArray[n6 - 1];
        int n7 = by & 0xFF;
        int n8 = n7 + 1;
        int n9 = 0;
        int n10 = 0;
        if (this.context.getServerVersion().isSSL() && n8 > n4 || n5 + n8 > n3) {
            n8 = 0;
        } else {
            int n11 = n6 - n8;
            do {
                n10 = (byte)(n10 | byArray[n11++] ^ by);
            } while (n11 < n6);
            n9 = n8;
            if (n10 != 0) {
                n8 = 0;
            }
        }
        byte[] byArray2 = this.randomData;
        while (n9 < 256) {
            n10 = (byte)(n10 | byArray2[n9++] ^ by);
        }
        byArray2[0] = (byte)(byArray2[0] ^ n10);
        return n8;
    }

    protected int chooseExtraPadBlocks(SecureRandom secureRandom, int n2) {
        int n3 = secureRandom.nextInt();
        int n4 = this.lowestBitSet(n3);
        return Math.min(n4, n2);
    }

    protected int lowestBitSet(int n2) {
        if (n2 == 0) {
            return 32;
        }
        int n3 = 0;
        while ((n2 & 1) == 0) {
            ++n3;
            n2 >>= 1;
        }
        return n3;
    }
}

