/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.tls;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.bouncycastle.crypto.tls.DTLSHandshakeRetransmit;
import org.bouncycastle.crypto.tls.DTLSReassembler;
import org.bouncycastle.crypto.tls.DTLSRecordLayer;
import org.bouncycastle.crypto.tls.DeferredHash;
import org.bouncycastle.crypto.tls.TlsContext;
import org.bouncycastle.crypto.tls.TlsFatalAlert;
import org.bouncycastle.crypto.tls.TlsHandshakeHash;
import org.bouncycastle.crypto.tls.TlsUtils;
import org.bouncycastle.util.Integers;

class DTLSReliableHandshake {
    private static final int MAX_RECEIVE_AHEAD = 10;
    private final DTLSRecordLayer recordLayer;
    private TlsHandshakeHash hash = new DeferredHash();
    private Hashtable currentInboundFlight = new Hashtable();
    private Hashtable previousInboundFlight = null;
    private Vector outboundFlight = new Vector();
    private boolean sending = true;
    private int message_seq = 0;
    private int next_receive_seq = 0;

    DTLSReliableHandshake(TlsContext tlsContext, DTLSRecordLayer dTLSRecordLayer) {
        this.recordLayer = dTLSRecordLayer;
        this.hash.init(tlsContext);
    }

    void notifyHelloComplete() {
        this.hash = this.hash.commit();
    }

    byte[] getCurrentHash() {
        TlsHandshakeHash tlsHandshakeHash = this.hash.fork();
        byte[] byArray = new byte[tlsHandshakeHash.getDigestSize()];
        tlsHandshakeHash.doFinal(byArray, 0);
        return byArray;
    }

    void sendMessage(short s, byte[] byArray) throws IOException {
        if (!this.sending) {
            this.checkInboundFlight();
            this.sending = true;
            this.outboundFlight.removeAllElements();
        }
        Message message = new Message(this.message_seq++, s, byArray);
        this.outboundFlight.addElement(message);
        this.writeMessage(message);
        this.updateHandshakeMessagesDigest(message);
    }

    Message receiveMessage() throws IOException {
        byte[] byArray;
        Object object;
        if (this.sending) {
            this.sending = false;
            this.prepareInboundFlight();
        }
        if ((object = (DTLSReassembler)this.currentInboundFlight.get(Integers.valueOf(this.next_receive_seq))) != null && (byArray = ((DTLSReassembler)object).getBodyIfComplete()) != null) {
            this.previousInboundFlight = null;
            return this.updateHandshakeMessagesDigest(new Message(this.next_receive_seq++, ((DTLSReassembler)object).getType(), byArray));
        }
        object = null;
        int n2 = 1000;
        while (true) {
            int n3 = this.recordLayer.getReceiveLimit();
            if (object == null || ((DTLSReassembler)object).length < n3) {
                object = new byte[n3];
            }
            try {
                int n4;
                while ((n4 = this.recordLayer.receive((byte[])object, 0, n3, n2)) >= 0) {
                    byte[] byArray2;
                    DTLSReassembler dTLSReassembler;
                    int n5;
                    int n6;
                    if (n4 < 12 || n4 != (n6 = TlsUtils.readUint24((byte[])object, 9)) + 12 || (n5 = TlsUtils.readUint16((byte[])object, 4)) > this.next_receive_seq + 10) continue;
                    short s = TlsUtils.readUint8((byte[])object, 0);
                    int n7 = TlsUtils.readUint24((byte[])object, 1);
                    int n8 = TlsUtils.readUint24((byte[])object, 6);
                    if (n8 + n6 > n7) continue;
                    if (n5 < this.next_receive_seq) {
                        if (this.previousInboundFlight == null || (dTLSReassembler = (DTLSReassembler)this.previousInboundFlight.get(Integers.valueOf(n5))) == null) continue;
                        dTLSReassembler.contributeFragment(s, n7, (byte[])object, 12, n8, n6);
                        if (!DTLSReliableHandshake.checkAll(this.previousInboundFlight)) continue;
                        this.resendOutboundFlight();
                        n2 = Math.min(n2 * 2, 60000);
                        DTLSReliableHandshake.resetAll(this.previousInboundFlight);
                        continue;
                    }
                    dTLSReassembler = (DTLSReassembler)this.currentInboundFlight.get(Integers.valueOf(n5));
                    if (dTLSReassembler == null) {
                        dTLSReassembler = new DTLSReassembler(s, n7);
                        this.currentInboundFlight.put(Integers.valueOf(n5), dTLSReassembler);
                    }
                    dTLSReassembler.contributeFragment(s, n7, (byte[])object, 12, n8, n6);
                    if (n5 != this.next_receive_seq || (byArray2 = dTLSReassembler.getBodyIfComplete()) == null) continue;
                    this.previousInboundFlight = null;
                    return this.updateHandshakeMessagesDigest(new Message(this.next_receive_seq++, dTLSReassembler.getType(), byArray2));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.resendOutboundFlight();
            n2 = Math.min(n2 * 2, 60000);
        }
    }

    void finish() {
        DTLSHandshakeRetransmit dTLSHandshakeRetransmit = null;
        if (!this.sending) {
            this.checkInboundFlight();
        } else if (this.currentInboundFlight != null) {
            dTLSHandshakeRetransmit = new DTLSHandshakeRetransmit(){

                public void receivedHandshakeRecord(int n2, byte[] byArray, int n3, int n4) throws IOException {
                    int n5;
                    if (n4 < 12) {
                        return;
                    }
                    int n6 = TlsUtils.readUint24(byArray, n3 + 9);
                    if (n4 != n6 + 12) {
                        return;
                    }
                    int n7 = TlsUtils.readUint16(byArray, n3 + 4);
                    if (n7 >= DTLSReliableHandshake.this.next_receive_seq) {
                        return;
                    }
                    short s = TlsUtils.readUint8(byArray, n3);
                    int n8 = n5 = s == 20 ? 1 : 0;
                    if (n2 != n5) {
                        return;
                    }
                    int n9 = TlsUtils.readUint24(byArray, n3 + 1);
                    int n10 = TlsUtils.readUint24(byArray, n3 + 6);
                    if (n10 + n6 > n9) {
                        return;
                    }
                    DTLSReassembler dTLSReassembler = (DTLSReassembler)DTLSReliableHandshake.this.currentInboundFlight.get(Integers.valueOf(n7));
                    if (dTLSReassembler != null) {
                        dTLSReassembler.contributeFragment(s, n9, byArray, n3 + 12, n10, n6);
                        if (DTLSReliableHandshake.checkAll(DTLSReliableHandshake.this.currentInboundFlight)) {
                            DTLSReliableHandshake.this.resendOutboundFlight();
                            DTLSReliableHandshake.resetAll(DTLSReliableHandshake.this.currentInboundFlight);
                        }
                    }
                }
            };
        }
        this.recordLayer.handshakeSuccessful(dTLSHandshakeRetransmit);
    }

    void resetHandshakeMessagesDigest() {
        this.hash.reset();
    }

    private void checkInboundFlight() {
        Enumeration enumeration = this.currentInboundFlight.keys();
        while (enumeration.hasMoreElements()) {
            Integer n2 = (Integer)enumeration.nextElement();
            if (n2 < this.next_receive_seq) continue;
        }
    }

    private void prepareInboundFlight() {
        DTLSReliableHandshake.resetAll(this.currentInboundFlight);
        this.previousInboundFlight = this.currentInboundFlight;
        this.currentInboundFlight = new Hashtable();
    }

    private void resendOutboundFlight() throws IOException {
        this.recordLayer.resetWriteEpoch();
        for (int i2 = 0; i2 < this.outboundFlight.size(); ++i2) {
            this.writeMessage((Message)this.outboundFlight.elementAt(i2));
        }
    }

    private Message updateHandshakeMessagesDigest(Message message) throws IOException {
        if (message.getType() != 0) {
            byte[] byArray = message.getBody();
            byte[] byArray2 = new byte[12];
            TlsUtils.writeUint8(message.getType(), byArray2, 0);
            TlsUtils.writeUint24(byArray.length, byArray2, 1);
            TlsUtils.writeUint16(message.getSeq(), byArray2, 4);
            TlsUtils.writeUint24(0, byArray2, 6);
            TlsUtils.writeUint24(byArray.length, byArray2, 9);
            this.hash.update(byArray2, 0, byArray2.length);
            this.hash.update(byArray, 0, byArray.length);
        }
        return message;
    }

    private void writeMessage(Message message) throws IOException {
        int n2;
        int n3 = this.recordLayer.getSendLimit();
        int n4 = n3 - 12;
        if (n4 < 1) {
            throw new TlsFatalAlert(80);
        }
        int n5 = message.getBody().length;
        int n6 = 0;
        do {
            n2 = Math.min(n5 - n6, n4);
            this.writeHandshakeFragment(message, n6, n2);
        } while ((n6 += n2) < n5);
    }

    private void writeHandshakeFragment(Message message, int n2, int n3) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        TlsUtils.writeUint8(message.getType(), byteArrayOutputStream);
        TlsUtils.writeUint24(message.getBody().length, byteArrayOutputStream);
        TlsUtils.writeUint16(message.getSeq(), byteArrayOutputStream);
        TlsUtils.writeUint24(n2, byteArrayOutputStream);
        TlsUtils.writeUint24(n3, byteArrayOutputStream);
        byteArrayOutputStream.write(message.getBody(), n2, n3);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        this.recordLayer.send(byArray, 0, byArray.length);
    }

    private static boolean checkAll(Hashtable hashtable) {
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            if (((DTLSReassembler)enumeration.nextElement()).getBodyIfComplete() != null) continue;
            return false;
        }
        return true;
    }

    private static void resetAll(Hashtable hashtable) {
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            ((DTLSReassembler)enumeration.nextElement()).reset();
        }
    }

    static class Message {
        private final int message_seq;
        private final short msg_type;
        private final byte[] body;

        private Message(int n2, short s, byte[] byArray) {
            this.message_seq = n2;
            this.msg_type = s;
            this.body = byArray;
        }

        public int getSeq() {
            return this.message_seq;
        }

        public short getType() {
            return this.msg_type;
        }

        public byte[] getBody() {
            return this.body;
        }
    }
}

