/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.tls;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.crypto.tls.TlsProtocol;
import org.bouncycastle.crypto.tls.TlsUtils;

public class Certificate {
    public static final Certificate EMPTY_CHAIN = new Certificate(new org.bouncycastle.asn1.x509.Certificate[0]);
    protected org.bouncycastle.asn1.x509.Certificate[] certificateList;

    public Certificate(org.bouncycastle.asn1.x509.Certificate[] certificateArray) {
        if (certificateArray == null) {
            throw new IllegalArgumentException("'certificateList' cannot be null");
        }
        this.certificateList = certificateArray;
    }

    public org.bouncycastle.asn1.x509.Certificate[] getCerts() {
        return this.clone(this.certificateList);
    }

    public org.bouncycastle.asn1.x509.Certificate[] getCertificateList() {
        return this.clone(this.certificateList);
    }

    public org.bouncycastle.asn1.x509.Certificate getCertificateAt(int n2) {
        return this.certificateList[n2];
    }

    public int getLength() {
        return this.certificateList.length;
    }

    public boolean isEmpty() {
        return this.certificateList.length == 0;
    }

    public void encode(OutputStream outputStream) throws IOException {
        byte[] byArray;
        int n2;
        Vector<byte[]> vector = new Vector<byte[]>(this.certificateList.length);
        int n3 = 0;
        for (n2 = 0; n2 < this.certificateList.length; ++n2) {
            byArray = this.certificateList[n2].getEncoded("DER");
            vector.addElement(byArray);
            n3 += byArray.length + 3;
        }
        TlsUtils.writeUint24(n3, outputStream);
        for (n2 = 0; n2 < vector.size(); ++n2) {
            byArray = (byte[])vector.elementAt(n2);
            TlsUtils.writeOpaque24(byArray, outputStream);
        }
    }

    public static Certificate parse(InputStream inputStream) throws IOException {
        int n2;
        int n3 = TlsUtils.readUint24(inputStream);
        if (n3 == 0) {
            return EMPTY_CHAIN;
        }
        Vector<org.bouncycastle.asn1.x509.Certificate> vector = new Vector<org.bouncycastle.asn1.x509.Certificate>();
        while (n3 > 0) {
            n2 = TlsUtils.readUint24(inputStream);
            n3 -= 3 + n2;
            byte[] byArray = TlsUtils.readFully(n2, inputStream);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ASN1Primitive aSN1Primitive = new ASN1InputStream(byteArrayInputStream).readObject();
            TlsProtocol.assertEmpty(byteArrayInputStream);
            vector.addElement(org.bouncycastle.asn1.x509.Certificate.getInstance(aSN1Primitive));
        }
        org.bouncycastle.asn1.x509.Certificate[] certificateArray = new org.bouncycastle.asn1.x509.Certificate[vector.size()];
        for (n2 = 0; n2 < vector.size(); ++n2) {
            certificateArray[n2] = (org.bouncycastle.asn1.x509.Certificate)vector.elementAt(n2);
        }
        return new Certificate(certificateArray);
    }

    private org.bouncycastle.asn1.x509.Certificate[] clone(org.bouncycastle.asn1.x509.Certificate[] certificateArray) {
        org.bouncycastle.asn1.x509.Certificate[] certificateArray2 = new org.bouncycastle.asn1.x509.Certificate[certificateArray.length];
        System.arraycopy(certificateArray, 0, certificateArray2, 0, certificateArray2.length);
        return certificateArray2;
    }
}

